/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import net.sf.composite.util.ClassUtils;
import net.sf.composite.util.IdentityStack;
import net.sf.composite.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectUtils {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$composite$util$ObjectUtils == null ? (class$net$sf$composite$util$ObjectUtils = ObjectUtils.class$("net.sf.composite.util.ObjectUtils")) : class$net$sf$composite$util$ObjectUtils));
    private static ThreadLocal objectsBeingDescribed = new ThreadLocal(){

        protected Object initialValue() {
            return new IdentityStack();
        }
    };
    static /* synthetic */ Class class$net$sf$composite$util$ObjectUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getObjectDescription(Object object) {
        if (object == null) {
            return "null";
        }
        try {
            String result;
            if (object instanceof Calendar) {
                return ((Calendar)object).getTime().toString() + " (class " + object.getClass() + ")";
            }
            if (object instanceof Class && ((Class)object).isArray()) {
                return "(array of " + ObjectUtils.getObjectDescription(ClassUtils.getContainedClass((Class)object)) + ")";
            }
            if (object instanceof Class) {
                return "(" + object.toString() + ")";
            }
            if (object.getClass().isArray()) {
                return ObjectUtils.getArrayDescription(object) + " " + ObjectUtils.getObjectDescription(object.getClass());
            }
            Stack stack = (Stack)objectsBeingDescribed.get();
            if (stack.contains(object)) {
                return ObjectUtils.getDelimiter(object) + "Nested" + object.getClass().getName();
            }
            stack.push(object);
            try {
                result = ObjectUtils.getDelimiter(object) + object + ObjectUtils.getDelimiter(object) + " (class " + object.getClass().getName() + ")";
            }
            finally {
                if (object != stack.pop()) {
                    throw new IllegalStateException("Unexpected " + object.getClass().getName());
                }
            }
            return result;
        }
        catch (Throwable t) {
            String message = "Could not construct String representation of instance of '" + object.getClass().getName() + "'";
            if (log.isErrorEnabled()) {
                log.error((Object)message, t);
            }
            return "[ERROR: " + message + "'.  Exception message was '" + t.getMessage() + "']";
        }
    }

    private static String getArrayDescription(Object array) {
        ArrayList<Object> toJoin = new ArrayList<Object>();
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object value = Array.get(array, i);
            if (value != null && value.getClass().isArray()) {
                toJoin.add(ObjectUtils.getArrayDescription(value));
                continue;
            }
            toJoin.add(value);
        }
        return "[" + StringUtils.join(toJoin, ", ") + "]";
    }

    private static String getDelimiter(Object object) {
        return object instanceof Character ? "'" : (object instanceof String ? "\"" : "");
    }

    public static boolean isEmpty(Object object) {
        return object == null || "".equals(object) || object.getClass().isArray() && Array.getLength(object) == 0 || object instanceof Collection && ((Collection)object).isEmpty() || object instanceof Map && ((Map)object).isEmpty() || object instanceof StringBuffer && ((StringBuffer)object).length() == 0;
    }

    public static boolean equals(Object object1, Object object2) {
        return object1 == object2 || object1 != null && object1.equals(object2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

