/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.validate.validators;

import net.sf.composite.Defaults;
import net.sf.composite.extract.ComponentAccessor;
import net.sf.composite.util.Assert;
import net.sf.composite.util.ObjectUtils;
import net.sf.composite.validate.ComponentValidationException;
import net.sf.composite.validate.ComponentValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseCompositeValidator
implements ComponentValidator {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ComponentAccessor componentAccessor;

    protected abstract void validateImpl(Object var1) throws Exception;

    public final void validate(Object composite) throws ComponentValidationException {
        Assert.notNull(composite, "composite");
        try {
            this.validateImpl(composite);
        }
        catch (ComponentValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ComponentValidationException("Unable to determine if composite " + ObjectUtils.getObjectDescription(composite) + " is valid", e);
        }
    }

    public ComponentAccessor getComponentAccessor() {
        if (this.componentAccessor == null) {
            this.setComponentAccessor(Defaults.createComponentAccessor());
        }
        return this.componentAccessor;
    }

    public void setComponentAccessor(ComponentAccessor componentAccessor) {
        this.componentAccessor = componentAccessor;
    }
}

