/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.validate.validators;

import java.util.List;
import net.sf.composite.StrictlyTypedComposite;
import net.sf.composite.composites.CompositeDecorator;
import net.sf.composite.util.ObjectUtils;
import net.sf.composite.validate.ComponentValidationException;
import net.sf.composite.validate.validators.BaseCompositeValidator;

public class SimpleComponentValidator
extends BaseCompositeValidator {
    protected void validateImpl(Object composite) throws Exception {
        List components = this.getComponentAccessor().getComponents(composite);
        if (components == null) {
            throw new ComponentValidationException(composite, "components cannot be null");
        }
        for (int i = 0; i < components.size(); ++i) {
            if (components.get(i) != null) continue;
            if (composite instanceof CompositeDecorator) {
                composite = ((CompositeDecorator)composite).getComposite();
            }
            throw new ComponentValidationException(composite, "all components in a composite must be non-null but the component at index " + i + " is null");
        }
        if (composite instanceof StrictlyTypedComposite) {
            StrictlyTypedComposite stc = (StrictlyTypedComposite)composite;
            for (int i = 0; i < components.size(); ++i) {
                Object component = components.get(i);
                Class componentType = stc.getComponentType();
                if (componentType.isAssignableFrom(component.getClass())) continue;
                throw new ComponentValidationException(composite, "the component at index " + i + ", " + ObjectUtils.getObjectDescription(component) + ", does not implement " + ObjectUtils.getObjectDescription(stc.getComponentType()));
            }
        }
    }
}

