/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.common.plugins.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import net.wasdev.wlp.common.plugins.config.XmlDocument;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class ServerFeatureUtil {
    public static final String OPEN_LIBERTY_GROUP_ID = "io.openliberty.features";
    public static final String REPOSITORY_RESOLVER_ARTIFACT_ID = "repository-resolver";
    public static final String INSTALL_MAP_ARTIFACT_ID = "install-map";
    private static final int COPY_FILE_TIMEOUT_MILLIS = 300000;

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void debug(Throwable var1);

    public abstract void warn(String var1);

    public abstract void info(String var1);

    public Set<String> getServerFeatures(File serverDirectory) {
        Set<String> result = this.getConfigDropinsFeatures(null, serverDirectory, "defaults");
        result = this.getServerXmlFeatures(result, new File(serverDirectory, "server.xml"), null);
        return this.getConfigDropinsFeatures(result, serverDirectory, "overrides");
    }

    private Set<String> getConfigDropinsFeatures(Set<String> origResult, File serverDirectory, String folderName) {
        File configDropinsFolder;
        Set<String> result = origResult;
        try {
            configDropinsFolder = new File(new File(serverDirectory, "configDropins"), folderName).getCanonicalFile();
        }
        catch (IOException e) {
            this.warn("The " + serverDirectory + "/configDropins/" + folderName + " directory cannot be accessed. Skipping its server features.");
            this.debug(e);
            return result;
        }
        File[] configDropinsXmls = configDropinsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        if (configDropinsXmls == null || configDropinsXmls.length == 0) {
            return result;
        }
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File left, File right) {
                return left.getAbsolutePath().toLowerCase().compareTo(right.getAbsolutePath().toLowerCase());
            }
        };
        Collections.sort(Arrays.asList(configDropinsXmls), comparator);
        for (File xml : configDropinsXmls) {
            Set<String> features = this.getServerXmlFeatures(result, xml, null);
            if (features == null) continue;
            result = features;
        }
        return result;
    }

    private Set<String> getServerXmlFeatures(Set<String> origResult, File serverFile, List<File> parsedXmls) {
        File canonicalServerFile;
        Set<String> result = origResult;
        ArrayList<File> updatedParsedXmls = parsedXmls != null ? parsedXmls : new ArrayList<File>();
        try {
            canonicalServerFile = serverFile.getCanonicalFile();
        }
        catch (IOException e) {
            this.warn("The server file " + serverFile + " cannot be accessed. Skipping its features.");
            this.debug(e);
            return result;
        }
        updatedParsedXmls.add(canonicalServerFile);
        if (canonicalServerFile.exists()) {
            try {
                Document doc = new XmlDocument(){

                    public Document getDocument(File file) throws IOException, ParserConfigurationException, SAXException {
                        this.createDocument(file);
                        return this.doc;
                    }
                }.getDocument(canonicalServerFile);
                Element root = doc.getDocumentElement();
                NodeList nodes = root.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    if (!(nodes.item(i) instanceof Element)) continue;
                    Element child = (Element)nodes.item(i);
                    if ("featureManager".equals(child.getNodeName())) {
                        if (result == null) {
                            result = new HashSet<String>();
                        }
                        result.addAll(ServerFeatureUtil.parseFeatureManagerNode(child));
                        continue;
                    }
                    if (!"include".equals(child.getNodeName())) continue;
                    result = this.parseIncludeNode(result, canonicalServerFile, child, updatedParsedXmls);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                this.warn("The server file " + serverFile + " cannot be parsed. Skipping its features.");
                this.debug(e);
                return result;
            }
        }
        return result;
    }

    private static Set<String> parseFeatureManagerNode(Element node) {
        HashSet<String> result = new HashSet<String>();
        NodeList features = node.getElementsByTagName("feature");
        if (features != null) {
            for (int j = 0; j < features.getLength(); ++j) {
                String content = features.item(j).getTextContent();
                if (content == null) continue;
                if (content.contains(":")) {
                    String[] split = content.split(":", 2);
                    result.add(split[1].trim().toLowerCase());
                    continue;
                }
                result.add(content.trim().toLowerCase());
            }
        }
        return result;
    }

    private Set<String> parseIncludeNode(Set<String> origResult, File serverFile, Element node, List<File> updatedParsedXmls) {
        Set<String> result = origResult;
        String includeFileName = node.getAttribute("location");
        if (includeFileName == null || includeFileName.trim().isEmpty()) {
            return result;
        }
        File includeFile = null;
        if (ServerFeatureUtil.isURL(includeFileName)) {
            try {
                File tempFile = File.createTempFile("serverFromURL", ".xml");
                FileUtils.copyURLToFile((URL)new URL(includeFileName), (File)tempFile, (int)300000, (int)300000);
                includeFile = tempFile;
            }
            catch (IOException e) {
                this.warn("The server file " + serverFile + " includes a URL " + includeFileName + " that cannot be accessed. Skipping the included features.");
                this.debug(e);
                return result;
            }
        } else {
            includeFile = new File(includeFileName);
        }
        try {
            includeFile = !includeFile.isAbsolute() ? new File(serverFile.getParentFile().getAbsolutePath(), includeFileName).getCanonicalFile() : includeFile.getCanonicalFile();
        }
        catch (IOException e) {
            this.warn("The server file " + serverFile + " includes a file " + includeFileName + " that cannot be accessed. Skipping the included features.");
            this.debug(e);
            return result;
        }
        if (!updatedParsedXmls.contains(includeFile)) {
            String onConflict = node.getAttribute("onConflict");
            Set<String> features = this.getServerXmlFeatures(null, includeFile, updatedParsedXmls);
            result = this.handleOnConflict(result, onConflict, features);
        }
        return result;
    }

    private static boolean isURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    private Set<String> handleOnConflict(Set<String> origResult, String onConflict, Set<String> features) {
        Set<String> result = origResult;
        if ("replace".equalsIgnoreCase(onConflict)) {
            if (features != null && !features.isEmpty()) {
                result = features;
            }
        } else if ("ignore".equalsIgnoreCase(onConflict)) {
            if (result == null) {
                result = features;
            }
        } else if (features != null) {
            if (result == null) {
                result = features;
            } else {
                result.addAll(features);
            }
        }
        return result;
    }
}

