

/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.arrow.vector.complex.impl;


import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import com.google.flatbuffers.FlatBufferBuilder;

import com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.arrow.memory.*;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.Types.*;
import org.apache.arrow.vector.types.pojo.*;
import org.apache.arrow.vector.types.pojo.ArrowType.*;
import org.apache.arrow.vector.types.*;
import org.apache.arrow.vector.*;
import org.apache.arrow.vector.holders.*;
import org.apache.arrow.vector.util.*;
import org.apache.arrow.vector.complex.*;
import org.apache.arrow.vector.complex.reader.*;
import org.apache.arrow.vector.complex.impl.*;
import org.apache.arrow.vector.complex.writer.*;
import org.apache.arrow.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.arrow.vector.util.JsonStringArrayList;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;







/*
 * A FieldWriter which delegates calls to another FieldWriter. The delegate FieldWriter can be promoted to a new type
 * when necessary. Classes that extend this class are responsible for handling promotion.
 *
 * This class is generated using freemarker and the AbstractPromotableFieldWriter.java template.
 *
 */
@SuppressWarnings("unused")
abstract class AbstractPromotableFieldWriter extends AbstractFieldWriter {
  /**
   * Retrieve the FieldWriter, promoting if it is not a FieldWriter of the specified type
   * @param type the type of the values we want to write
   * @return the corresponding field writer
   */
  abstract protected FieldWriter getWriter(MinorType type);

  /**
   * @return the current FieldWriter
   */
  abstract protected FieldWriter getWriter();

  @Override
  public void start() {
    getWriter(MinorType.MAP).start();
  }

  @Override
  public void end() {
    getWriter(MinorType.MAP).end();
    setPosition(idx() + 1);
  }

  @Override
  public void startList() {
    getWriter(MinorType.LIST).startList();
  }

  @Override
  public void endList() {
    getWriter(MinorType.LIST).endList();
    setPosition(idx() + 1);
  }

  @Override
  public void write(TinyIntHolder holder) {
    getWriter(MinorType.TINYINT).write(holder);
  }

  public void writeTinyInt(byte value) {
    getWriter(MinorType.TINYINT).writeTinyInt(value);
  }

  @Override
  public void write(UInt1Holder holder) {
    getWriter(MinorType.UINT1).write(holder);
  }

  public void writeUInt1(byte value) {
    getWriter(MinorType.UINT1).writeUInt1(value);
  }

  @Override
  public void write(UInt2Holder holder) {
    getWriter(MinorType.UINT2).write(holder);
  }

  public void writeUInt2(char value) {
    getWriter(MinorType.UINT2).writeUInt2(value);
  }

  @Override
  public void write(SmallIntHolder holder) {
    getWriter(MinorType.SMALLINT).write(holder);
  }

  public void writeSmallInt(short value) {
    getWriter(MinorType.SMALLINT).writeSmallInt(value);
  }

  @Override
  public void write(IntHolder holder) {
    getWriter(MinorType.INT).write(holder);
  }

  public void writeInt(int value) {
    getWriter(MinorType.INT).writeInt(value);
  }

  @Override
  public void write(UInt4Holder holder) {
    getWriter(MinorType.UINT4).write(holder);
  }

  public void writeUInt4(int value) {
    getWriter(MinorType.UINT4).writeUInt4(value);
  }

  @Override
  public void write(Float4Holder holder) {
    getWriter(MinorType.FLOAT4).write(holder);
  }

  public void writeFloat4(float value) {
    getWriter(MinorType.FLOAT4).writeFloat4(value);
  }

  @Override
  public void write(DateDayHolder holder) {
    getWriter(MinorType.DATEDAY).write(holder);
  }

  public void writeDateDay(int value) {
    getWriter(MinorType.DATEDAY).writeDateDay(value);
  }

  @Override
  public void write(IntervalYearHolder holder) {
    getWriter(MinorType.INTERVALYEAR).write(holder);
  }

  public void writeIntervalYear(int value) {
    getWriter(MinorType.INTERVALYEAR).writeIntervalYear(value);
  }

  @Override
  public void write(TimeSecHolder holder) {
    getWriter(MinorType.TIMESEC).write(holder);
  }

  public void writeTimeSec(int value) {
    getWriter(MinorType.TIMESEC).writeTimeSec(value);
  }

  @Override
  public void write(TimeMilliHolder holder) {
    getWriter(MinorType.TIMEMILLI).write(holder);
  }

  public void writeTimeMilli(int value) {
    getWriter(MinorType.TIMEMILLI).writeTimeMilli(value);
  }

  @Override
  public void write(BigIntHolder holder) {
    getWriter(MinorType.BIGINT).write(holder);
  }

  public void writeBigInt(long value) {
    getWriter(MinorType.BIGINT).writeBigInt(value);
  }

  @Override
  public void write(UInt8Holder holder) {
    getWriter(MinorType.UINT8).write(holder);
  }

  public void writeUInt8(long value) {
    getWriter(MinorType.UINT8).writeUInt8(value);
  }

  @Override
  public void write(Float8Holder holder) {
    getWriter(MinorType.FLOAT8).write(holder);
  }

  public void writeFloat8(double value) {
    getWriter(MinorType.FLOAT8).writeFloat8(value);
  }

  @Override
  public void write(DateMilliHolder holder) {
    getWriter(MinorType.DATEMILLI).write(holder);
  }

  public void writeDateMilli(long value) {
    getWriter(MinorType.DATEMILLI).writeDateMilli(value);
  }

  @Override
  public void write(TimeStampSecHolder holder) {
    getWriter(MinorType.TIMESTAMPSEC).write(holder);
  }

  public void writeTimeStampSec(long value) {
    getWriter(MinorType.TIMESTAMPSEC).writeTimeStampSec(value);
  }

  @Override
  public void write(TimeStampMilliHolder holder) {
    getWriter(MinorType.TIMESTAMPMILLI).write(holder);
  }

  public void writeTimeStampMilli(long value) {
    getWriter(MinorType.TIMESTAMPMILLI).writeTimeStampMilli(value);
  }

  @Override
  public void write(TimeStampMicroHolder holder) {
    getWriter(MinorType.TIMESTAMPMICRO).write(holder);
  }

  public void writeTimeStampMicro(long value) {
    getWriter(MinorType.TIMESTAMPMICRO).writeTimeStampMicro(value);
  }

  @Override
  public void write(TimeStampNanoHolder holder) {
    getWriter(MinorType.TIMESTAMPNANO).write(holder);
  }

  public void writeTimeStampNano(long value) {
    getWriter(MinorType.TIMESTAMPNANO).writeTimeStampNano(value);
  }

  @Override
  public void write(TimeStampSecTZHolder holder) {
    getWriter(MinorType.TIMESTAMPSECTZ).write(holder);
  }

  public void writeTimeStampSecTZ(long value) {
    getWriter(MinorType.TIMESTAMPSECTZ).writeTimeStampSecTZ(value);
  }

  @Override
  public void write(TimeStampMilliTZHolder holder) {
    getWriter(MinorType.TIMESTAMPMILLITZ).write(holder);
  }

  public void writeTimeStampMilliTZ(long value) {
    getWriter(MinorType.TIMESTAMPMILLITZ).writeTimeStampMilliTZ(value);
  }

  @Override
  public void write(TimeStampMicroTZHolder holder) {
    getWriter(MinorType.TIMESTAMPMICROTZ).write(holder);
  }

  public void writeTimeStampMicroTZ(long value) {
    getWriter(MinorType.TIMESTAMPMICROTZ).writeTimeStampMicroTZ(value);
  }

  @Override
  public void write(TimeStampNanoTZHolder holder) {
    getWriter(MinorType.TIMESTAMPNANOTZ).write(holder);
  }

  public void writeTimeStampNanoTZ(long value) {
    getWriter(MinorType.TIMESTAMPNANOTZ).writeTimeStampNanoTZ(value);
  }

  @Override
  public void write(TimeMicroHolder holder) {
    getWriter(MinorType.TIMEMICRO).write(holder);
  }

  public void writeTimeMicro(long value) {
    getWriter(MinorType.TIMEMICRO).writeTimeMicro(value);
  }

  @Override
  public void write(TimeNanoHolder holder) {
    getWriter(MinorType.TIMENANO).write(holder);
  }

  public void writeTimeNano(long value) {
    getWriter(MinorType.TIMENANO).writeTimeNano(value);
  }

  @Override
  public void write(IntervalDayHolder holder) {
    getWriter(MinorType.INTERVALDAY).write(holder);
  }

  public void writeIntervalDay(int days, int milliseconds) {
    getWriter(MinorType.INTERVALDAY).writeIntervalDay(days, milliseconds);
  }

  @Override
  public void write(DecimalHolder holder) {
    getWriter(MinorType.DECIMAL).write(holder);
  }

  public void writeDecimal(int start, ArrowBuf buffer) {
    getWriter(MinorType.DECIMAL).writeDecimal(start, buffer);
  }

  @Override
  public void write(VarBinaryHolder holder) {
    getWriter(MinorType.VARBINARY).write(holder);
  }

  public void writeVarBinary(int start, int end, ArrowBuf buffer) {
    getWriter(MinorType.VARBINARY).writeVarBinary(start, end, buffer);
  }

  @Override
  public void write(VarCharHolder holder) {
    getWriter(MinorType.VARCHAR).write(holder);
  }

  public void writeVarChar(int start, int end, ArrowBuf buffer) {
    getWriter(MinorType.VARCHAR).writeVarChar(start, end, buffer);
  }

  @Override
  public void write(BitHolder holder) {
    getWriter(MinorType.BIT).write(holder);
  }

  public void writeBit(int value) {
    getWriter(MinorType.BIT).writeBit(value);
  }

  public void writeNull() {
  }

  @Override
  public MapWriter map() {
    return getWriter(MinorType.LIST).map();
  }

  @Override
  public ListWriter list() {
    return getWriter(MinorType.LIST).list();
  }

  @Override
  public MapWriter map(String name) {
    return getWriter(MinorType.MAP).map(name);
  }

  @Override
  public ListWriter list(String name) {
    return getWriter(MinorType.MAP).list(name);
  }


  @Override
  public TinyIntWriter tinyInt(String name) {
    return getWriter(MinorType.MAP).tinyInt(name);
  }

  @Override
  public TinyIntWriter tinyInt() {
    return getWriter(MinorType.LIST).tinyInt();
  }


  @Override
  public UInt1Writer uInt1(String name) {
    return getWriter(MinorType.MAP).uInt1(name);
  }

  @Override
  public UInt1Writer uInt1() {
    return getWriter(MinorType.LIST).uInt1();
  }


  @Override
  public UInt2Writer uInt2(String name) {
    return getWriter(MinorType.MAP).uInt2(name);
  }

  @Override
  public UInt2Writer uInt2() {
    return getWriter(MinorType.LIST).uInt2();
  }


  @Override
  public SmallIntWriter smallInt(String name) {
    return getWriter(MinorType.MAP).smallInt(name);
  }

  @Override
  public SmallIntWriter smallInt() {
    return getWriter(MinorType.LIST).smallInt();
  }


  @Override
  public IntWriter integer(String name) {
    return getWriter(MinorType.MAP).integer(name);
  }

  @Override
  public IntWriter integer() {
    return getWriter(MinorType.LIST).integer();
  }


  @Override
  public UInt4Writer uInt4(String name) {
    return getWriter(MinorType.MAP).uInt4(name);
  }

  @Override
  public UInt4Writer uInt4() {
    return getWriter(MinorType.LIST).uInt4();
  }


  @Override
  public Float4Writer float4(String name) {
    return getWriter(MinorType.MAP).float4(name);
  }

  @Override
  public Float4Writer float4() {
    return getWriter(MinorType.LIST).float4();
  }


  @Override
  public DateDayWriter dateDay(String name) {
    return getWriter(MinorType.MAP).dateDay(name);
  }

  @Override
  public DateDayWriter dateDay() {
    return getWriter(MinorType.LIST).dateDay();
  }


  @Override
  public IntervalYearWriter intervalYear(String name) {
    return getWriter(MinorType.MAP).intervalYear(name);
  }

  @Override
  public IntervalYearWriter intervalYear() {
    return getWriter(MinorType.LIST).intervalYear();
  }


  @Override
  public TimeSecWriter timeSec(String name) {
    return getWriter(MinorType.MAP).timeSec(name);
  }

  @Override
  public TimeSecWriter timeSec() {
    return getWriter(MinorType.LIST).timeSec();
  }


  @Override
  public TimeMilliWriter timeMilli(String name) {
    return getWriter(MinorType.MAP).timeMilli(name);
  }

  @Override
  public TimeMilliWriter timeMilli() {
    return getWriter(MinorType.LIST).timeMilli();
  }


  @Override
  public BigIntWriter bigInt(String name) {
    return getWriter(MinorType.MAP).bigInt(name);
  }

  @Override
  public BigIntWriter bigInt() {
    return getWriter(MinorType.LIST).bigInt();
  }


  @Override
  public UInt8Writer uInt8(String name) {
    return getWriter(MinorType.MAP).uInt8(name);
  }

  @Override
  public UInt8Writer uInt8() {
    return getWriter(MinorType.LIST).uInt8();
  }


  @Override
  public Float8Writer float8(String name) {
    return getWriter(MinorType.MAP).float8(name);
  }

  @Override
  public Float8Writer float8() {
    return getWriter(MinorType.LIST).float8();
  }


  @Override
  public DateMilliWriter dateMilli(String name) {
    return getWriter(MinorType.MAP).dateMilli(name);
  }

  @Override
  public DateMilliWriter dateMilli() {
    return getWriter(MinorType.LIST).dateMilli();
  }


  @Override
  public TimeStampSecWriter timeStampSec(String name) {
    return getWriter(MinorType.MAP).timeStampSec(name);
  }

  @Override
  public TimeStampSecWriter timeStampSec() {
    return getWriter(MinorType.LIST).timeStampSec();
  }


  @Override
  public TimeStampMilliWriter timeStampMilli(String name) {
    return getWriter(MinorType.MAP).timeStampMilli(name);
  }

  @Override
  public TimeStampMilliWriter timeStampMilli() {
    return getWriter(MinorType.LIST).timeStampMilli();
  }


  @Override
  public TimeStampMicroWriter timeStampMicro(String name) {
    return getWriter(MinorType.MAP).timeStampMicro(name);
  }

  @Override
  public TimeStampMicroWriter timeStampMicro() {
    return getWriter(MinorType.LIST).timeStampMicro();
  }


  @Override
  public TimeStampNanoWriter timeStampNano(String name) {
    return getWriter(MinorType.MAP).timeStampNano(name);
  }

  @Override
  public TimeStampNanoWriter timeStampNano() {
    return getWriter(MinorType.LIST).timeStampNano();
  }


  @Override
  public TimeStampSecTZWriter timeStampSecTZ(String name, String timezone) {
    return getWriter(MinorType.MAP).timeStampSecTZ(name, timezone);
  }

  @Override
  public TimeStampSecTZWriter timeStampSecTZ(String name) {
    return getWriter(MinorType.MAP).timeStampSecTZ(name);
  }

  @Override
  public TimeStampSecTZWriter timeStampSecTZ() {
    return getWriter(MinorType.LIST).timeStampSecTZ();
  }


  @Override
  public TimeStampMilliTZWriter timeStampMilliTZ(String name, String timezone) {
    return getWriter(MinorType.MAP).timeStampMilliTZ(name, timezone);
  }

  @Override
  public TimeStampMilliTZWriter timeStampMilliTZ(String name) {
    return getWriter(MinorType.MAP).timeStampMilliTZ(name);
  }

  @Override
  public TimeStampMilliTZWriter timeStampMilliTZ() {
    return getWriter(MinorType.LIST).timeStampMilliTZ();
  }


  @Override
  public TimeStampMicroTZWriter timeStampMicroTZ(String name, String timezone) {
    return getWriter(MinorType.MAP).timeStampMicroTZ(name, timezone);
  }

  @Override
  public TimeStampMicroTZWriter timeStampMicroTZ(String name) {
    return getWriter(MinorType.MAP).timeStampMicroTZ(name);
  }

  @Override
  public TimeStampMicroTZWriter timeStampMicroTZ() {
    return getWriter(MinorType.LIST).timeStampMicroTZ();
  }


  @Override
  public TimeStampNanoTZWriter timeStampNanoTZ(String name, String timezone) {
    return getWriter(MinorType.MAP).timeStampNanoTZ(name, timezone);
  }

  @Override
  public TimeStampNanoTZWriter timeStampNanoTZ(String name) {
    return getWriter(MinorType.MAP).timeStampNanoTZ(name);
  }

  @Override
  public TimeStampNanoTZWriter timeStampNanoTZ() {
    return getWriter(MinorType.LIST).timeStampNanoTZ();
  }


  @Override
  public TimeMicroWriter timeMicro(String name) {
    return getWriter(MinorType.MAP).timeMicro(name);
  }

  @Override
  public TimeMicroWriter timeMicro() {
    return getWriter(MinorType.LIST).timeMicro();
  }


  @Override
  public TimeNanoWriter timeNano(String name) {
    return getWriter(MinorType.MAP).timeNano(name);
  }

  @Override
  public TimeNanoWriter timeNano() {
    return getWriter(MinorType.LIST).timeNano();
  }


  @Override
  public IntervalDayWriter intervalDay(String name) {
    return getWriter(MinorType.MAP).intervalDay(name);
  }

  @Override
  public IntervalDayWriter intervalDay() {
    return getWriter(MinorType.LIST).intervalDay();
  }


  @Override
  public DecimalWriter decimal(String name, int scale, int precision) {
    return getWriter(MinorType.MAP).decimal(name, scale, precision);
  }

  @Override
  public DecimalWriter decimal(String name) {
    return getWriter(MinorType.MAP).decimal(name);
  }

  @Override
  public DecimalWriter decimal() {
    return getWriter(MinorType.LIST).decimal();
  }


  @Override
  public VarBinaryWriter varBinary(String name) {
    return getWriter(MinorType.MAP).varBinary(name);
  }

  @Override
  public VarBinaryWriter varBinary() {
    return getWriter(MinorType.LIST).varBinary();
  }


  @Override
  public VarCharWriter varChar(String name) {
    return getWriter(MinorType.MAP).varChar(name);
  }

  @Override
  public VarCharWriter varChar() {
    return getWriter(MinorType.LIST).varChar();
  }


  @Override
  public BitWriter bit(String name) {
    return getWriter(MinorType.MAP).bit(name);
  }

  @Override
  public BitWriter bit() {
    return getWriter(MinorType.LIST).bit();
  }


  public void copyReader(FieldReader reader) {
    getWriter().copyReader(reader);
  }

  public void copyReaderToField(String name, FieldReader reader) {
    getWriter().copyReaderToField(name, reader);
  }
}
