
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.UsageEnum;


/**
 * A producer of schema attributeType definations for the apachedns schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate Eve<->OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class ApachednsAttributeTypeProducer extends AbstractBootstrapProducer
{

    public ApachednsAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce( Registries, ProducerCallback )
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;


        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.1 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.1", registries );
        attributeType.setDescription( "The class of a resource record" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "apacheDnsClass" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.1", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.2 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.2", registries );
        attributeType.setDescription( "An integer denoting time to live" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "apacheDnsTtl" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.2", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.3 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.3", registries );
        attributeType.setDescription( "A domain name represented as a sequence of labels" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "apacheDnsDomainName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.3", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.4", registries );
        attributeType.setDescription( "A string up to 256 characters in length" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "apacheDnsCharacterString" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.5", registries );
        attributeType.setDescription( "A 4 octet IP address" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "apacheDnsIpAddress" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.5", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.6 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.6", registries );
        attributeType.setDescription( "The domain name of the name server that was the primary source of data for this zone" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "apacheDnsDomainName" );

        names.clear();
        names.add( "apacheDnsSoaMName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.6", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.7 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.7", registries );
        attributeType.setDescription( "The domain name which specifies the mailbox of the person responsible for this zone" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "apacheDnsDomainName" );

        names.clear();
        names.add( "apacheDnsSoaRName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.7", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.8 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.8", registries );
        attributeType.setDescription( "The unsigned 32 bit version number of the original copy of the zone" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "apacheDnsSoaSerial" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.8", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.9 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.9", registries );
        attributeType.setDescription( "A 32 bit time interval before the zone should be refreshed" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "apacheDnsSoaRefresh" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.9", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.10 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.10", registries );
        attributeType.setDescription( "A 32 bit time interval that should elapse before a failed refresh should be retired" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "apacheDnsSoaRetry" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.10", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.11 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.11", registries );
        attributeType.setDescription( "A 32 bit time value that specifies the upper limit on the time interval that can elapse before the zone is no longer authoritative" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "apacheDnsSoaExpire" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.11", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.12 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.12", registries );
        attributeType.setDescription( "The unsigned 32 bit minimum TTL field that should be exported with any RR from this zone." );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "apacheDnsSoaMinimum" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.12", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.13 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.13", registries );
        attributeType.setDescription( "An integer denoting the mail exchange preference" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "apacheDnsMxPreference" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.13", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.14 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.14", registries );
        attributeType.setDescription( "The unsigned 16 bit priority of this target host" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "apacheDnsServicePriority" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.14", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.15 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.15", registries );
        attributeType.setDescription( "The unsigned 16 bit weight specifying a relative weight for entries with the same priority" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "apacheDnsServiceWeight" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.15", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.4.1.18060.0.4.2.2.16 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.4.1.18060.0.4.2.2.16", registries );
        attributeType.setDescription( "The unsigned 16 bit port on this target host of this service" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "apacheDnsServicePort" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.2.2.16", attributeType );
    }
}
