
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.Registries;


/**
 * A producer of schema objectClass definations for the java schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class JavaObjectClassProducer extends AbstractBootstrapProducer
{

    public JavaObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce(Registries, ProducerCallback)
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.1", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Container for a Java object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "cn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "javaContainer" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.1", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.4 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.4", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Java object representation" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.ABSTRACT );

        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "javaClassName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "javaClassNames" );
        array.add( "javaCodebase" );
        array.add( "javaDoc" );
        array.add( "description" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "javaObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.4", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.5 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.5", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Java serialized object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );

        // set superior objectClasses
        array.clear();
        array.add( "javaObject" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "javaSerializedData" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "javaSerializedObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.5", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.8 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.8", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Java marshalled object" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );

        // set superior objectClasses
        array.clear();
        array.add( "javaObject" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        array.add( "javaSerializedData" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "javaMarshalledObject" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.8", objectClass );
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.42.2.27.4.2.7 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.42.2.27.4.2.7", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "JNDI reference" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );

        // set superior objectClasses
        array.clear();
        array.add( "javaObject" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "javaReferenceAddress" );
        array.add( "javaFactory" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "javaNamingReference" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.42.2.27.4.2.7", objectClass );
    }
}
