/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config.configcenter;

import java.util.Optional;
import java.util.SortedSet;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfigurationFactory;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.rpc.model.ApplicationModel;

public interface DynamicConfiguration
extends Configuration,
AutoCloseable {
    public static final String DEFAULT_GROUP = "dubbo";

    default public void addListener(String key, ConfigurationListener listener) {
        this.addListener(key, this.getDefaultGroup(), listener);
    }

    default public void removeListener(String key, ConfigurationListener listener) {
        this.removeListener(key, this.getDefaultGroup(), listener);
    }

    public void addListener(String var1, String var2, ConfigurationListener var3);

    public void removeListener(String var1, String var2, ConfigurationListener var3);

    default public String getConfig(String key, String group) {
        return this.getConfig(key, group, this.getDefaultTimeout());
    }

    public String getConfig(String var1, String var2, long var3) throws IllegalStateException;

    default public String getProperties(String key, String group) throws IllegalStateException {
        return this.getProperties(key, group, this.getDefaultTimeout());
    }

    default public String getProperties(String key, String group, long timeout) throws IllegalStateException {
        return this.getConfig(key, group, timeout);
    }

    default public boolean publishConfig(String key, String content) throws UnsupportedOperationException {
        return this.publishConfig(key, this.getDefaultGroup(), content);
    }

    default public boolean publishConfig(String key, String group, String content) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("No support");
    }

    default public SortedSet<String> getConfigKeys(String group) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("No support");
    }

    default public String getDefaultGroup() {
        return DEFAULT_GROUP;
    }

    default public long getDefaultTimeout() {
        return -1L;
    }

    @Override
    default public void close() throws Exception {
        throw new UnsupportedOperationException();
    }

    public static DynamicConfiguration getDynamicConfiguration() {
        Optional<DynamicConfiguration> optional = ApplicationModel.getEnvironment().getDynamicConfiguration();
        return optional.orElseGet(() -> ExtensionLoader.getExtensionLoader(DynamicConfigurationFactory.class).getDefaultExtension().getDynamicConfiguration(null));
    }

    public static DynamicConfiguration getDynamicConfiguration(URL connectionURL) {
        String protocol = connectionURL.getProtocol();
        DynamicConfigurationFactory factory = DynamicConfigurationFactory.getDynamicConfigurationFactory(protocol);
        return factory.getDynamicConfiguration(connectionURL);
    }

    public static String getRuleKey(URL url) {
        return url.getColonSeparatedKey();
    }
}

