/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportFactory;

public class MetadataReportInstance {
    private static AtomicBoolean init = new AtomicBoolean(false);
    private static MetadataReport metadataReport;

    public static void init(URL metadataReportURL) {
        if (init.get()) {
            return;
        }
        MetadataReportFactory metadataReportFactory = ExtensionLoader.getExtensionLoader(MetadataReportFactory.class).getAdaptiveExtension();
        if ("metadata".equals(metadataReportURL.getProtocol())) {
            String protocol = metadataReportURL.getParameter("metadata", "dubbo");
            metadataReportURL = URLBuilder.from(metadataReportURL).setProtocol(protocol).removeParameter("metadata").build();
        }
        metadataReport = metadataReportFactory.getMetadataReport(metadataReportURL);
        init.set(true);
    }

    public static MetadataReport getMetadataReport() {
        return MetadataReportInstance.getMetadataReport(false);
    }

    public static MetadataReport getMetadataReport(boolean checked) {
        if (checked) {
            MetadataReportInstance.checkInit();
        }
        return metadataReport;
    }

    private static void checkInit() {
        if (!init.get()) {
            throw new IllegalStateException("the metadata report was not inited.");
        }
    }
}

