/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.threadlocal.InternalThreadLocal;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AsyncContext;
import org.apache.dubbo.rpc.AsyncContextImpl;
import org.apache.dubbo.rpc.FutureContext;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;

public class RpcContext {
    private static final InternalThreadLocal<RpcContext> LOCAL = new InternalThreadLocal<RpcContext>(){

        @Override
        protected RpcContext initialValue() {
            return new RpcContext();
        }
    };
    private static final InternalThreadLocal<RpcContext> SERVER_LOCAL = new InternalThreadLocal<RpcContext>(){

        @Override
        protected RpcContext initialValue() {
            return new RpcContext();
        }
    };
    private final Map<String, String> attachments = new HashMap<String, String>();
    private final Map<String, Object> values = new HashMap<String, Object>();
    private List<URL> urls;
    private URL url;
    private String methodName;
    private Class<?>[] parameterTypes;
    private Object[] arguments;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private String remoteApplicationName;
    @Deprecated
    private List<Invoker<?>> invokers;
    @Deprecated
    private Invoker<?> invoker;
    @Deprecated
    private Invocation invocation;
    private Object request;
    private Object response;
    private AsyncContext asyncContext;
    private boolean remove = true;

    protected RpcContext() {
    }

    public static RpcContext getServerContext() {
        return SERVER_LOCAL.get();
    }

    public static void restoreServerContext(RpcContext oldServerContext) {
        SERVER_LOCAL.set(oldServerContext);
    }

    public static void removeServerContext() {
        SERVER_LOCAL.remove();
    }

    public static RpcContext getContext() {
        return LOCAL.get();
    }

    public boolean canRemove() {
        return this.remove;
    }

    public void clearAfterEachInvoke(boolean remove) {
        this.remove = remove;
    }

    public static void restoreContext(RpcContext oldContext) {
        LOCAL.set(oldContext);
    }

    public static void removeContext() {
        if (LOCAL.get().canRemove()) {
            LOCAL.remove();
        }
    }

    public Object getRequest() {
        return this.request;
    }

    public void setRequest(Object request) {
        this.request = request;
    }

    public <T> T getRequest(Class<T> clazz) {
        return (T)(this.request != null && clazz.isAssignableFrom(this.request.getClass()) ? this.request : null);
    }

    public Object getResponse() {
        return this.response;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public <T> T getResponse(Class<T> clazz) {
        return (T)(this.response != null && clazz.isAssignableFrom(this.response.getClass()) ? this.response : null);
    }

    public boolean isProviderSide() {
        return !this.isConsumerSide();
    }

    public boolean isConsumerSide() {
        return this.getUrl().getParameter("side", "provider").equals("consumer");
    }

    public <T> CompletableFuture<T> getCompletableFuture() {
        return FutureContext.getContext().getCompletableFuture();
    }

    public <T> Future<T> getFuture() {
        return FutureContext.getContext().getCompletableFuture();
    }

    public void setFuture(CompletableFuture<?> future) {
        FutureContext.getContext().setFuture(future);
    }

    public List<URL> getUrls() {
        return this.urls == null && this.url != null ? Arrays.asList(this.url) : this.urls;
    }

    public void setUrls(List<URL> urls) {
        this.urls = urls;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public RpcContext setLocalAddress(String host, int port) {
        if (port < 0) {
            port = 0;
        }
        this.localAddress = InetSocketAddress.createUnresolved(host, port);
        return this;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public RpcContext setLocalAddress(InetSocketAddress address) {
        this.localAddress = address;
        return this;
    }

    public String getLocalAddressString() {
        return this.getLocalHost() + ":" + this.getLocalPort();
    }

    public String getLocalHostName() {
        String host;
        String string = host = this.localAddress == null ? null : this.localAddress.getHostName();
        if (StringUtils.isEmpty(host)) {
            return this.getLocalHost();
        }
        return host;
    }

    public RpcContext setRemoteAddress(String host, int port) {
        if (port < 0) {
            port = 0;
        }
        this.remoteAddress = InetSocketAddress.createUnresolved(host, port);
        return this;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public RpcContext setRemoteAddress(InetSocketAddress address) {
        this.remoteAddress = address;
        return this;
    }

    public String getRemoteApplicationName() {
        return this.remoteApplicationName;
    }

    public RpcContext setRemoteApplicationName(String remoteApplicationName) {
        this.remoteApplicationName = remoteApplicationName;
        return this;
    }

    public String getRemoteAddressString() {
        return this.getRemoteHost() + ":" + this.getRemotePort();
    }

    public String getRemoteHostName() {
        return this.remoteAddress == null ? null : this.remoteAddress.getHostName();
    }

    public String getLocalHost() {
        String host;
        String string = this.localAddress == null ? null : (host = this.localAddress.getAddress() == null ? this.localAddress.getHostName() : NetUtils.filterLocalHost(this.localAddress.getAddress().getHostAddress()));
        if (host == null || host.length() == 0) {
            return NetUtils.getLocalHost();
        }
        return host;
    }

    public int getLocalPort() {
        return this.localAddress == null ? 0 : this.localAddress.getPort();
    }

    public String getRemoteHost() {
        return this.remoteAddress == null ? null : (this.remoteAddress.getAddress() == null ? this.remoteAddress.getHostName() : NetUtils.filterLocalHost(this.remoteAddress.getAddress().getHostAddress()));
    }

    public int getRemotePort() {
        return this.remoteAddress == null ? 0 : this.remoteAddress.getPort();
    }

    public String getAttachment(String key) {
        return this.attachments.get(key);
    }

    public RpcContext setAttachment(String key, String value) {
        if (value == null) {
            this.attachments.remove(key);
        } else {
            this.attachments.put(key, value);
        }
        return this;
    }

    public RpcContext removeAttachment(String key) {
        this.attachments.remove(key);
        return this;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public RpcContext setAttachments(Map<String, String> attachment) {
        this.attachments.clear();
        if (attachment != null && attachment.size() > 0) {
            this.attachments.putAll(attachment);
        }
        return this;
    }

    public void clearAttachments() {
        this.attachments.clear();
    }

    public Map<String, Object> get() {
        return this.values;
    }

    public RpcContext set(String key, Object value) {
        if (value == null) {
            this.values.remove(key);
        } else {
            this.values.put(key, value);
        }
        return this;
    }

    public RpcContext remove(String key) {
        this.values.remove(key);
        return this;
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    @Deprecated
    public boolean isServerSide() {
        return this.isProviderSide();
    }

    @Deprecated
    public boolean isClientSide() {
        return this.isConsumerSide();
    }

    @Deprecated
    public List<Invoker<?>> getInvokers() {
        return this.invokers == null && this.invoker != null ? Arrays.asList(this.invoker) : this.invokers;
    }

    public RpcContext setInvokers(List<Invoker<?>> invokers) {
        this.invokers = invokers;
        if (CollectionUtils.isNotEmpty(invokers)) {
            ArrayList<URL> urls = new ArrayList<URL>(invokers.size());
            for (Invoker<?> invoker : invokers) {
                urls.add(invoker.getUrl());
            }
            this.setUrls(urls);
        }
        return this;
    }

    @Deprecated
    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    public RpcContext setInvoker(Invoker<?> invoker) {
        this.invoker = invoker;
        if (invoker != null) {
            this.setUrl(invoker.getUrl());
        }
        return this;
    }

    @Deprecated
    public Invocation getInvocation() {
        return this.invocation;
    }

    public RpcContext setInvocation(Invocation invocation) {
        this.invocation = invocation;
        if (invocation != null) {
            this.setMethodName(invocation.getMethodName());
            this.setParameterTypes(invocation.getParameterTypes());
            this.setArguments(invocation.getArguments());
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> CompletableFuture<T> asyncCall(Callable<T> callable) {
        try {
            try {
                this.setAttachment("async", Boolean.TRUE.toString());
                T o = callable.call();
                if (o == null) return (CompletableFuture)RpcContext.getContext().getFuture();
                if (o instanceof CompletableFuture) {
                    CompletableFuture completableFuture = (CompletableFuture)o;
                    return completableFuture;
                }
                CompletableFuture<T> completableFuture = CompletableFuture.completedFuture(o);
                return completableFuture;
            }
            catch (Exception e) {
                throw new RpcException(e);
            }
            finally {
                this.removeAttachment("async");
            }
        }
        catch (RpcException e) {
            return new CompletableFuture<T>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public T get() throws InterruptedException, ExecutionException {
                    throw new ExecutionException(e.getCause());
                }

                @Override
                public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return this.get();
                }
            };
        }
    }

    public void asyncCall(Runnable runnable) {
        try {
            this.setAttachment("return", Boolean.FALSE.toString());
            runnable.run();
        }
        catch (Throwable e) {
            throw new RpcException("oneway call error ." + e.getMessage(), e);
        }
        finally {
            this.removeAttachment("return");
        }
    }

    public static AsyncContext startAsync() throws IllegalStateException {
        RpcContext currentContext = RpcContext.getContext();
        if (currentContext.asyncContext == null) {
            currentContext.asyncContext = new AsyncContextImpl();
        }
        currentContext.asyncContext.start();
        return currentContext.asyncContext;
    }

    protected void setAsyncContext(AsyncContext asyncContext) {
        this.asyncContext = asyncContext;
    }

    public boolean isAsyncStarted() {
        if (this.asyncContext == null) {
            return false;
        }
        return this.asyncContext.isAsyncStarted();
    }

    public boolean stopAsync() {
        return this.asyncContext.stop();
    }

    public AsyncContext getAsyncContext() {
        return this.asyncContext;
    }
}

