/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;

@Activate(group={"provider"}, order=-10000)
public class ContextFilter
implements Filter,
Filter.Listener {
    private static final String TAG_KEY = "dubbo.tag";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Map<String, String> attachments = invocation.getAttachments();
        if (attachments != null) {
            attachments = new HashMap<String, String>(attachments);
            attachments.remove("path");
            attachments.remove("interface");
            attachments.remove("group");
            attachments.remove("version");
            attachments.remove("dubbo");
            attachments.remove("token");
            attachments.remove("timeout");
            attachments.remove("async");
            attachments.remove(TAG_KEY);
            attachments.remove("dubbo.force.tag");
        }
        RpcContext context = RpcContext.getContext();
        context.setInvoker(invoker).setInvocation(invocation).setLocalAddress(invoker.getUrl().getHost(), invoker.getUrl().getPort());
        String remoteApplication = invocation.getAttachment("remote.application");
        if (StringUtils.isNotEmpty(remoteApplication)) {
            context.setRemoteApplicationName(remoteApplication);
        } else {
            context.setRemoteApplicationName(RpcContext.getContext().getAttachment("remote.application"));
        }
        if (attachments != null) {
            if (RpcContext.getContext().getAttachments() != null) {
                RpcContext.getContext().getAttachments().putAll(attachments);
            } else {
                RpcContext.getContext().setAttachments(attachments);
            }
        }
        if (invocation instanceof RpcInvocation) {
            ((RpcInvocation)invocation).setInvoker(invoker);
        }
        try {
            RpcContext.getContext().clearAfterEachInvoke(false);
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            RpcContext.getContext().clearAfterEachInvoke(true);
            RpcContext.removeContext();
            RpcContext.removeServerContext();
        }
    }

    @Override
    public void onMessage(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        appResponse.addAttachments(RpcContext.getServerContext().getAttachments());
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }
}

