/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.model.MethodDescriptor;

public class ServiceDescriptor {
    private final String serviceName;
    private final Class<?> serviceInterfaceClass;
    private final Map<String, Set<MethodDescriptor>> methods = new HashMap<String, Set<MethodDescriptor>>();
    private final Map<String, Map<String, MethodDescriptor>> descToMethods = new HashMap<String, Map<String, MethodDescriptor>>();

    public ServiceDescriptor(Class<?> interfaceClass) {
        this.serviceInterfaceClass = interfaceClass;
        this.serviceName = interfaceClass.getName();
        this.initMethods();
    }

    private void initMethods() {
        Method[] methodsToExport = null;
        for (Method method : methodsToExport = this.serviceInterfaceClass.getMethods()) {
            method.setAccessible(true);
            Set methodModels = this.methods.computeIfAbsent(method.getName(), k -> new HashSet(1));
            methodModels.add(new MethodDescriptor(method));
        }
        this.methods.forEach((methodName, methodList) -> {
            Map descMap = this.descToMethods.computeIfAbsent((String)methodName, k -> new HashMap());
            methodList.forEach(methodModel -> descMap.put(methodModel.getParamDesc(), methodModel));
        });
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Class<?> getServiceInterfaceClass() {
        return this.serviceInterfaceClass;
    }

    public Set<MethodDescriptor> getAllMethods() {
        HashSet<MethodDescriptor> methodModels = new HashSet<MethodDescriptor>();
        this.methods.forEach((k, v) -> methodModels.addAll((Collection<MethodDescriptor>)v));
        return methodModels;
    }

    public MethodDescriptor getMethod(String methodName, String params) {
        Map<String, MethodDescriptor> methods = this.descToMethods.get(methodName);
        if (CollectionUtils.isNotEmptyMap(methods)) {
            return methods.get(params);
        }
        return null;
    }

    public MethodDescriptor getMethod(String methodName, Class<?>[] paramTypes) {
        Set<MethodDescriptor> methodModels = this.methods.get(methodName);
        if (CollectionUtils.isNotEmpty(methodModels)) {
            for (MethodDescriptor methodModel : methodModels) {
                if (!Arrays.equals(paramTypes, methodModel.getParameterClasses())) continue;
                return methodModel;
            }
        }
        return null;
    }

    public Set<MethodDescriptor> getMethods(String methodName) {
        return this.methods.get(methodName);
    }
}

