/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.grpc;

import io.grpc.Status;
import io.grpc.StatusException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.protocol.grpc.ReferenceCountManagedChannel;

public class GrpcInvoker<T>
extends AbstractInvoker<T> {
    private final ReentrantLock destroyLock = new ReentrantLock();
    private final Invoker<T> target;
    private ReferenceCountManagedChannel channel;

    public GrpcInvoker(Class<T> type, URL url, Invoker<T> target, ReferenceCountManagedChannel channel) {
        super(type, url);
        this.target = target;
        this.channel = channel;
    }

    @Override
    protected Result doInvoke(Invocation invocation) throws Throwable {
        try {
            Result result = this.target.invoke(invocation);
            Throwable e = result.getException();
            if (e != null) {
                throw this.getRpcException(this.getInterface(), this.getUrl(), invocation, e);
            }
            return result;
        }
        catch (RpcException e) {
            if (e.getCode() == 0) {
                e.setCode(this.getErrorCode(e.getCause()));
            }
            throw e;
        }
        catch (Throwable e) {
            throw this.getRpcException(this.getInterface(), this.getUrl(), invocation, e);
        }
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && !this.channel.isShutdown() && !this.channel.isTerminated();
    }

    @Override
    public boolean isDestroyed() {
        return super.isDestroyed() || this.channel.isShutdown() || this.channel.isTerminated();
    }

    @Override
    public void destroy() {
        if (!super.isDestroyed()) {
            this.destroyLock.lock();
            try {
                if (super.isDestroyed()) {
                    return;
                }
                super.destroy();
                this.channel.shutdown();
            }
            finally {
                this.destroyLock.unlock();
            }
        }
    }

    private RpcException getRpcException(Class<?> type, URL url, Invocation invocation, Throwable e) {
        RpcException re = new RpcException("Failed to invoke remote service: " + type + ", method: " + invocation.getMethodName() + ", cause: " + e.getMessage(), e);
        re.setCode(this.getErrorCode(e));
        return re;
    }

    private int getErrorCode(Throwable e) {
        if (e instanceof StatusException) {
            StatusException statusException = (StatusException)e;
            Status status = statusException.getStatus();
            if (status.getCode() == Status.Code.DEADLINE_EXCEEDED) {
                return 2;
            }
            if (status.getCode() == Status.Code.DEADLINE_EXCEEDED) {
                // empty if block
            }
        }
        return 0;
    }
}

