/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LeaderAndIsrRequestTest {
    @Test
    public void testUnsupportedVersion() {
        LeaderAndIsrRequest.Builder builder = new LeaderAndIsrRequest.Builder((short)(ApiKeys.LEADER_AND_ISR.latestVersion() + 1), 0, 0, 0L, Collections.emptyList(), Collections.emptyMap(), Collections.emptySet());
        Assertions.assertThrows(UnsupportedVersionException.class, () -> ((LeaderAndIsrRequest.Builder)builder).build());
    }

    @Test
    public void testGetErrorResponse() {
        Uuid id = Uuid.randomUuid();
        for (short version = ApiKeys.LEADER_AND_ISR.oldestVersion(); version < ApiKeys.LEADER_AND_ISR.latestVersion(); version = (short)(version + 1)) {
            LeaderAndIsrRequest.Builder builder = new LeaderAndIsrRequest.Builder(version, 0, 0, 0L, Collections.emptyList(), Collections.singletonMap("topic", id), Collections.emptySet());
            LeaderAndIsrRequest request = (LeaderAndIsrRequest)builder.build();
            LeaderAndIsrResponse response = request.getErrorResponse(0, (Throwable)new ClusterAuthorizationException("Not authorized"));
            Assertions.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)response.error());
            if (version < 5) {
                Assertions.assertEquals((int)0, (int)response.topics().size());
                continue;
            }
            Assertions.assertEquals((Object)id, (Object)((LeaderAndIsrResponseData.LeaderAndIsrTopicError)response.topics().get(0)).topicId());
        }
    }

    @Test
    public void testVersionLogic() {
        for (short version = ApiKeys.LEADER_AND_ISR.oldestVersion(); version <= ApiKeys.LEADER_AND_ISR.latestVersion(); version = (short)(version + 1)) {
            List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates = Arrays.asList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic0").setPartitionIndex(0).setControllerEpoch(2).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(0, 1)).setZkVersion(10).setReplicas(Arrays.asList(0, 1, 2)).setAddingReplicas(Arrays.asList(3)).setRemovingReplicas(Arrays.asList(2)), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic0").setPartitionIndex(1).setControllerEpoch(2).setLeader(1).setLeaderEpoch(11).setIsr(Arrays.asList(1, 2, 3)).setZkVersion(11).setReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(2).setLeader(2).setLeaderEpoch(11).setIsr(Arrays.asList(2, 3, 4)).setZkVersion(11).setReplicas(Arrays.asList(2, 3, 4)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()));
            List<Node> liveNodes = Arrays.asList(new Node(0, "host0", 9090), new Node(1, "host1", 9091));
            HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
            topicIds.put("topic0", Uuid.randomUuid());
            topicIds.put("topic1", Uuid.randomUuid());
            LeaderAndIsrRequest request = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(version, 1, 2, 3L, partitionStates, topicIds, liveNodes).build();
            List liveLeaders = liveNodes.stream().map(n -> new LeaderAndIsrRequestData.LeaderAndIsrLiveLeader().setBrokerId(n.id()).setHostName(n.host()).setPort(n.port())).collect(Collectors.toList());
            Assertions.assertEquals(new HashSet<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>(partitionStates), this.iterableToSet(request.partitionStates()));
            Assertions.assertEquals(liveLeaders, (Object)request.liveLeaders());
            Assertions.assertEquals((int)1, (int)request.controllerId());
            Assertions.assertEquals((int)2, (int)request.controllerEpoch());
            Assertions.assertEquals((long)3L, (long)request.brokerEpoch());
            ByteBuffer byteBuffer = request.serialize();
            LeaderAndIsrRequest deserializedRequest = new LeaderAndIsrRequest(new LeaderAndIsrRequestData((Readable)new ByteBufferAccessor(byteBuffer), version), version);
            if (version < 3) {
                partitionStates.get(0).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList());
            }
            if (version < 2) {
                topicIds = new HashMap();
            }
            if (version > 1 && version < 5) {
                topicIds.put("topic0", Uuid.ZERO_UUID);
                topicIds.put("topic1", Uuid.ZERO_UUID);
            }
            Assertions.assertEquals(new HashSet<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>(partitionStates), this.iterableToSet(deserializedRequest.partitionStates()));
            Assertions.assertEquals(topicIds, (Object)deserializedRequest.topicIds());
            Assertions.assertEquals(liveLeaders, (Object)deserializedRequest.liveLeaders());
            Assertions.assertEquals((int)1, (int)request.controllerId());
            Assertions.assertEquals((int)2, (int)request.controllerEpoch());
            Assertions.assertEquals((long)3L, (long)request.brokerEpoch());
        }
    }

    @Test
    public void testTopicPartitionGroupingSizeReduction() {
        Set<TopicPartition> tps = TestUtils.generateRandomTopicPartitions(10, 10);
        ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates = new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        for (TopicPartition tp : tps) {
            partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()));
            topicIds.put(tp.topic(), Uuid.randomUuid());
        }
        LeaderAndIsrRequest.Builder builder = new LeaderAndIsrRequest.Builder(2, 0, 0, 0L, partitionStates, topicIds, Collections.emptySet());
        LeaderAndIsrRequest v2 = builder.build((short)2);
        LeaderAndIsrRequest v1 = builder.build((short)1);
        Assertions.assertTrue((v2.sizeInBytes() < v1.sizeInBytes() ? 1 : 0) != 0, (String)("Expected v2 < v1: v2=" + v2.sizeInBytes() + ", v1=" + v1.sizeInBytes()));
    }

    private <T> Set<T> iterableToSet(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet());
    }
}

