/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.bootstrap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.AbstractClassEnhancePluginDefine;
import org.apache.skywalking.apm.agent.core.plugin.ByteBuddyCoreClasses;
import org.apache.skywalking.apm.agent.core.plugin.InstrumentDebuggingClass;
import org.apache.skywalking.apm.agent.core.plugin.PluginException;
import org.apache.skywalking.apm.agent.core.plugin.PluginFinder;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.ConstructorInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.InstanceMethodsInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.StaticMethodsInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.v2.InstanceMethodsInterceptV2Point;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.v2.StaticMethodsInterceptV2Point;
import org.apache.skywalking.apm.agent.core.plugin.jdk9module.JDK9ModuleExporter;
import org.apache.skywalking.apm.agent.core.plugin.loader.AgentClassLoader;

public class BootstrapInstrumentBoost {
    private static final ILog LOGGER = LogManager.getLogger(BootstrapInstrumentBoost.class);
    private static final String[] HIGH_PRIORITY_CLASSES = new String[]{"org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.BootstrapInterRuntimeAssist", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsAroundInterceptor", "org.apache.skywalking.apm.agent.core.plugin.bootstrap.IBootstrapLog", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.OverrideCallable", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstanceMethodsAroundInterceptorV2", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.StaticMethodsAroundInterceptorV2", "org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext"};
    private static String INSTANCE_METHOD_DELEGATE_TEMPLATE = "org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.InstanceMethodInterTemplate";
    private static String INSTANCE_METHOD_WITH_OVERRIDE_ARGS_DELEGATE_TEMPLATE = "org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.InstanceMethodInterWithOverrideArgsTemplate";
    private static String CONSTRUCTOR_DELEGATE_TEMPLATE = "org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.ConstructorInterTemplate";
    private static String STATIC_METHOD_DELEGATE_TEMPLATE = "org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.StaticMethodInterTemplate";
    private static String STATIC_METHOD_WITH_OVERRIDE_ARGS_DELEGATE_TEMPLATE = "org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.StaticMethodInterWithOverrideArgsTemplate";
    private static String INSTANCE_METHOD_V2_DELEGATE_TEMPLATE = "org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.v2.InstanceMethodInterV2Template";
    private static String INSTANCE_METHOD_V2_WITH_OVERRIDE_ARGS_DELEGATE_TEMPLATE = "org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.v2.InstanceMethodInterV2WithOverrideArgsTemplate";
    private static String STATIC_METHOD_V2_DELEGATE_TEMPLATE = "org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.v2.StaticMethodInterV2Template";
    private static String STATIC_METHOD_V2_WITH_OVERRIDE_ARGS_DELEGATE_TEMPLATE = "org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.v2.StaticMethodInterV2WithOverrideArgsTemplate";

    public static AgentBuilder inject(PluginFinder pluginFinder, Instrumentation instrumentation, AgentBuilder agentBuilder, JDK9ModuleExporter.EdgeClasses edgeClasses) throws PluginException {
        HashMap<String, byte[]> classesTypeMap = new HashMap<String, byte[]>();
        if (!BootstrapInstrumentBoost.prepareJREInstrumentation(pluginFinder, classesTypeMap)) {
            return agentBuilder;
        }
        if (!BootstrapInstrumentBoost.prepareJREInstrumentationV2(pluginFinder, classesTypeMap)) {
            return agentBuilder;
        }
        for (String highPriorityClass : HIGH_PRIORITY_CLASSES) {
            BootstrapInstrumentBoost.loadHighPriorityClass(classesTypeMap, highPriorityClass);
        }
        for (String highPriorityClass : ByteBuddyCoreClasses.CLASSES) {
            BootstrapInstrumentBoost.loadHighPriorityClass(classesTypeMap, highPriorityClass);
        }
        for (String generatedClass : classesTypeMap.keySet()) {
            edgeClasses.add(generatedClass);
        }
        ClassInjector.UsingUnsafe.Factory factory = ClassInjector.UsingUnsafe.Factory.resolve((Instrumentation)instrumentation);
        factory.make(null, null).injectRaw(classesTypeMap);
        agentBuilder = agentBuilder.with((AgentBuilder.InjectionStrategy)new AgentBuilder.InjectionStrategy.UsingUnsafe.OfFactory(factory));
        return agentBuilder;
    }

    public static String internalDelegate(String methodsInterceptor) {
        return methodsInterceptor + "_internal";
    }

    public static Class forInternalDelegateClass(String methodsInterceptor) {
        try {
            return Class.forName(BootstrapInstrumentBoost.internalDelegate(methodsInterceptor));
        }
        catch (ClassNotFoundException e) {
            throw new PluginException(e.getMessage(), e);
        }
    }

    private static boolean prepareJREInstrumentation(PluginFinder pluginFinder, Map<String, byte[]> classesTypeMap) throws PluginException {
        TypePool typePool = TypePool.Default.of((ClassLoader)BootstrapInstrumentBoost.class.getClassLoader());
        List<AbstractClassEnhancePluginDefine> bootstrapClassMatchDefines = pluginFinder.getBootstrapClassMatchDefine();
        for (AbstractClassEnhancePluginDefine define : bootstrapClassMatchDefines) {
            if (Objects.nonNull(define.getInstanceMethodsInterceptPoints())) {
                for (InstanceMethodsInterceptPoint instanceMethodsInterceptPoint : define.getInstanceMethodsInterceptPoints()) {
                    if (instanceMethodsInterceptPoint.isOverrideArgs()) {
                        BootstrapInstrumentBoost.generateDelegator(classesTypeMap, typePool, INSTANCE_METHOD_WITH_OVERRIDE_ARGS_DELEGATE_TEMPLATE, instanceMethodsInterceptPoint.getMethodsInterceptor());
                        continue;
                    }
                    BootstrapInstrumentBoost.generateDelegator(classesTypeMap, typePool, INSTANCE_METHOD_DELEGATE_TEMPLATE, instanceMethodsInterceptPoint.getMethodsInterceptor());
                }
            }
            if (Objects.nonNull(define.getConstructorsInterceptPoints())) {
                for (ConstructorInterceptPoint constructorInterceptPoint : define.getConstructorsInterceptPoints()) {
                    BootstrapInstrumentBoost.generateDelegator(classesTypeMap, typePool, CONSTRUCTOR_DELEGATE_TEMPLATE, constructorInterceptPoint.getConstructorInterceptor());
                }
            }
            if (!Objects.nonNull(define.getStaticMethodsInterceptPoints())) continue;
            for (StaticMethodsInterceptPoint staticMethodsInterceptPoint : define.getStaticMethodsInterceptPoints()) {
                if (staticMethodsInterceptPoint.isOverrideArgs()) {
                    BootstrapInstrumentBoost.generateDelegator(classesTypeMap, typePool, STATIC_METHOD_WITH_OVERRIDE_ARGS_DELEGATE_TEMPLATE, staticMethodsInterceptPoint.getMethodsInterceptor());
                    continue;
                }
                BootstrapInstrumentBoost.generateDelegator(classesTypeMap, typePool, STATIC_METHOD_DELEGATE_TEMPLATE, staticMethodsInterceptPoint.getMethodsInterceptor());
            }
        }
        return bootstrapClassMatchDefines.size() > 0;
    }

    private static boolean prepareJREInstrumentationV2(PluginFinder pluginFinder, Map<String, byte[]> classesTypeMap) throws PluginException {
        TypePool typePool = TypePool.Default.of((ClassLoader)BootstrapInstrumentBoost.class.getClassLoader());
        List<AbstractClassEnhancePluginDefine> bootstrapClassMatchDefines = pluginFinder.getBootstrapClassMatchDefine();
        for (AbstractClassEnhancePluginDefine define : bootstrapClassMatchDefines) {
            if (Objects.nonNull(define.getInstanceMethodsInterceptV2Points())) {
                for (InstanceMethodsInterceptV2Point instanceMethodsInterceptV2Point : define.getInstanceMethodsInterceptV2Points()) {
                    if (instanceMethodsInterceptV2Point.isOverrideArgs()) {
                        BootstrapInstrumentBoost.generateDelegator(classesTypeMap, typePool, INSTANCE_METHOD_V2_WITH_OVERRIDE_ARGS_DELEGATE_TEMPLATE, instanceMethodsInterceptV2Point.getMethodsInterceptorV2());
                        continue;
                    }
                    BootstrapInstrumentBoost.generateDelegator(classesTypeMap, typePool, INSTANCE_METHOD_V2_DELEGATE_TEMPLATE, instanceMethodsInterceptV2Point.getMethodsInterceptorV2());
                }
            }
            if (!Objects.nonNull(define.getStaticMethodsInterceptV2Points())) continue;
            for (StaticMethodsInterceptV2Point staticMethodsInterceptV2Point : define.getStaticMethodsInterceptV2Points()) {
                if (staticMethodsInterceptV2Point.isOverrideArgs()) {
                    BootstrapInstrumentBoost.generateDelegator(classesTypeMap, typePool, STATIC_METHOD_V2_WITH_OVERRIDE_ARGS_DELEGATE_TEMPLATE, staticMethodsInterceptV2Point.getMethodsInterceptorV2());
                    continue;
                }
                BootstrapInstrumentBoost.generateDelegator(classesTypeMap, typePool, STATIC_METHOD_V2_DELEGATE_TEMPLATE, staticMethodsInterceptV2Point.getMethodsInterceptorV2());
            }
        }
        return bootstrapClassMatchDefines.size() > 0;
    }

    private static void generateDelegator(Map<String, byte[]> classesTypeMap, TypePool typePool, String templateClassName, String methodsInterceptor) {
        String internalInterceptorName = BootstrapInstrumentBoost.internalDelegate(methodsInterceptor);
        try {
            TypeDescription templateTypeDescription = typePool.describe(templateClassName).resolve();
            DynamicType.Unloaded interceptorType = new ByteBuddy().redefine(templateTypeDescription, ClassFileLocator.ForClassLoader.of((ClassLoader)BootstrapInstrumentBoost.class.getClassLoader())).name(internalInterceptorName).field((ElementMatcher)ElementMatchers.named((String)"TARGET_INTERCEPTOR")).value(methodsInterceptor).make();
            classesTypeMap.put(internalInterceptorName, interceptorType.getBytes());
            InstrumentDebuggingClass.INSTANCE.log((DynamicType)interceptorType);
        }
        catch (Exception e) {
            throw new PluginException("Generate Dynamic plugin failure", e);
        }
    }

    private static void loadHighPriorityClass(Map<String, byte[]> loadedTypeMap, String className) throws PluginException {
        byte[] enhancedInstanceClassFile;
        try {
            int len;
            String classResourceName = className.replaceAll("\\.", "/") + ".class";
            InputStream resourceAsStream = AgentClassLoader.getDefault().getResourceAsStream(classResourceName);
            if (resourceAsStream == null) {
                throw new PluginException("High priority class " + className + " not found.");
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = resourceAsStream.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            enhancedInstanceClassFile = os.toByteArray();
        }
        catch (IOException e) {
            throw new PluginException(e.getMessage(), e);
        }
        loadedTypeMap.put(className, enhancedInstanceClassFile);
    }
}

