/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.bootstrap.template;

import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import org.apache.skywalking.apm.agent.core.plugin.bootstrap.IBootstrapLog;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.BootstrapInterRuntimeAssist;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;

public class ConstructorInterTemplate {
    private static String TARGET_INTERCEPTOR;
    private static InstanceConstructorInterceptor INTERCEPTOR;
    private static IBootstrapLog LOGGER;

    @RuntimeType
    public static void intercept(@This Object obj, @AllArguments Object[] allArguments) {
        try {
            ConstructorInterTemplate.prepare();
            EnhancedInstance targetObject = (EnhancedInstance)obj;
            if (INTERCEPTOR == null) {
                return;
            }
            INTERCEPTOR.onConstruct(targetObject, allArguments);
        }
        catch (Throwable t) {
            LOGGER.error("ConstructorInter failure.", t);
        }
    }

    private static void prepare() {
        if (INTERCEPTOR == null) {
            ClassLoader loader = BootstrapInterRuntimeAssist.getAgentClassLoader();
            if (loader != null) {
                IBootstrapLog logger = BootstrapInterRuntimeAssist.getLogger(loader, TARGET_INTERCEPTOR);
                if (logger != null) {
                    LOGGER = logger;
                    INTERCEPTOR = (InstanceConstructorInterceptor)BootstrapInterRuntimeAssist.createInterceptor(loader, TARGET_INTERCEPTOR, LOGGER);
                }
            } else {
                LOGGER.error("Runtime ClassLoader not found when create {}." + TARGET_INTERCEPTOR);
            }
        }
    }
}

