/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.bootstrap.template.v2;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.apache.skywalking.apm.agent.core.plugin.bootstrap.IBootstrapLog;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.BootstrapInterRuntimeAssist;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.StaticMethodsAroundInterceptorV2;

public class StaticMethodInterV2Template {
    private static String TARGET_INTERCEPTOR;
    private static StaticMethodsAroundInterceptorV2 INTERCEPTOR;
    private static IBootstrapLog LOGGER;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public static Object intercept(@Origin Class<?> clazz, @AllArguments Object[] allArguments, @Origin Method method, @SuperCall Callable<?> zuper) throws Throwable {
        StaticMethodInterV2Template.prepare();
        MethodInvocationContext context = new MethodInvocationContext();
        try {
            if (INTERCEPTOR != null) {
                INTERCEPTOR.beforeMethod(clazz, method, allArguments, method.getParameterTypes(), context);
            }
        }
        catch (Throwable t) {
            LOGGER.error(t, "class[{}] before static method[{}] intercept failure", clazz, method.getName());
        }
        Object ret = null;
        try {
            ret = !context.isContinue() ? context._ret() : zuper.call();
        }
        catch (Throwable t) {
            try {
                try {
                    if (INTERCEPTOR == null) throw t;
                    INTERCEPTOR.handleMethodException(clazz, method, allArguments, method.getParameterTypes(), t, context);
                    throw t;
                }
                catch (Throwable t2) {
                    LOGGER.error(t2, "class[{}] handle static method[{}] exception failure", clazz, method.getName(), t2.getMessage());
                }
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    if (INTERCEPTOR == null) throw throwable;
                    ret = INTERCEPTOR.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret, context);
                    throw throwable;
                }
                catch (Throwable t2) {
                    LOGGER.error(t2, "class[{}] after static method[{}] intercept failure:{}", clazz, method.getName(), t2.getMessage());
                }
                throw throwable;
            }
        }
        try {
            if (INTERCEPTOR == null) return ret;
            return INTERCEPTOR.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret, context);
        }
        catch (Throwable t) {
            LOGGER.error(t, "class[{}] after static method[{}] intercept failure:{}", clazz, method.getName(), t.getMessage());
            return ret;
        }
    }

    private static void prepare() {
        if (INTERCEPTOR == null) {
            ClassLoader loader = BootstrapInterRuntimeAssist.getAgentClassLoader();
            if (loader != null) {
                IBootstrapLog logger = BootstrapInterRuntimeAssist.getLogger(loader, TARGET_INTERCEPTOR);
                if (logger != null) {
                    LOGGER = logger;
                    INTERCEPTOR = (StaticMethodsAroundInterceptorV2)BootstrapInterRuntimeAssist.createInterceptor(loader, TARGET_INTERCEPTOR, LOGGER);
                }
            } else {
                LOGGER.error("Runtime ClassLoader not found when create {}." + TARGET_INTERCEPTOR);
            }
        }
    }
}

