/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.bytebuddy;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.utility.RandomString;
import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackagePath;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.bytebuddy.ClassCacheMode;
import org.apache.skywalking.apm.agent.core.util.FileUtils;
import org.apache.skywalking.apm.agent.core.util.IOUtils;

public class CacheableTransformerDecorator
implements AgentBuilder.TransformerDecorator {
    private static final ILog LOGGER = LogManager.getLogger(CacheableTransformerDecorator.class);
    private final ClassCacheMode cacheMode;
    private ClassCacheResolver cacheResolver;

    public CacheableTransformerDecorator(ClassCacheMode cacheMode) throws IOException {
        this.cacheMode = cacheMode;
        this.initClassCache();
    }

    private void initClassCache() throws IOException {
        if (this.cacheMode.equals((Object)ClassCacheMode.FILE)) {
            String cacheDirBase = null;
            try {
                cacheDirBase = AgentPackagePath.getPath() + "/class-cache";
            }
            catch (AgentPackageNotFoundException e) {
                throw new IOException("Can't find the root path for creating /class-cache folder.");
            }
            File cacheDir = new File(cacheDirBase + "/class-cache-" + RandomString.make());
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            if (!cacheDir.exists()) {
                throw new IOException("Create class cache dir failure");
            }
            this.cacheResolver = new FileCacheResolver(cacheDir);
        } else {
            this.cacheResolver = new MemoryCacheResolver();
        }
    }

    public ResettableClassFileTransformer decorate(ResettableClassFileTransformer classFileTransformer) {
        return new ResettableClassFileTransformer.WithDelegation(classFileTransformer){

            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                byte[] classCache = CacheableTransformerDecorator.this.cacheResolver.getClassCache(loader, className);
                if (classCache != null) {
                    return classCache;
                }
                if ((classfileBuffer = this.classFileTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer)) != null) {
                    CacheableTransformerDecorator.this.cacheResolver.putClassCache(loader, className, classfileBuffer);
                }
                return classfileBuffer;
            }
        };
    }

    private static String getClassLoaderHash(ClassLoader loader) {
        String classloader = loader != null ? Integer.toHexString(loader.hashCode()) : "00000000";
        return classloader;
    }

    static class FileCacheResolver
    implements ClassCacheResolver {
        private final File cacheDir;

        FileCacheResolver(File cacheDir) {
            this.cacheDir = cacheDir;
            FileUtils.deleteDirectoryOnExit(cacheDir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getClassCache(ClassLoader loader, String className) {
            File cacheFile = this.getCacheFile(loader, className);
            if (cacheFile.exists()) {
                byte[] byArray;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(cacheFile);
                    byArray = IOUtils.toByteArray(fileInputStream);
                }
                catch (IOException e) {
                    try {
                        LOGGER.error("load class bytes from cache file failure", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileInputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(fileInputStream);
                }
                IOUtils.closeQuietly(fileInputStream);
                return byArray;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putClassCache(ClassLoader loader, String className, byte[] classfileBuffer) {
            File cacheFile = this.getCacheFile(loader, className);
            cacheFile.getParentFile().mkdirs();
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(cacheFile);
                IOUtils.copy(new ByteArrayInputStream(classfileBuffer), output);
            }
            catch (IOException e) {
                try {
                    LOGGER.error("save class bytes to cache file failure", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
                IOUtils.closeQuietly(output);
            }
            IOUtils.closeQuietly(output);
        }

        private File getCacheFile(ClassLoader loader, String className) {
            String filename = CacheableTransformerDecorator.getClassLoaderHash(loader) + "/" + className.replace('.', '/') + ".class";
            return new File(this.cacheDir, filename);
        }
    }

    static class MemoryCacheResolver
    implements ClassCacheResolver {
        private Map<String, byte[]> classCacheMap = new ConcurrentHashMap<String, byte[]>();

        MemoryCacheResolver() {
        }

        @Override
        public byte[] getClassCache(ClassLoader loader, String className) {
            String cacheKey = this.getCacheKey(loader, className);
            return this.classCacheMap.get(cacheKey);
        }

        @Override
        public void putClassCache(ClassLoader loader, String className, byte[] classfileBuffer) {
            String cacheKey = this.getCacheKey(loader, className);
            this.classCacheMap.put(cacheKey, classfileBuffer);
        }

        private String getCacheKey(ClassLoader loader, String className) {
            return CacheableTransformerDecorator.getClassLoaderHash(loader) + "@" + className;
        }
    }

    static interface ClassCacheResolver {
        public byte[] getClassCache(ClassLoader var1, String var2);

        public void putClassCache(ClassLoader var1, String var2, byte[] var3);
    }
}

