/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.match;

import java.util.Objects;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.CollectionItemMatcher;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

@HashCodeAndEqualsPlugin.Enhance
public class MethodInheritanceAnnotationMatcher<T extends MethodDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super AnnotationList> matcher;

    public MethodInheritanceAnnotationMatcher(ElementMatcher<? super AnnotationList> matcher) {
        this.matcher = matcher;
    }

    public boolean matches(T target) {
        if (this.matcher.matches((Object)target.getDeclaredAnnotations())) {
            return true;
        }
        String name = target.getName();
        ParameterList parameters = target.getParameters();
        TypeDefinition declaringType = target.getDeclaringType();
        return this.recursiveMatches(declaringType, name, parameters);
    }

    private boolean recursiveMatches(TypeDefinition typeDefinition, String methodName, ParameterList<?> parameters) {
        TypeList.Generic interfaces = typeDefinition.getInterfaces();
        for (TypeDescription.Generic implInterface : interfaces) {
            if (this.recursiveMatches((TypeDefinition)implInterface, methodName, parameters)) {
                return true;
            }
            MethodList declaredMethods = implInterface.getDeclaredMethods();
            for (MethodDescription declaredMethod : declaredMethods) {
                if (!Objects.equals(declaredMethod.getName(), methodName) || !this.parameterEquals(parameters, declaredMethod.getParameters())) continue;
                return this.matcher.matches((Object)declaredMethod.getDeclaredAnnotations());
            }
        }
        return false;
    }

    private boolean parameterEquals(ParameterList<?> source, ParameterList<?> impl) {
        if (source.size() != impl.size()) {
            return false;
        }
        for (int i = 0; i < source.size(); ++i) {
            if (Objects.equals(((ParameterDescription)source.get(i)).getType(), ((ParameterDescription)impl.get(i)).getType())) continue;
            return false;
        }
        return true;
    }

    public static <T extends AnnotationSource> ElementMatcher.Junction<T> byMethodInheritanceAnnotationMatcher(ElementMatcher<? super TypeDescription> matcher) {
        return new MethodInheritanceAnnotationMatcher<T>((ElementMatcher<? super AnnotationList>)new CollectionItemMatcher((ElementMatcher)ElementMatchers.annotationType(matcher)));
    }
}

