/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.match;

import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.skywalking.apm.agent.core.plugin.match.IndirectMatch;

public class RegexMatch
implements IndirectMatch {
    private String[] regexExpressions;

    private RegexMatch(String ... regexExpressions) {
        if (regexExpressions == null || regexExpressions.length == 0) {
            throw new IllegalArgumentException("annotations is null");
        }
        this.regexExpressions = regexExpressions;
    }

    @Override
    public ElementMatcher.Junction buildJunction() {
        ElementMatcher.Junction regexJunction = null;
        for (String regexExpression : this.regexExpressions) {
            regexJunction = regexJunction == null ? ElementMatchers.nameMatches((String)regexExpression) : regexJunction.or((ElementMatcher)ElementMatchers.nameMatches((String)regexExpression));
        }
        return regexJunction;
    }

    @Override
    public boolean isMatch(TypeDescription typeDescription) {
        boolean isMatch = false;
        for (String matchExpression : this.regexExpressions) {
            isMatch = typeDescription.getTypeName().matches(matchExpression);
            if (isMatch) break;
        }
        return isMatch;
    }

    public static RegexMatch byRegexMatch(String ... regexExpressions) {
        return new RegexMatch(regexExpressions);
    }
}

