/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackagePath;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.remote.ChannelBuilder;
import org.apache.skywalking.apm.agent.core.util.PrivateKeyUtil;
import org.apache.skywalking.apm.dependencies.io.grpc.netty.GrpcSslContexts;
import org.apache.skywalking.apm.dependencies.io.grpc.netty.NegotiationType;
import org.apache.skywalking.apm.dependencies.io.grpc.netty.NettyChannelBuilder;
import org.apache.skywalking.apm.dependencies.io.netty.handler.ssl.SslContextBuilder;
import org.apache.skywalking.apm.util.StringUtil;

public class TLSChannelBuilder
implements ChannelBuilder<NettyChannelBuilder> {
    private static final ILog LOGGER = LogManager.getLogger(TLSChannelBuilder.class);

    @Override
    public NettyChannelBuilder build(NettyChannelBuilder managedChannelBuilder) throws AgentPackageNotFoundException, IOException {
        boolean isCAFileExist;
        File caFile = new File(AgentPackagePath.getPath(), Config.Agent.SSL_TRUSTED_CA_PATH);
        boolean bl = isCAFileExist = caFile.exists() && caFile.isFile();
        if (Config.Agent.FORCE_TLS || isCAFileExist) {
            SslContextBuilder builder = GrpcSslContexts.forClient();
            if (isCAFileExist) {
                block29: {
                    String certPath = Config.Agent.SSL_CERT_CHAIN_PATH;
                    String keyPath = Config.Agent.SSL_KEY_PATH;
                    if (StringUtil.isNotBlank(certPath) && StringUtil.isNotBlank(keyPath)) {
                        File keyFile = new File(AgentPackagePath.getPath(), keyPath);
                        File certFile = new File(AgentPackagePath.getPath(), certPath);
                        if (certFile.isFile() && keyFile.isFile()) {
                            try (FileInputStream cert = new FileInputStream(certFile);
                                 InputStream key = PrivateKeyUtil.loadDecryptionKey(keyFile.getAbsolutePath());){
                                builder.keyManager(cert, key);
                                break block29;
                            }
                        }
                        if (!certFile.isFile() || !keyFile.isFile()) {
                            LOGGER.warn("Failed to enable mTLS caused by cert or key cannot be found.", new Object[0]);
                        }
                    }
                }
                builder.trustManager(caFile);
            }
            managedChannelBuilder.negotiationType(NegotiationType.TLS).sslContext(builder.build());
        }
        return managedChannelBuilder;
    }
}

