/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.xreflection;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.xreflection.ReflectionLessCodeGenerator;
import org.apache.tomcat.util.xreflection.ReflectionProperty;
import org.apache.tomcat.util.xreflection.SetPropertyClass;

public final class ObjectReflectionPropertyInspector {
    private static final Set<Class<?>> ALLOWED_TYPES = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Boolean.TYPE, Integer.TYPE, Long.TYPE, String.class, InetAddress.class)));
    private static Map<Class<?>, SetPropertyClass> classes = new LinkedHashMap();

    public static void main(String ... args) throws Exception {
        File outputDir;
        if (args.length == 0) {
            System.err.println("Usage:\n\torg.apache.tomcat.util.xreflection.ObjectReflectionPropertyInspector <destination directory>");
            System.exit(1);
        }
        if (!(outputDir = new File(args[0])).exists() || !outputDir.isDirectory()) {
            System.err.println("Invalid output directory: " + outputDir.getAbsolutePath());
            System.exit(1);
        }
        Set baseClasses = ObjectReflectionPropertyInspector.getKnownClasses().stream().map(ObjectReflectionPropertyInspector::processClass).collect(Collectors.toCollection(LinkedHashSet::new));
        ObjectReflectionPropertyInspector.generateCode(baseClasses, "org.apache.tomcat.util", outputDir, "XReflectionIntrospectionUtils");
    }

    private static Set<Class<?>> getKnownClasses() throws ClassNotFoundException {
        return Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Class.forName("org.apache.catalina.authenticator.jaspic.SimpleAuthConfigProvider"), Class.forName("org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations$Property"), Class.forName("org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations$Provider"), Class.forName("org.apache.catalina.connector.Connector"), Class.forName("org.apache.catalina.core.ContainerBase"), Class.forName("org.apache.catalina.core.StandardContext"), Class.forName("org.apache.catalina.core.StandardEngine"), Class.forName("org.apache.catalina.core.StandardHost"), Class.forName("org.apache.catalina.core.StandardServer"), Class.forName("org.apache.catalina.core.StandardService"), Class.forName("org.apache.catalina.filters.AddDefaultCharsetFilter"), Class.forName("org.apache.catalina.filters.RestCsrfPreventionFilter"), Class.forName("org.apache.catalina.loader.ParallelWebappClassLoader"), Class.forName("org.apache.catalina.loader.WebappClassLoaderBase"), Class.forName("org.apache.catalina.realm.UserDatabaseRealm"), Class.forName("org.apache.catalina.valves.AccessLogValve"), Class.forName("org.apache.coyote.AbstractProtocol"), Class.forName("org.apache.coyote.ajp.AbstractAjpProtocol"), Class.forName("org.apache.coyote.ajp.AjpNio2Protocol"), Class.forName("org.apache.coyote.ajp.AjpNioProtocol"), Class.forName("org.apache.coyote.http11.AbstractHttp11JsseProtocol"), Class.forName("org.apache.coyote.http11.AbstractHttp11Protocol"), Class.forName("org.apache.coyote.http11.Http11Nio2Protocol"), Class.forName("org.apache.coyote.http11.Http11NioProtocol"), Class.forName("org.apache.tomcat.util.descriptor.web.ContextResource"), Class.forName("org.apache.tomcat.util.descriptor.web.ResourceBase"), Class.forName("org.apache.tomcat.util.modeler.AttributeInfo"), Class.forName("org.apache.tomcat.util.modeler.FeatureInfo"), Class.forName("org.apache.tomcat.util.modeler.ManagedBean"), Class.forName("org.apache.tomcat.util.modeler.OperationInfo"), Class.forName("org.apache.tomcat.util.modeler.ParameterInfo"), Class.forName("org.apache.tomcat.util.net.AbstractEndpoint"), Class.forName("org.apache.tomcat.util.net.Nio2Endpoint"), Class.forName("org.apache.tomcat.util.net.NioEndpoint"), Class.forName("org.apache.tomcat.util.net.SocketProperties"))));
    }

    public static void generateCode(Set<SetPropertyClass> baseClasses, String packageName, File location, String className) throws Exception {
        String packageDirectory = packageName.replace('.', '/');
        File sourceFileLocation = new File(location, packageDirectory);
        ReflectionLessCodeGenerator.generateCode(sourceFileLocation, className, packageName, baseClasses);
    }

    private static boolean isAllowedField(Field field) {
        return ALLOWED_TYPES.contains(field.getType()) && !Modifier.isFinal(field.getModifiers());
    }

    private static boolean isAllowedSetMethod(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes() != null && method.getParameterTypes().length == 1 && ALLOWED_TYPES.contains(method.getParameterTypes()[0]) && !Modifier.isPrivate(method.getModifiers());
    }

    private static boolean isAllowedGetMethod(Method method) {
        return !(!method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getParameterTypes() != null && method.getParameterTypes().length != 0 || !ALLOWED_TYPES.contains(method.getReturnType()) || Modifier.isPrivate(method.getModifiers()));
    }

    private static SetPropertyClass getOrCreateSetPropertyClass(Class<?> clazz) {
        boolean base = clazz.getSuperclass() == null || clazz.getSuperclass() == Object.class;
        SetPropertyClass spc = classes.get(clazz);
        if (spc == null) {
            spc = new SetPropertyClass(clazz, base ? null : ObjectReflectionPropertyInspector.getOrCreateSetPropertyClass(clazz.getSuperclass()));
            classes.put(clazz, spc);
        }
        return spc;
    }

    static Method findGetter(Class<?> declaringClass, String propertyName) {
        for (String getterName : Arrays.asList("get" + IntrospectionUtils.capitalize(propertyName), "is" + propertyName)) {
            try {
                Method method = declaringClass.getMethod(getterName, new Class[0]);
                if (Modifier.isPrivate(method.getModifiers())) continue;
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        try {
            Method method = declaringClass.getMethod("getProperty", String.class, String.class);
            if (!Modifier.isPrivate(method.getModifiers())) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    static Method findSetter(Class<?> declaringClass, String propertyName, Class<?> propertyType) {
        Method method2;
        try {
            method2 = declaringClass.getMethod("set" + IntrospectionUtils.capitalize(propertyName), propertyType);
            if (!Modifier.isPrivate(method2.getModifiers())) {
                return method2;
            }
        }
        catch (NoSuchMethodException method2) {
            // empty catch block
        }
        try {
            method2 = declaringClass.getMethod("setProperty", String.class, String.class);
            if (!Modifier.isPrivate(method2.getModifiers())) {
                return method2;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static SetPropertyClass processClass(Class<?> clazz) {
        Field[] fields;
        Method[] methods;
        SetPropertyClass spc = ObjectReflectionPropertyInspector.getOrCreateSetPropertyClass(clazz);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (ObjectReflectionPropertyInspector.isAllowedSetMethod(method)) {
                String propertyName = ObjectReflectionPropertyInspector.decapitalize(method.getName().substring(3));
                Class<?> propertyType = method.getParameterTypes()[0];
                Method getter = ObjectReflectionPropertyInspector.findGetter(clazz, propertyName);
                Method setter = ObjectReflectionPropertyInspector.findSetter(clazz, propertyName, propertyType);
                ReflectionProperty property = new ReflectionProperty(spc.getClazz().getName(), propertyName, propertyType, setter, getter);
                spc.addProperty(property);
                continue;
            }
            if (!ObjectReflectionPropertyInspector.isAllowedGetMethod(method)) continue;
            boolean startsWithIs = method.getName().startsWith("is");
            String propertyName = ObjectReflectionPropertyInspector.decapitalize(method.getName().substring(startsWithIs ? 2 : 3));
            Class<?> propertyType = method.getReturnType();
            Method getter = ObjectReflectionPropertyInspector.findGetter(clazz, propertyName);
            Method setter = ObjectReflectionPropertyInspector.findSetter(clazz, propertyName, propertyType);
            ReflectionProperty property = new ReflectionProperty(spc.getClazz().getName(), propertyName, propertyType, setter, getter);
            spc.addProperty(property);
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!ObjectReflectionPropertyInspector.isAllowedField(field)) continue;
            Method getter = ObjectReflectionPropertyInspector.findGetter(field.getDeclaringClass(), IntrospectionUtils.capitalize(field.getName()));
            Method setter = ObjectReflectionPropertyInspector.findSetter(field.getDeclaringClass(), IntrospectionUtils.capitalize(field.getName()), field.getType());
            ReflectionProperty property = new ReflectionProperty(spc.getClazz().getName(), field.getName(), field.getType(), setter, getter);
            spc.addProperty(property);
        }
        if (!spc.isBaseClass()) {
            SetPropertyClass parent = ObjectReflectionPropertyInspector.getOrCreateSetPropertyClass(spc.getClazz().getSuperclass());
            parent.addSubClass(spc);
            return ObjectReflectionPropertyInspector.processClass(parent.getClazz());
        }
        return spc;
    }
}

