/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.xreflection;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import org.apache.tomcat.util.xreflection.SetPropertyClass;

final class ReflectionLessCodeGenerator {
    private static final String INDENT = "    ";
    private static final String AL20_HEADER = "/*\n * Licensed to the Apache Software Foundation (ASF) under one or more\n * contributor license agreements.  See the NOTICE file distributed with\n * this work for additional information regarding copyright ownership.\n * The ASF licenses this file to You under the Apache License, Version 2.0\n * (the \"License\"); you may not use this file except in compliance with\n * the License.  You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n";

    ReflectionLessCodeGenerator() {
    }

    static StringBuilder getIndent(int multiplier) {
        StringBuilder indent = new StringBuilder();
        while (multiplier-- > 0) {
            indent.append(INDENT);
        }
        return indent;
    }

    static void generateCode(File directory, String className, String packageName, Set<SetPropertyClass> baseClasses) throws IOException {
        StringBuilder code = new StringBuilder(AL20_HEADER).append("package ").append(packageName).append(';').append(System.lineSeparator()).append(System.lineSeparator()).append("final class ").append(className).append(" {").append(System.lineSeparator()).append(System.lineSeparator());
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(1)).append("static boolean isEnabled() {").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("return true;").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(1)).append('}').append(System.lineSeparator()).append(System.lineSeparator());
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(1)).append("private static java.net.InetAddress getInetAddress(String value) {").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("try {").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("return java.net.InetAddress.getByName(value);").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("} catch (java.net.UnknownHostException x) { throw new RuntimeException(x); }").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(1)).append('}').append(System.lineSeparator()).append(System.lineSeparator());
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(1)).append("static Object getPropertyInternal(Object ").append("o").append(", String ").append("name").append(") {").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("Class<?> checkThisClass = o.getClass();").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("Object result = null;").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("while (checkThisClass != Object.class && result == null) {").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("switch (checkThisClass.getName()) {").append(System.lineSeparator());
        ReflectionLessCodeGenerator.generateCaseStatementsForGetPropertyInternal(baseClasses, code);
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append('}').append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("checkThisClass = checkThisClass.getSuperclass();").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append('}').append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("return result;").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(1)).append('}').append(System.lineSeparator());
        ReflectionLessCodeGenerator.generateGetPropertyForMethods(baseClasses, code);
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(1)).append("static boolean setPropertyInternal(Object ").append("o").append(", String ").append("name").append(", String ").append("value").append(", boolean ").append("invokeSetProperty").append(") {").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("Class<?> checkThisClass = o.getClass();").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("while (checkThisClass != Object.class) {").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("switch (checkThisClass.getName()) {").append(System.lineSeparator());
        ReflectionLessCodeGenerator.generateCaseStatementsForSetPropertyInternal(baseClasses, code);
        code.append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append('}').append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(3)).append("checkThisClass = checkThisClass.getSuperclass();").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append('}').append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(2)).append("return false;").append(System.lineSeparator()).append((CharSequence)ReflectionLessCodeGenerator.getIndent(1)).append('}').append(System.lineSeparator());
        ReflectionLessCodeGenerator.generateSetPropertyForMethods(baseClasses, code);
        code.append('}').append(System.lineSeparator());
        File destination = new File(directory, className + ".java");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(destination, false));){
            writer.write(code.toString());
            writer.flush();
        }
    }

    private static void generateCaseStatementForSetPropertyInternal(SetPropertyClass clazz, StringBuilder code) {
        for (SetPropertyClass child : clazz.getChildren()) {
            ReflectionLessCodeGenerator.generateCaseStatementForSetPropertyInternal(child, code);
        }
        if (!clazz.isAbstract()) {
            code.append(clazz.generateInvocationSetForPropertyCaseStatement(4));
        }
    }

    private static void generateCaseStatementsForSetPropertyInternal(Set<SetPropertyClass> baseClasses, StringBuilder code) {
        for (SetPropertyClass clazz : baseClasses) {
            ReflectionLessCodeGenerator.generateCaseStatementForSetPropertyInternal(clazz, code);
        }
    }

    private static void generateSetPropertyForMethod(SetPropertyClass clazz, StringBuilder code) {
        for (SetPropertyClass child : clazz.getChildren()) {
            ReflectionLessCodeGenerator.generateSetPropertyForMethod(child, code);
        }
        code.append(clazz.generateSetPropertyForMethod()).append(System.lineSeparator()).append(System.lineSeparator());
    }

    private static void generateSetPropertyForMethods(Set<SetPropertyClass> baseClasses, StringBuilder code) {
        for (SetPropertyClass clazz : baseClasses) {
            ReflectionLessCodeGenerator.generateSetPropertyForMethod(clazz, code);
        }
    }

    private static void generateCaseStatementForGetPropertyInternal(SetPropertyClass clazz, StringBuilder code) {
        for (SetPropertyClass child : clazz.getChildren()) {
            ReflectionLessCodeGenerator.generateCaseStatementForGetPropertyInternal(child, code);
        }
        if (!clazz.isAbstract()) {
            code.append(clazz.generateInvocationGetForPropertyCaseStatement(4));
        }
    }

    private static void generateCaseStatementsForGetPropertyInternal(Set<SetPropertyClass> baseClasses, StringBuilder code) {
        for (SetPropertyClass clazz : baseClasses) {
            ReflectionLessCodeGenerator.generateCaseStatementForGetPropertyInternal(clazz, code);
        }
    }

    private static void generateGetPropertyForMethod(SetPropertyClass clazz, StringBuilder code) {
        for (SetPropertyClass child : clazz.getChildren()) {
            ReflectionLessCodeGenerator.generateGetPropertyForMethod(child, code);
        }
        code.append(clazz.generateGetPropertyForMethod()).append(System.lineSeparator()).append(System.lineSeparator());
    }

    private static void generateGetPropertyForMethods(Set<SetPropertyClass> baseClasses, StringBuilder code) {
        for (SetPropertyClass clazz : baseClasses) {
            ReflectionLessCodeGenerator.generateGetPropertyForMethod(clazz, code);
        }
    }
}

