// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.global;

import org.bytedeco.ffmpeg.avfilter.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;
import org.bytedeco.ffmpeg.avcodec.*;
import static org.bytedeco.ffmpeg.global.avcodec.*;
import org.bytedeco.ffmpeg.avformat.*;
import static org.bytedeco.ffmpeg.global.avformat.*;
import org.bytedeco.ffmpeg.postproc.*;
import static org.bytedeco.ffmpeg.global.postproc.*;
import org.bytedeco.ffmpeg.swscale.*;
import static org.bytedeco.ffmpeg.global.swscale.*;

public class avfilter extends org.bytedeco.ffmpeg.presets.avfilter {
    static { Loader.load(); }

// Parsed from <libavfilter/avfilter.h>

/*
 * filter layer
 * Copyright (c) 2007 Bobby Bingham
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVFILTER_AVFILTER_H
// #define AVFILTER_AVFILTER_H

/**
 * \file
 * \ingroup lavfi
 * Main libavfilter public API header
 */

/**
 * \defgroup lavfi libavfilter
 * Graph-based frame editing library.
 *
 * \{
 */

// #include <stddef.h>

// #include "libavutil/attributes.h"
// #include "libavutil/avutil.h"
// #include "libavutil/buffer.h"
// #include "libavutil/dict.h"
// #include "libavutil/frame.h"
// #include "libavutil/log.h"
// #include "libavutil/samplefmt.h"
// #include "libavutil/pixfmt.h"
// #include "libavutil/rational.h"

// #include "libavfilter/version_major.h"
// #ifndef HAVE_AV_CONFIG_H
/* When included as part of the ffmpeg build, only include the major version
 * to avoid unnecessary rebuilds. When included externally, keep including
 * the full version information. */
// #include "libavfilter/version.h"
// #endif

/**
 * Return the LIBAVFILTER_VERSION_INT constant.
 */
@NoException public static native @Cast("unsigned") int avfilter_version();

/**
 * Return the libavfilter build-time configuration.
 */
@NoException public static native @Cast("const char*") BytePointer avfilter_configuration();

/**
 * Return the libavfilter license.
 */
@NoException public static native @Cast("const char*") BytePointer avfilter_license();
// Targeting ..\avfilter\AVFilterPad.java


// Targeting ..\avfilter\AVFilterFormats.java



// #if FF_API_PAD_COUNT
/**
 * Get the number of elements in an AVFilter's inputs or outputs array.
 *
 * @deprecated Use avfilter_filter_pad_count() instead.
 */
@NoException public static native @Deprecated int avfilter_pad_count(@Const AVFilterPad pads);
// #endif

/**
 * Get the name of an AVFilterPad.
 *
 * @param pads an array of AVFilterPads
 * @param pad_idx index of the pad in the array; it is the caller's
 *                responsibility to ensure the index is valid
 *
 * @return name of the pad_idx'th pad in pads
 */
@NoException public static native @Cast("const char*") BytePointer avfilter_pad_get_name(@Const AVFilterPad pads, int pad_idx);

/**
 * Get the type of an AVFilterPad.
 *
 * @param pads an array of AVFilterPads
 * @param pad_idx index of the pad in the array; it is the caller's
 *                responsibility to ensure the index is valid
 *
 * @return type of the pad_idx'th pad in pads
 */
@NoException public static native @Cast("AVMediaType") int avfilter_pad_get_type(@Const AVFilterPad pads, int pad_idx);

/**
 * The number of the filter inputs is not determined just by AVFilter.inputs.
 * The filter might add additional inputs during initialization depending on the
 * options supplied to it.
 */
public static final int AVFILTER_FLAG_DYNAMIC_INPUTS =        (1 << 0);
/**
 * The number of the filter outputs is not determined just by AVFilter.outputs.
 * The filter might add additional outputs during initialization depending on
 * the options supplied to it.
 */
public static final int AVFILTER_FLAG_DYNAMIC_OUTPUTS =       (1 << 1);
/**
 * The filter supports multithreading by splitting frames into multiple parts
 * and processing them concurrently.
 */
public static final int AVFILTER_FLAG_SLICE_THREADS =         (1 << 2);
/**
 * The filter is a "metadata" filter - it does not modify the frame data in any
 * way. It may only affect the metadata (i.e. those fields copied by
 * av_frame_copy_props()).
 *
 * More precisely, this means:
 * - video: the data of any frame output by the filter must be exactly equal to
 *   some frame that is received on one of its inputs. Furthermore, all frames
 *   produced on a given output must correspond to frames received on the same
 *   input and their order must be unchanged. Note that the filter may still
 *   drop or duplicate the frames.
 * - audio: the data produced by the filter on any of its outputs (viewed e.g.
 *   as an array of interleaved samples) must be exactly equal to the data
 *   received by the filter on one of its inputs.
 */
public static final int AVFILTER_FLAG_METADATA_ONLY =         (1 << 3);
/**
 * Some filters support a generic "enable" expression option that can be used
 * to enable or disable a filter in the timeline. Filters supporting this
 * option have this flag set. When the enable expression is false, the default
 * no-op filter_frame() function is called in place of the filter_frame()
 * callback defined on each input pad, thus the frame is passed unchanged to
 * the next filters.
 */
public static final int AVFILTER_FLAG_SUPPORT_TIMELINE_GENERIC =  (1 << 16);
/**
 * Same as AVFILTER_FLAG_SUPPORT_TIMELINE_GENERIC, except that the filter will
 * have its filter_frame() callback(s) called as usual even when the enable
 * expression is false. The filter will disable filtering within the
 * filter_frame() callback(s) itself, for example executing code depending on
 * the AVFilterContext->is_disabled value.
 */
public static final int AVFILTER_FLAG_SUPPORT_TIMELINE_INTERNAL = (1 << 17);
/**
 * Handy mask to test whether the filter supports or no the timeline feature
 * (internally or generically).
 */
public static final int AVFILTER_FLAG_SUPPORT_TIMELINE = (AVFILTER_FLAG_SUPPORT_TIMELINE_GENERIC | AVFILTER_FLAG_SUPPORT_TIMELINE_INTERNAL);
// Targeting ..\avfilter\AVFilter.java



/**
 * Get the number of elements in an AVFilter's inputs or outputs array.
 */
@NoException public static native @Cast("unsigned") int avfilter_filter_pad_count(@Const AVFilter filter, int is_output);

/**
 * Process multiple parts of the frame concurrently.
 */
public static final int AVFILTER_THREAD_SLICE = (1 << 0);
// Targeting ..\avfilter\AVFilterInternal.java


// Targeting ..\avfilter\AVFilterContext.java


// Targeting ..\avfilter\AVFilterFormatsConfig.java


// Targeting ..\avfilter\AVFilterLink.java



/**
 * Link two filters together.
 *
 * @param src    the source filter
 * @param srcpad index of the output pad on the source filter
 * @param dst    the destination filter
 * @param dstpad index of the input pad on the destination filter
 * @return       zero on success
 */
@NoException public static native int avfilter_link(AVFilterContext src, @Cast("unsigned") int srcpad,
                  AVFilterContext dst, @Cast("unsigned") int dstpad);

/**
 * Free the link in *link, and set its pointer to NULL.
 */
@NoException public static native void avfilter_link_free(@Cast("AVFilterLink**") PointerPointer link);
@NoException public static native void avfilter_link_free(@ByPtrPtr AVFilterLink link);

/**
 * Negotiate the media format, dimensions, etc of all inputs to a filter.
 *
 * @param filter the filter to negotiate the properties for its inputs
 * @return       zero on successful negotiation
 */
@NoException public static native int avfilter_config_links(AVFilterContext filter);

/** Stop once a filter understood the command (for target=all for example), fast filters are favored automatically */
public static final int AVFILTER_CMD_FLAG_ONE =   1;
/** Only execute command when its fast (like a video out that supports contrast adjustment in hw) */
public static final int AVFILTER_CMD_FLAG_FAST =  2;

/**
 * Make the filter instance process a command.
 * It is recommended to use avfilter_graph_send_command().
 */
@NoException public static native int avfilter_process_command(AVFilterContext filter, @Cast("const char*") BytePointer cmd, @Cast("const char*") BytePointer arg, @Cast("char*") BytePointer res, int res_len, int flags);
@NoException public static native int avfilter_process_command(AVFilterContext filter, String cmd, String arg, @Cast("char*") ByteBuffer res, int res_len, int flags);
@NoException public static native int avfilter_process_command(AVFilterContext filter, @Cast("const char*") BytePointer cmd, @Cast("const char*") BytePointer arg, @Cast("char*") byte[] res, int res_len, int flags);
@NoException public static native int avfilter_process_command(AVFilterContext filter, String cmd, String arg, @Cast("char*") BytePointer res, int res_len, int flags);
@NoException public static native int avfilter_process_command(AVFilterContext filter, @Cast("const char*") BytePointer cmd, @Cast("const char*") BytePointer arg, @Cast("char*") ByteBuffer res, int res_len, int flags);
@NoException public static native int avfilter_process_command(AVFilterContext filter, String cmd, String arg, @Cast("char*") byte[] res, int res_len, int flags);

/**
 * Iterate over all registered filters.
 *
 * @param opaque a pointer where libavfilter will store the iteration state. Must
 *               point to NULL to start the iteration.
 *
 * @return the next registered filter or NULL when the iteration is
 *         finished
 */
@NoException public static native @Const AVFilter av_filter_iterate(@Cast("void**") PointerPointer opaque);
@NoException public static native @Const AVFilter av_filter_iterate(@Cast("void**") @ByPtrPtr Pointer opaque);

/**
 * Get a filter definition matching the given name.
 *
 * @param name the filter name to find
 * @return     the filter definition, if any matching one is registered.
 *             NULL if none found.
 */
@NoException public static native @Const AVFilter avfilter_get_by_name(@Cast("const char*") BytePointer name);
@NoException public static native @Const AVFilter avfilter_get_by_name(String name);


/**
 * Initialize a filter with the supplied parameters.
 *
 * @param ctx  uninitialized filter context to initialize
 * @param args Options to initialize the filter with. This must be a
 *             ':'-separated list of options in the 'key=value' form.
 *             May be NULL if the options have been set directly using the
 *             AVOptions API or there are no options that need to be set.
 * @return 0 on success, a negative AVERROR on failure
 */
@NoException public static native int avfilter_init_str(AVFilterContext ctx, @Cast("const char*") BytePointer args);
@NoException public static native int avfilter_init_str(AVFilterContext ctx, String args);

/**
 * Initialize a filter with the supplied dictionary of options.
 *
 * @param ctx     uninitialized filter context to initialize
 * @param options An AVDictionary filled with options for this filter. On
 *                return this parameter will be destroyed and replaced with
 *                a dict containing options that were not found. This dictionary
 *                must be freed by the caller.
 *                May be NULL, then this function is equivalent to
 *                avfilter_init_str() with the second parameter set to NULL.
 * @return 0 on success, a negative AVERROR on failure
 *
 * \note This function and avfilter_init_str() do essentially the same thing,
 * the difference is in manner in which the options are passed. It is up to the
 * calling code to choose whichever is more preferable. The two functions also
 * behave differently when some of the provided options are not declared as
 * supported by the filter. In such a case, avfilter_init_str() will fail, but
 * this function will leave those extra options in the options AVDictionary and
 * continue as usual.
 */
@NoException public static native int avfilter_init_dict(AVFilterContext ctx, @Cast("AVDictionary**") PointerPointer options);
@NoException public static native int avfilter_init_dict(AVFilterContext ctx, @ByPtrPtr AVDictionary options);

/**
 * Free a filter context. This will also remove the filter from its
 * filtergraph's list of filters.
 *
 * @param filter the filter to free
 */
@NoException public static native void avfilter_free(AVFilterContext filter);

/**
 * Insert a filter in the middle of an existing link.
 *
 * @param link the link into which the filter should be inserted
 * @param filt the filter to be inserted
 * @param filt_srcpad_idx the input pad on the filter to connect
 * @param filt_dstpad_idx the output pad on the filter to connect
 * @return     zero on success
 */
@NoException public static native int avfilter_insert_filter(AVFilterLink link, AVFilterContext filt,
                           @Cast("unsigned") int filt_srcpad_idx, @Cast("unsigned") int filt_dstpad_idx);

/**
 * @return AVClass for AVFilterContext.
 *
 * @see av_opt_find().
 */
@NoException public static native @Const AVClass avfilter_get_class();
// Targeting ..\avfilter\AVFilterGraphInternal.java


// Targeting ..\avfilter\avfilter_action_func.java


// Targeting ..\avfilter\avfilter_execute_func.java


// Targeting ..\avfilter\AVFilterGraph.java



/**
 * Allocate a filter graph.
 *
 * @return the allocated filter graph on success or NULL.
 */
@NoException public static native AVFilterGraph avfilter_graph_alloc();

/**
 * Create a new filter instance in a filter graph.
 *
 * @param graph graph in which the new filter will be used
 * @param filter the filter to create an instance of
 * @param name Name to give to the new instance (will be copied to
 *             AVFilterContext.name). This may be used by the caller to identify
 *             different filters, libavfilter itself assigns no semantics to
 *             this parameter. May be NULL.
 *
 * @return the context of the newly created filter instance (note that it is
 *         also retrievable directly through AVFilterGraph.filters or with
 *         avfilter_graph_get_filter()) on success or NULL on failure.
 */
@NoException public static native AVFilterContext avfilter_graph_alloc_filter(AVFilterGraph graph,
                                             @Const AVFilter filter,
                                             @Cast("const char*") BytePointer name);
@NoException public static native AVFilterContext avfilter_graph_alloc_filter(AVFilterGraph graph,
                                             @Const AVFilter filter,
                                             String name);

/**
 * Get a filter instance identified by instance name from graph.
 *
 * @param graph filter graph to search through.
 * @param name filter instance name (should be unique in the graph).
 * @return the pointer to the found filter instance or NULL if it
 * cannot be found.
 */
@NoException public static native AVFilterContext avfilter_graph_get_filter(AVFilterGraph graph, @Cast("const char*") BytePointer name);
@NoException public static native AVFilterContext avfilter_graph_get_filter(AVFilterGraph graph, String name);

/**
 * Create and add a filter instance into an existing graph.
 * The filter instance is created from the filter filt and inited
 * with the parameter args. opaque is currently ignored.
 *
 * In case of success put in *filt_ctx the pointer to the created
 * filter instance, otherwise set *filt_ctx to NULL.
 *
 * @param name the instance name to give to the created filter instance
 * @param graph_ctx the filter graph
 * @return a negative AVERROR error code in case of failure, a non
 * negative value otherwise
 */
@NoException public static native int avfilter_graph_create_filter(@Cast("AVFilterContext**") PointerPointer filt_ctx, @Const AVFilter filt,
                                 @Cast("const char*") BytePointer name, @Cast("const char*") BytePointer args, Pointer opaque,
                                 AVFilterGraph graph_ctx);
@NoException public static native int avfilter_graph_create_filter(@ByPtrPtr AVFilterContext filt_ctx, @Const AVFilter filt,
                                 @Cast("const char*") BytePointer name, @Cast("const char*") BytePointer args, Pointer opaque,
                                 AVFilterGraph graph_ctx);
@NoException public static native int avfilter_graph_create_filter(@ByPtrPtr AVFilterContext filt_ctx, @Const AVFilter filt,
                                 String name, String args, Pointer opaque,
                                 AVFilterGraph graph_ctx);

/**
 * Enable or disable automatic format conversion inside the graph.
 *
 * Note that format conversion can still happen inside explicitly inserted
 * scale and aresample filters.
 *
 * @param flags  any of the AVFILTER_AUTO_CONVERT_* constants
 */
@NoException public static native void avfilter_graph_set_auto_convert(AVFilterGraph graph, @Cast("unsigned") int flags);

/** enum  */
public static final int
    /** all automatic conversions enabled */
    AVFILTER_AUTO_CONVERT_ALL  = 0,
    /** all automatic conversions disabled */
    AVFILTER_AUTO_CONVERT_NONE = -1;

/**
 * Check validity and configure all the links and formats in the graph.
 *
 * @param graphctx the filter graph
 * @param log_ctx context used for logging
 * @return >= 0 in case of success, a negative AVERROR code otherwise
 */
@NoException public static native int avfilter_graph_config(AVFilterGraph graphctx, Pointer log_ctx);

/**
 * Free a graph, destroy its links, and set *graph to NULL.
 * If *graph is NULL, do nothing.
 */
@NoException public static native void avfilter_graph_free(@Cast("AVFilterGraph**") PointerPointer graph);
@NoException public static native void avfilter_graph_free(@ByPtrPtr AVFilterGraph graph);
// Targeting ..\avfilter\AVFilterInOut.java



/**
 * Allocate a single AVFilterInOut entry.
 * Must be freed with avfilter_inout_free().
 * @return allocated AVFilterInOut on success, NULL on failure.
 */
@NoException public static native AVFilterInOut avfilter_inout_alloc();

/**
 * Free the supplied list of AVFilterInOut and set *inout to NULL.
 * If *inout is NULL, do nothing.
 */
@NoException public static native void avfilter_inout_free(@Cast("AVFilterInOut**") PointerPointer inout);
@NoException public static native void avfilter_inout_free(@ByPtrPtr AVFilterInOut inout);

/**
 * Add a graph described by a string to a graph.
 *
 * \note The caller must provide the lists of inputs and outputs,
 * which therefore must be known before calling the function.
 *
 * \note The inputs parameter describes inputs of the already existing
 * part of the graph; i.e. from the point of view of the newly created
 * part, they are outputs. Similarly the outputs parameter describes
 * outputs of the already existing filters, which are provided as
 * inputs to the parsed filters.
 *
 * @param graph   the filter graph where to link the parsed graph context
 * @param filters string to be parsed
 * @param inputs  linked list to the inputs of the graph
 * @param outputs linked list to the outputs of the graph
 * @return zero on success, a negative AVERROR code on error
 */
@NoException public static native int avfilter_graph_parse(AVFilterGraph graph, @Cast("const char*") BytePointer filters,
                         AVFilterInOut inputs, AVFilterInOut outputs,
                         Pointer log_ctx);
@NoException public static native int avfilter_graph_parse(AVFilterGraph graph, String filters,
                         AVFilterInOut inputs, AVFilterInOut outputs,
                         Pointer log_ctx);

/**
 * Add a graph described by a string to a graph.
 *
 * In the graph filters description, if the input label of the first
 * filter is not specified, "in" is assumed; if the output label of
 * the last filter is not specified, "out" is assumed.
 *
 * @param graph   the filter graph where to link the parsed graph context
 * @param filters string to be parsed
 * @param inputs  pointer to a linked list to the inputs of the graph, may be NULL.
 *                If non-NULL, *inputs is updated to contain the list of open inputs
 *                after the parsing, should be freed with avfilter_inout_free().
 * @param outputs pointer to a linked list to the outputs of the graph, may be NULL.
 *                If non-NULL, *outputs is updated to contain the list of open outputs
 *                after the parsing, should be freed with avfilter_inout_free().
 * @return non negative on success, a negative AVERROR code on error
 */
@NoException public static native int avfilter_graph_parse_ptr(AVFilterGraph graph, @Cast("const char*") BytePointer filters,
                             @Cast("AVFilterInOut**") PointerPointer inputs, @Cast("AVFilterInOut**") PointerPointer outputs,
                             Pointer log_ctx);
@NoException public static native int avfilter_graph_parse_ptr(AVFilterGraph graph, @Cast("const char*") BytePointer filters,
                             @ByPtrPtr AVFilterInOut inputs, @ByPtrPtr AVFilterInOut outputs,
                             Pointer log_ctx);
@NoException public static native int avfilter_graph_parse_ptr(AVFilterGraph graph, String filters,
                             @ByPtrPtr AVFilterInOut inputs, @ByPtrPtr AVFilterInOut outputs,
                             Pointer log_ctx);

/**
 * Add a graph described by a string to a graph.
 *
 * @param graph [in]   the filter graph where to link the parsed graph context
 * @param filters [in] string to be parsed
 * @param inputs [out]  a linked list of all free (unlinked) inputs of the
 *                     parsed graph will be returned here. It is to be freed
 *                     by the caller using avfilter_inout_free().
 * @param outputs [out] a linked list of all free (unlinked) outputs of the
 *                     parsed graph will be returned here. It is to be freed by the
 *                     caller using avfilter_inout_free().
 * @return zero on success, a negative AVERROR code on error
 *
 * \note This function returns the inputs and outputs that are left
 * unlinked after parsing the graph and the caller then deals with
 * them.
 * \note This function makes no reference whatsoever to already
 * existing parts of the graph and the inputs parameter will on return
 * contain inputs of the newly parsed part of the graph.  Analogously
 * the outputs parameter will contain outputs of the newly created
 * filters.
 */
@NoException public static native int avfilter_graph_parse2(AVFilterGraph graph, @Cast("const char*") BytePointer filters,
                          @Cast("AVFilterInOut**") PointerPointer inputs,
                          @Cast("AVFilterInOut**") PointerPointer outputs);
@NoException public static native int avfilter_graph_parse2(AVFilterGraph graph, @Cast("const char*") BytePointer filters,
                          @ByPtrPtr AVFilterInOut inputs,
                          @ByPtrPtr AVFilterInOut outputs);
@NoException public static native int avfilter_graph_parse2(AVFilterGraph graph, String filters,
                          @ByPtrPtr AVFilterInOut inputs,
                          @ByPtrPtr AVFilterInOut outputs);

/**
 * Send a command to one or more filter instances.
 *
 * @param graph  the filter graph
 * @param target the filter(s) to which the command should be sent
 *               "all" sends to all filters
 *               otherwise it can be a filter or filter instance name
 *               which will send the command to all matching filters.
 * @param cmd    the command to send, for handling simplicity all commands must be alphanumeric only
 * @param arg    the argument for the command
 * @param res    a buffer with size res_size where the filter(s) can return a response.
 *
 * @return >=0 on success otherwise an error code.
 *              AVERROR(ENOSYS) on unsupported commands
 */
@NoException public static native int avfilter_graph_send_command(AVFilterGraph graph, @Cast("const char*") BytePointer target, @Cast("const char*") BytePointer cmd, @Cast("const char*") BytePointer arg, @Cast("char*") BytePointer res, int res_len, int flags);
@NoException public static native int avfilter_graph_send_command(AVFilterGraph graph, String target, String cmd, String arg, @Cast("char*") ByteBuffer res, int res_len, int flags);
@NoException public static native int avfilter_graph_send_command(AVFilterGraph graph, @Cast("const char*") BytePointer target, @Cast("const char*") BytePointer cmd, @Cast("const char*") BytePointer arg, @Cast("char*") byte[] res, int res_len, int flags);
@NoException public static native int avfilter_graph_send_command(AVFilterGraph graph, String target, String cmd, String arg, @Cast("char*") BytePointer res, int res_len, int flags);
@NoException public static native int avfilter_graph_send_command(AVFilterGraph graph, @Cast("const char*") BytePointer target, @Cast("const char*") BytePointer cmd, @Cast("const char*") BytePointer arg, @Cast("char*") ByteBuffer res, int res_len, int flags);
@NoException public static native int avfilter_graph_send_command(AVFilterGraph graph, String target, String cmd, String arg, @Cast("char*") byte[] res, int res_len, int flags);

/**
 * Queue a command for one or more filter instances.
 *
 * @param graph  the filter graph
 * @param target the filter(s) to which the command should be sent
 *               "all" sends to all filters
 *               otherwise it can be a filter or filter instance name
 *               which will send the command to all matching filters.
 * @param cmd    the command to sent, for handling simplicity all commands must be alphanumeric only
 * @param arg    the argument for the command
 * @param ts     time at which the command should be sent to the filter
 *
 * \note As this executes commands after this function returns, no return code
 *       from the filter is provided, also AVFILTER_CMD_FLAG_ONE is not supported.
 */
@NoException public static native int avfilter_graph_queue_command(AVFilterGraph graph, @Cast("const char*") BytePointer target, @Cast("const char*") BytePointer cmd, @Cast("const char*") BytePointer arg, int flags, double ts);
@NoException public static native int avfilter_graph_queue_command(AVFilterGraph graph, String target, String cmd, String arg, int flags, double ts);


/**
 * Dump a graph into a human-readable string representation.
 *
 * @param graph    the graph to dump
 * @param options  formatting options; currently ignored
 * @return  a string, or NULL in case of memory allocation failure;
 *          the string must be freed using av_free
 */
@NoException public static native @Cast("char*") BytePointer avfilter_graph_dump(AVFilterGraph graph, @Cast("const char*") BytePointer options);
@NoException public static native @Cast("char*") ByteBuffer avfilter_graph_dump(AVFilterGraph graph, String options);

/**
 * Request a frame on the oldest sink link.
 *
 * If the request returns AVERROR_EOF, try the next.
 *
 * Note that this function is not meant to be the sole scheduling mechanism
 * of a filtergraph, only a convenience function to help drain a filtergraph
 * in a balanced way under normal circumstances.
 *
 * Also note that AVERROR_EOF does not mean that frames did not arrive on
 * some of the sinks during the process.
 * When there are multiple sink links, in case the requested link
 * returns an EOF, this may cause a filter to flush pending frames
 * which are sent to another sink link, although unrequested.
 *
 * @return  the return value of ff_request_frame(),
 *          or AVERROR_EOF if all links returned AVERROR_EOF
 */
@NoException public static native int avfilter_graph_request_oldest(AVFilterGraph graph);

/**
 * \}
 */

// #endif /* AVFILTER_AVFILTER_H */


// Parsed from <libavfilter/buffersink.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVFILTER_BUFFERSINK_H
// #define AVFILTER_BUFFERSINK_H

/**
 * \file
 * \ingroup lavfi_buffersink
 * memory buffer sink API for audio and video
 */

// #include "avfilter.h"

/**
 * \defgroup lavfi_buffersink Buffer sink API
 * \ingroup lavfi
 * \{
 *
 * The buffersink and abuffersink filters are there to connect filter graphs
 * to applications. They have a single input, connected to the graph, and no
 * output. Frames must be extracted using av_buffersink_get_frame() or
 * av_buffersink_get_samples().
 *
 * The format negotiated by the graph during configuration can be obtained
 * using the accessor functions:
 * - av_buffersink_get_time_base(),
 * - av_buffersink_get_format(),
 * - av_buffersink_get_frame_rate(),
 * - av_buffersink_get_w(),
 * - av_buffersink_get_h(),
 * - av_buffersink_get_sample_aspect_ratio(),
 * - av_buffersink_get_channels(),
 * - av_buffersink_get_ch_layout(),
 * - av_buffersink_get_sample_rate().
 *
 * The layout returned by av_buffersink_get_ch_layout() must de uninitialized
 * by the caller.
 *
 * The format can be constrained by setting options, using av_opt_set() and
 * related functions with the AV_OPT_SEARCH_CHILDREN flag.
 *  - pix_fmts (int list),
 *  - sample_fmts (int list),
 *  - sample_rates (int list),
 *  - ch_layouts (string),
 *  - channel_counts (int list),
 *  - all_channel_counts (bool).
 * Most of these options are of type binary, and should be set using
 * av_opt_set_int_list() or av_opt_set_bin(). If they are not set, all
 * corresponding formats are accepted.
 *
 * As a special case, if ch_layouts is not set, all valid channel layouts are
 * accepted except for UNSPEC layouts, unless all_channel_counts is set.
 */

/**
 * Get a frame with filtered data from sink and put it in frame.
 *
 * @param ctx    pointer to a buffersink or abuffersink filter context.
 * @param frame  pointer to an allocated frame that will be filled with data.
 *               The data must be freed using av_frame_unref() / av_frame_free()
 * @param flags  a combination of AV_BUFFERSINK_FLAG_* flags
 *
 * @return  >= 0 in for success, a negative AVERROR code for failure.
 */
@NoException public static native int av_buffersink_get_frame_flags(AVFilterContext ctx, AVFrame frame, int flags);

/**
 * Tell av_buffersink_get_buffer_ref() to read video/samples buffer
 * reference, but not remove it from the buffer. This is useful if you
 * need only to read a video/samples buffer, without to fetch it.
 */
public static final int AV_BUFFERSINK_FLAG_PEEK = 1;

/**
 * Tell av_buffersink_get_buffer_ref() not to request a frame from its input.
 * If a frame is already buffered, it is read (and removed from the buffer),
 * but if no frame is present, return AVERROR(EAGAIN).
 */
public static final int AV_BUFFERSINK_FLAG_NO_REQUEST = 2;
// Targeting ..\avfilter\AVBufferSinkParams.java



/**
 * Create an AVBufferSinkParams structure.
 *
 * Must be freed with av_free().
 */
@NoException public static native @Deprecated AVBufferSinkParams av_buffersink_params_alloc();
// Targeting ..\avfilter\AVABufferSinkParams.java



/**
 * Create an AVABufferSinkParams structure.
 *
 * Must be freed with av_free().
 */
@NoException public static native @Deprecated AVABufferSinkParams av_abuffersink_params_alloc();
// #endif

/**
 * Set the frame size for an audio buffer sink.
 *
 * All calls to av_buffersink_get_buffer_ref will return a buffer with
 * exactly the specified number of samples, or AVERROR(EAGAIN) if there is
 * not enough. The last buffer at EOF will be padded with 0.
 */
@NoException public static native void av_buffersink_set_frame_size(AVFilterContext ctx, @Cast("unsigned") int frame_size);

/**
 * \defgroup lavfi_buffersink_accessors Buffer sink accessors
 * Get the properties of the stream
 * \{
 */

@NoException public static native @Cast("AVMediaType") int av_buffersink_get_type(@Const AVFilterContext ctx);
@NoException public static native @ByVal AVRational av_buffersink_get_time_base(@Const AVFilterContext ctx);
@NoException public static native int av_buffersink_get_format(@Const AVFilterContext ctx);

@NoException public static native @ByVal AVRational av_buffersink_get_frame_rate(@Const AVFilterContext ctx);
@NoException public static native int av_buffersink_get_w(@Const AVFilterContext ctx);
@NoException public static native int av_buffersink_get_h(@Const AVFilterContext ctx);
@NoException public static native @ByVal AVRational av_buffersink_get_sample_aspect_ratio(@Const AVFilterContext ctx);

@NoException public static native int av_buffersink_get_channels(@Const AVFilterContext ctx);
// #if FF_API_OLD_CHANNEL_LAYOUT
@NoException public static native @Cast("uint64_t") @Deprecated long av_buffersink_get_channel_layout(@Const AVFilterContext ctx);
// #endif
@NoException public static native int av_buffersink_get_ch_layout(@Const AVFilterContext ctx,
                                                        AVChannelLayout ch_layout);
@NoException public static native int av_buffersink_get_sample_rate(@Const AVFilterContext ctx);

@NoException public static native AVBufferRef av_buffersink_get_hw_frames_ctx(@Const AVFilterContext ctx);

/** \} */

/**
 * Get a frame with filtered data from sink and put it in frame.
 *
 * @param ctx pointer to a context of a buffersink or abuffersink AVFilter.
 * @param frame pointer to an allocated frame that will be filled with data.
 *              The data must be freed using av_frame_unref() / av_frame_free()
 *
 * @return
 *         - >= 0 if a frame was successfully returned.
 *         - AVERROR(EAGAIN) if no frames are available at this point; more
 *           input frames must be added to the filtergraph to get more output.
 *         - AVERROR_EOF if there will be no more output frames on this sink.
 *         - A different negative AVERROR code in other failure cases.
 */
@NoException public static native int av_buffersink_get_frame(AVFilterContext ctx, AVFrame frame);

/**
 * Same as av_buffersink_get_frame(), but with the ability to specify the number
 * of samples read. This function is less efficient than
 * av_buffersink_get_frame(), because it copies the data around.
 *
 * @param ctx pointer to a context of the abuffersink AVFilter.
 * @param frame pointer to an allocated frame that will be filled with data.
 *              The data must be freed using av_frame_unref() / av_frame_free()
 *              frame will contain exactly nb_samples audio samples, except at
 *              the end of stream, when it can contain less than nb_samples.
 *
 * @return The return codes have the same meaning as for
 *         av_buffersink_get_frame().
 *
 * \warning do not mix this function with av_buffersink_get_frame(). Use only one or
 * the other with a single sink, not both.
 */
@NoException public static native int av_buffersink_get_samples(AVFilterContext ctx, AVFrame frame, int nb_samples);

/**
 * \}
 */

// #endif /* AVFILTER_BUFFERSINK_H */


// Parsed from <libavfilter/buffersrc.h>

/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVFILTER_BUFFERSRC_H
// #define AVFILTER_BUFFERSRC_H

/**
 * \file
 * \ingroup lavfi_buffersrc
 * Memory buffer source API.
 */

// #include "avfilter.h"

/**
 * \defgroup lavfi_buffersrc Buffer source API
 * \ingroup lavfi
 * \{
 */

/** enum  */
public static final int

    /**
     * Do not check for format changes.
     */
    AV_BUFFERSRC_FLAG_NO_CHECK_FORMAT = 1,

    /**
     * Immediately push the frame to the output.
     */
    AV_BUFFERSRC_FLAG_PUSH = 4,

    /**
     * Keep a reference to the frame.
     * If the frame if reference-counted, create a new reference; otherwise
     * copy the frame data.
     */
    AV_BUFFERSRC_FLAG_KEEP_REF = 8;

/**
 * Get the number of failed requests.
 *
 * A failed request is when the request_frame method is called while no
 * frame is present in the buffer.
 * The number is reset when a frame is added.
 */
@NoException public static native @Cast("unsigned") int av_buffersrc_get_nb_failed_requests(AVFilterContext buffer_src);
// Targeting ..\avfilter\AVBufferSrcParameters.java



/**
 * Allocate a new AVBufferSrcParameters instance. It should be freed by the
 * caller with av_free().
 */
@NoException public static native AVBufferSrcParameters av_buffersrc_parameters_alloc();

/**
 * Initialize the buffersrc or abuffersrc filter with the provided parameters.
 * This function may be called multiple times, the later calls override the
 * previous ones. Some of the parameters may also be set through AVOptions, then
 * whatever method is used last takes precedence.
 *
 * @param ctx an instance of the buffersrc or abuffersrc filter
 * @param param the stream parameters. The frames later passed to this filter
 *              must conform to those parameters. All the allocated fields in
 *              param remain owned by the caller, libavfilter will make internal
 *              copies or references when necessary.
 * @return 0 on success, a negative AVERROR code on failure.
 */
@NoException public static native int av_buffersrc_parameters_set(AVFilterContext ctx, AVBufferSrcParameters param);

/**
 * Add a frame to the buffer source.
 *
 * @param ctx   an instance of the buffersrc filter
 * @param frame frame to be added. If the frame is reference counted, this
 * function will make a new reference to it. Otherwise the frame data will be
 * copied.
 *
 * @return 0 on success, a negative AVERROR on error
 *
 * This function is equivalent to av_buffersrc_add_frame_flags() with the
 * AV_BUFFERSRC_FLAG_KEEP_REF flag.
 */
@NoException public static native int av_buffersrc_write_frame(AVFilterContext ctx, @Const AVFrame frame);

/**
 * Add a frame to the buffer source.
 *
 * @param ctx   an instance of the buffersrc filter
 * @param frame frame to be added. If the frame is reference counted, this
 * function will take ownership of the reference(s) and reset the frame.
 * Otherwise the frame data will be copied. If this function returns an error,
 * the input frame is not touched.
 *
 * @return 0 on success, a negative AVERROR on error.
 *
 * \note the difference between this function and av_buffersrc_write_frame() is
 * that av_buffersrc_write_frame() creates a new reference to the input frame,
 * while this function takes ownership of the reference passed to it.
 *
 * This function is equivalent to av_buffersrc_add_frame_flags() without the
 * AV_BUFFERSRC_FLAG_KEEP_REF flag.
 */
@NoException public static native int av_buffersrc_add_frame(AVFilterContext ctx, AVFrame frame);

/**
 * Add a frame to the buffer source.
 *
 * By default, if the frame is reference-counted, this function will take
 * ownership of the reference(s) and reset the frame. This can be controlled
 * using the flags.
 *
 * If this function returns an error, the input frame is not touched.
 *
 * @param buffer_src  pointer to a buffer source context
 * @param frame       a frame, or NULL to mark EOF
 * @param flags       a combination of AV_BUFFERSRC_FLAG_*
 * @return            >= 0 in case of success, a negative AVERROR code
 *                    in case of failure
 */
@NoException public static native int av_buffersrc_add_frame_flags(AVFilterContext buffer_src,
                                 AVFrame frame, int flags);

/**
 * Close the buffer source after EOF.
 *
 * This is similar to passing NULL to av_buffersrc_add_frame_flags()
 * except it takes the timestamp of the EOF, i.e. the timestamp of the end
 * of the last frame.
 */
@NoException public static native int av_buffersrc_close(AVFilterContext ctx, @Cast("int64_t") long pts, @Cast("unsigned") int flags);

/**
 * \}
 */

// #endif /* AVFILTER_BUFFERSRC_H */


// Parsed from <libavfilter/version_major.h>

/*
 * Version macros.
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVFILTER_VERSION_MAJOR_H
// #define AVFILTER_VERSION_MAJOR_H

/**
 * \file
 * \ingroup lavfi
 * Libavfilter version macros
 */

public static final int LIBAVFILTER_VERSION_MAJOR =   8;

/**
 * FF_API_* defines may be placed below to indicate public API that will be
 * dropped at a future version bump. The defines themselves are not part of
 * the public API and may change, break or disappear at any time.
 */

public static final boolean FF_API_SWS_PARAM_OPTION =             (LIBAVFILTER_VERSION_MAJOR < 9);
public static final boolean FF_API_BUFFERSINK_ALLOC =             (LIBAVFILTER_VERSION_MAJOR < 9);
public static final boolean FF_API_PAD_COUNT =                    (LIBAVFILTER_VERSION_MAJOR < 9);

// #endif /* AVFILTER_VERSION_MAJOR_H */


// Parsed from <libavfilter/version.h>

/*
 * Version macros.
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVFILTER_VERSION_H
// #define AVFILTER_VERSION_H

/**
 * \file
 * \ingroup lavfi
 * Libavfilter version macros
 */

// #include "libavutil/version.h"

// #include "version_major.h"

public static final int LIBAVFILTER_VERSION_MINOR =  44;
public static final int LIBAVFILTER_VERSION_MICRO = 100;


public static native @MemberGetter int LIBAVFILTER_VERSION_INT();
public static final int LIBAVFILTER_VERSION_INT = LIBAVFILTER_VERSION_INT();
// #define LIBAVFILTER_VERSION     AV_VERSION(LIBAVFILTER_VERSION_MAJOR,
//                                            LIBAVFILTER_VERSION_MINOR,
//                                            LIBAVFILTER_VERSION_MICRO)
public static final int LIBAVFILTER_BUILD =       LIBAVFILTER_VERSION_INT;

public static native @MemberGetter String LIBAVFILTER_IDENT();
public static final String LIBAVFILTER_IDENT = LIBAVFILTER_IDENT();

// #endif /* AVFILTER_VERSION_H */


}
