/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.task.TaskQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class FilterDto {
    protected String id;
    protected String resourceType;
    protected String name;
    protected String owner;
    protected AbstractQueryDto<?> query;
    protected Map<String, Object> properties;
    protected Long itemCount;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public AbstractQueryDto<?> getQuery() {
        return this.query;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="resourceType", defaultImpl=TaskQueryDto.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TaskQueryDto.class, name="Task")})
    public void setQuery(AbstractQueryDto<?> query) {
        this.query = query;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(Long itemCount) {
        this.itemCount = itemCount;
    }

    public static FilterDto fromFilter(Filter filter) {
        FilterDto dto = new FilterDto();
        dto.id = filter.getId();
        dto.resourceType = filter.getResourceType();
        dto.name = filter.getName();
        dto.owner = filter.getOwner();
        if ("Task".equals(filter.getResourceType())) {
            dto.query = TaskQueryDto.fromQuery(filter.getQuery());
        }
        dto.properties = filter.getProperties();
        return dto;
    }

    public void updateFilter(Filter filter, ProcessEngine engine) {
        if (this.getResourceType() != null && !this.getResourceType().equals(filter.getResourceType())) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Unable to update filter from resource type '" + filter.getResourceType() + "' to '" + this.getResourceType() + "'");
        }
        filter.setName(this.getName());
        filter.setOwner(this.getOwner());
        filter.setQuery(this.query.toQuery(engine));
        filter.setProperties(this.getProperties());
    }
}

