/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.migration.MigrationInstructionsBuilder;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanExecutionBuilder;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.rest.MigrationRestService;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.migration.MigrationExecutionDto;
import org.camunda.bpm.engine.rest.dto.migration.MigrationPlanDto;
import org.camunda.bpm.engine.rest.dto.migration.MigrationPlanGenerationDto;
import org.camunda.bpm.engine.rest.dto.migration.MigrationPlanReportDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;

public class MigrationRestServiceImpl
extends AbstractRestProcessEngineAware
implements MigrationRestService {
    public MigrationRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public MigrationPlanDto generateMigrationPlan(MigrationPlanGenerationDto generationDto) {
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        String sourceProcessDefinitionId = generationDto.getSourceProcessDefinitionId();
        String targetProcessDefinitionId = generationDto.getTargetProcessDefinitionId();
        try {
            MigrationInstructionsBuilder instructionsBuilder = runtimeService.createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities();
            if (generationDto.isUpdateEventTriggers()) {
                instructionsBuilder = instructionsBuilder.updateEventTriggers();
            }
            MigrationPlan migrationPlan = instructionsBuilder.build();
            return MigrationPlanDto.from(migrationPlan);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
    }

    @Override
    public MigrationPlanReportDto validateMigrationPlan(MigrationPlanDto migrationPlanDto) {
        try {
            this.createMigrationPlan(migrationPlanDto);
            return MigrationPlanReportDto.emptyReport();
        }
        catch (MigrationPlanValidationException e) {
            return MigrationPlanReportDto.form(e.getValidationReport());
        }
    }

    @Override
    public void executeMigrationPlan(MigrationExecutionDto migrationExecution) {
        this.createMigrationPlanExecutionBuilder(migrationExecution).execute();
    }

    @Override
    public BatchDto executeMigrationPlanAsync(MigrationExecutionDto migrationExecution) {
        Batch batch = this.createMigrationPlanExecutionBuilder(migrationExecution).executeAsync();
        return BatchDto.fromBatch(batch);
    }

    protected MigrationPlanExecutionBuilder createMigrationPlanExecutionBuilder(MigrationExecutionDto migrationExecution) {
        MigrationPlan migrationPlan = this.createMigrationPlan(migrationExecution.getMigrationPlan());
        List<String> processInstanceIds = migrationExecution.getProcessInstanceIds();
        MigrationPlanExecutionBuilder executionBuilder = this.processEngine.getRuntimeService().newMigration(migrationPlan).processInstanceIds(processInstanceIds);
        ProcessInstanceQueryDto processInstanceQueryDto = migrationExecution.getProcessInstanceQuery();
        if (processInstanceQueryDto != null) {
            ProcessInstanceQuery processInstanceQuery = (ProcessInstanceQuery)processInstanceQueryDto.toQuery(this.getProcessEngine());
            executionBuilder.processInstanceQuery(processInstanceQuery);
        }
        if (migrationExecution.isSkipCustomListeners()) {
            executionBuilder.skipCustomListeners();
        }
        if (migrationExecution.isSkipIoMappings()) {
            executionBuilder.skipIoMappings();
        }
        return executionBuilder;
    }

    protected MigrationPlan createMigrationPlan(MigrationPlanDto migrationPlanDto) {
        try {
            return MigrationPlanDto.toMigrationPlan(this.processEngine, migrationPlanDto);
        }
        catch (MigrationPlanValidationException e) {
            throw e;
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
    }
}

