/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.batch.HistoricBatchDto;
import org.camunda.bpm.engine.rest.dto.history.batch.HistoricBatchQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricBatchRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricBatchResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricBatchResourceImpl;

public class HistoricBatchRestServiceImpl
implements HistoricBatchRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricBatchRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricBatchResource getHistoricBatch(String batchId) {
        return new HistoricBatchResourceImpl(this.processEngine, batchId);
    }

    @Override
    public List<HistoricBatchDto> getHistoricBatches(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricBatchQueryDto queryDto = new HistoricBatchQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricBatchQuery query = (HistoricBatchQuery)queryDto.toQuery(this.processEngine);
        List<HistoricBatch> matchingBatches = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricBatchDto> batchResults = new ArrayList<HistoricBatchDto>();
        for (HistoricBatch matchingBatch : matchingBatches) {
            batchResults.add(HistoricBatchDto.fromBatch(matchingBatch));
        }
        return batchResults;
    }

    @Override
    public CountResultDto getHistoricBatchesCount(UriInfo uriInfo) {
        HistoricBatchQueryDto queryDto = new HistoricBatchQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricBatchQuery query = (HistoricBatchQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        return new CountResultDto(count);
    }

    protected List<HistoricBatch> executePaginatedQuery(HistoricBatchQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }
}

