/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.externaltask.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.externaltask.CompleteExternalTaskDto;
import org.camunda.bpm.engine.rest.dto.externaltask.ExternalTaskBpmnError;
import org.camunda.bpm.engine.rest.dto.externaltask.ExternalTaskDto;
import org.camunda.bpm.engine.rest.dto.externaltask.ExternalTaskFailureDto;
import org.camunda.bpm.engine.rest.dto.runtime.PriorityDto;
import org.camunda.bpm.engine.rest.dto.runtime.RetriesDto;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.externaltask.ExternalTaskResource;
import org.camunda.bpm.engine.variable.VariableMap;

public class ExternalTaskResourceImpl
implements ExternalTaskResource {
    protected ProcessEngine engine;
    protected String externalTaskId;
    protected ObjectMapper objectMapper;

    public ExternalTaskResourceImpl(ProcessEngine engine, String externalTaskId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.externalTaskId = externalTaskId;
        this.objectMapper = objectMapper;
    }

    @Override
    public ExternalTaskDto getExternalTask() {
        ExternalTask task = (ExternalTask)this.engine.getExternalTaskService().createExternalTaskQuery().externalTaskId(this.externalTaskId).singleResult();
        if (task == null) {
            throw new RestException(Response.Status.NOT_FOUND, "External task with id " + this.externalTaskId + " does not exist");
        }
        return ExternalTaskDto.fromExternalTask(task);
    }

    @Override
    public String getErrorDetails() {
        ExternalTaskService externalTaskService = this.engine.getExternalTaskService();
        try {
            return externalTaskService.getExternalTaskErrorDetails(this.externalTaskId);
        }
        catch (NotFoundException e) {
            throw new RestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "External task with id " + this.externalTaskId + " does not exist");
        }
    }

    @Override
    public void setRetries(RetriesDto dto) {
        ExternalTaskService externalTaskService = this.engine.getExternalTaskService();
        try {
            externalTaskService.setRetries(this.externalTaskId, dto.getRetries());
        }
        catch (NotFoundException e) {
            throw new RestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "External task with id " + this.externalTaskId + " does not exist");
        }
    }

    @Override
    public void setPriority(PriorityDto dto) {
        ExternalTaskService externalTaskService = this.engine.getExternalTaskService();
        try {
            externalTaskService.setPriority(this.externalTaskId, dto.getPriority().longValue());
        }
        catch (NotFoundException e) {
            throw new RestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "External task with id " + this.externalTaskId + " does not exist");
        }
    }

    @Override
    public void complete(CompleteExternalTaskDto dto) {
        ExternalTaskService externalTaskService = this.engine.getExternalTaskService();
        VariableMap variables = VariableValueDto.toMap(dto.getVariables(), this.engine, this.objectMapper);
        try {
            externalTaskService.complete(this.externalTaskId, dto.getWorkerId(), (Map)variables);
        }
        catch (NotFoundException e) {
            throw new RestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "External task with id " + this.externalTaskId + " does not exist");
        }
        catch (BadUserRequestException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
    }

    @Override
    public void handleFailure(ExternalTaskFailureDto dto) {
        ExternalTaskService externalTaskService = this.engine.getExternalTaskService();
        try {
            externalTaskService.handleFailure(this.externalTaskId, dto.getWorkerId(), dto.getErrorMessage(), dto.getErrorDetails(), dto.getRetries(), dto.getRetryTimeout());
        }
        catch (NotFoundException e) {
            throw new RestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "External task with id " + this.externalTaskId + " does not exist");
        }
        catch (BadUserRequestException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
    }

    @Override
    public void handleBpmnError(ExternalTaskBpmnError dto) {
        ExternalTaskService externalTaskService = this.engine.getExternalTaskService();
        try {
            externalTaskService.handleBpmnError(this.externalTaskId, dto.getWorkerId(), dto.getErrorCode());
        }
        catch (NotFoundException e) {
            throw new RestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "External task with id " + this.externalTaskId + " does not exist");
        }
        catch (BadUserRequestException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
    }

    @Override
    public void unlock() {
        ExternalTaskService externalTaskService = this.engine.getExternalTaskService();
        try {
            externalTaskService.unlock(this.externalTaskId);
        }
        catch (NotFoundException e) {
            throw new RestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "External task with id " + this.externalTaskId + " does not exist");
        }
    }
}

