/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.history.impl;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.rest.dto.history.HistoricJobLogDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.history.HistoricJobLogResource;

public class HistoricJobLogResourceImpl
implements HistoricJobLogResource {
    protected String id;
    protected ProcessEngine engine;

    public HistoricJobLogResourceImpl(String id, ProcessEngine engine) {
        this.id = id;
        this.engine = engine;
    }

    @Override
    public HistoricJobLogDto getHistoricJobLog() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricJobLog historicJobLog = (HistoricJobLog)historyService.createHistoricJobLogQuery().logId(this.id).singleResult();
        if (historicJobLog == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic job log with id " + this.id + " does not exist");
        }
        return HistoricJobLogDto.fromHistoricJobLog(historicJobLog);
    }

    @Override
    public String getStacktrace() {
        try {
            HistoryService historyService = this.engine.getHistoryService();
            String stacktrace = historyService.getHistoricJobLogExceptionStacktrace(this.id);
            return stacktrace;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }
}

