/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.identity.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.rest.dto.ResourceOptionsDto;
import org.camunda.bpm.engine.rest.sub.identity.GroupMembersResource;
import org.camunda.bpm.engine.rest.sub.identity.impl.AbstractIdentityResource;
import org.camunda.bpm.engine.rest.util.PathUtil;

public class GroupMembersResourceImpl
extends AbstractIdentityResource
implements GroupMembersResource {
    public GroupMembersResourceImpl(String processEngineName, String resourceId, String rootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, (Resource)Resources.GROUP_MEMBERSHIP, resourceId, objectMapper);
        this.relativeRootResourcePath = rootResourcePath;
    }

    @Override
    public void createGroupMember(String userId) {
        this.ensureNotReadOnly();
        userId = PathUtil.decodePathParam(userId);
        this.identityService.createMembership(userId, this.resourceId);
    }

    @Override
    public void deleteGroupMember(String userId) {
        this.ensureNotReadOnly();
        userId = PathUtil.decodePathParam(userId);
        this.identityService.deleteMembership(userId, this.resourceId);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        URI uri = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/group").path(this.resourceId).path("/members").build(new Object[0]);
        dto.addReflexiveLink(uri, "GET", "self");
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(uri, "DELETE", "delete");
        }
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.CREATE)) {
            dto.addReflexiveLink(uri, "PUT", "create");
        }
        return dto;
    }
}

