/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.metrics;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.management.MetricsQuery;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.metrics.MetricsResultDto;
import org.camunda.bpm.engine.rest.sub.metrics.MetricsResource;

public class MetricsResourceImpl
implements MetricsResource {
    protected String metricsName;
    protected ProcessEngine processEngine;
    protected ObjectMapper objectMapper;

    public MetricsResourceImpl(String metricsName, ProcessEngine processEngine, ObjectMapper objectMapper) {
        this.metricsName = metricsName;
        this.processEngine = processEngine;
        this.objectMapper = objectMapper;
    }

    @Override
    public MetricsResultDto sum(UriInfo uriInfo) {
        MetricsQuery query = this.processEngine.getManagementService().createMetricsQuery().name(this.metricsName);
        this.applyQueryParams(query, uriInfo);
        return new MetricsResultDto(query.sum());
    }

    protected void applyQueryParams(MetricsQuery query, UriInfo uriInfo) {
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        DateConverter dateConverter = new DateConverter();
        dateConverter.setObjectMapper(this.objectMapper);
        if (queryParameters.getFirst((Object)"startDate") != null) {
            Date startDate = dateConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)"startDate"));
            query.startDate(startDate);
        }
        if (queryParameters.getFirst((Object)"endDate") != null) {
            Date endDate = dateConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)"endDate"));
            query.endDate(endDate);
        }
    }
}

