/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

@Mojo(name="unzipinc", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class NativeUnZipIncMojo
extends AbstractNativeMojo {
    @Parameter(defaultValue="${project.build.directory}/native/markers", required=true)
    private File dependencyIncZipMarkerDirectory;
    @Component
    private ArchiverManager archiverManager;

    public void execute() throws MojoExecutionException {
        if (this.unpackIncZipDepenedencies()) {
            Boolean bl = this.getPluginContext().put("IncZipFound", Boolean.TRUE);
        }
    }

    private boolean unpackIncZipDepenedencies() throws MojoExecutionException {
        List<Artifact> files = this.getIncZipDependencies();
        Iterator<Artifact> iter = files.iterator();
        for (int i = 0; i < files.size(); ++i) {
            Artifact artifact = iter.next();
            File incZipFile = artifact.getFile();
            File marker = new File(this.dependencyIncZipMarkerDirectory, artifact.getGroupId() + "." + artifact.getArtifactId());
            if (marker.exists() && marker.lastModified() >= incZipFile.lastModified()) continue;
            try {
                this.unpackZipFile(incZipFile);
                marker.delete();
                if (!this.dependencyIncZipMarkerDirectory.exists()) {
                    this.dependencyIncZipMarkerDirectory.mkdirs();
                }
                marker.createNewFile();
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        return files.size() != 0;
    }

    protected void unpackZipFile(File zipFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Unpacking: " + zipFile));
        try {
            if (!this.dependencyIncludeDirectory.exists()) {
                this.dependencyIncludeDirectory.mkdirs();
            }
            UnArchiver archiver = this.archiverManager.getUnArchiver("zip");
            archiver.setOverwrite(true);
            archiver.setDestDirectory(this.dependencyIncludeDirectory);
            archiver.setSourceFile(zipFile);
            archiver.extract();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private List<Artifact> getIncZipDependencies() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        Set artifacts = this.project.getDependencyArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!"inczip".equals(artifact.getType())) continue;
                list.add(artifact);
            }
        }
        return list;
    }
}

