/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.db;

import java.sql.Connection;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.DbSchemaManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnDbSchemaManager
implements DbSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnDbSchemaManager.class);
    public static final String LIQUIBASE_CHANGELOG = "org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog.xml";

    public void initSchema() {
        this.initSchema(CommandContextUtil.getCmmnEngineConfiguration());
    }

    public void initSchema(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.initSchema(cmmnEngineConfiguration, cmmnEngineConfiguration.getDatabaseSchemaUpdate());
    }

    public void initSchema(CmmnEngineConfiguration cmmnEngineConfiguration, String databaseSchemaUpdate) {
        try {
            if ("create-drop".equals(databaseSchemaUpdate)) {
                this.dbSchemaCreate();
            } else if ("drop-create".equals(databaseSchemaUpdate)) {
                this.dbSchemaDrop();
                this.dbSchemaCreate();
            } else if ("true".equals(databaseSchemaUpdate)) {
                this.dbSchemaUpdate();
            } else if ("false".equals(databaseSchemaUpdate)) {
                Liquibase liquibase = this.createLiquibaseInstance(cmmnEngineConfiguration);
                liquibase.validate();
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error initialising cmmn data model", (Throwable)e);
        }
    }

    protected Liquibase createLiquibaseInstance(CmmnEngineConfiguration cmmnEngineConfiguration) throws SQLException, DatabaseException, LiquibaseException {
        String databaseCatalog;
        Connection jdbcConnection = null;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        jdbcConnection = commandContext == null ? cmmnEngineConfiguration.getDataSource().getConnection() : CommandContextUtil.getDbSqlSession(commandContext).getSqlSession().getConnection();
        if (!jdbcConnection.getAutoCommit()) {
            jdbcConnection.commit();
        }
        JdbcConnection connection = new JdbcConnection(jdbcConnection);
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
        database.setDatabaseChangeLogTableName("ACT_CMMN_" + database.getDatabaseChangeLogTableName());
        database.setDatabaseChangeLogLockTableName("ACT_CMMN_" + database.getDatabaseChangeLogLockTableName());
        String databaseSchema = cmmnEngineConfiguration.getDatabaseSchema();
        if (StringUtils.isNotEmpty((CharSequence)databaseSchema)) {
            database.setDefaultSchemaName(databaseSchema);
            database.setLiquibaseSchemaName(databaseSchema);
        }
        if (StringUtils.isNotEmpty((CharSequence)(databaseCatalog = cmmnEngineConfiguration.getDatabaseCatalog()))) {
            database.setDefaultCatalogName(databaseCatalog);
            database.setLiquibaseCatalogName(databaseCatalog);
        }
        return this.createLiquibaseInstance(database);
    }

    public Liquibase createLiquibaseInstance(Database database) throws LiquibaseException {
        return new Liquibase(LIQUIBASE_CHANGELOG, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
    }

    public void dbSchemaCreate() {
        try {
            this.getCommonDbSchemaManager().dbSchemaCreate();
            this.getIdentityLinkDbSchemaManager().dbSchemaCreate();
            this.getTaskDbSchemaManager().dbSchemaCreate();
            this.getVariableDbSchemaManager().dbSchemaCreate();
            this.getJobDbSchemaManager().dbSchemaCreate();
            Liquibase liquibase = this.createLiquibaseInstance(CommandContextUtil.getCmmnEngineConfiguration());
            liquibase.update("cmmn");
        }
        catch (Exception e) {
            throw new FlowableException("Error creating CMMN engine tables", (Throwable)e);
        }
    }

    public void dbSchemaDrop() {
        try {
            Liquibase liquibase = this.createLiquibaseInstance(CommandContextUtil.getCmmnEngineConfiguration());
            liquibase.dropAll();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping CMMN engine tables", (Throwable)e);
        }
        try {
            this.getJobDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping job tables", (Throwable)e);
        }
        try {
            this.getVariableDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping variable tables", (Throwable)e);
        }
        try {
            this.getTaskDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping task tables", (Throwable)e);
        }
        try {
            this.getIdentityLinkDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping identity link tables", (Throwable)e);
        }
        try {
            this.getCommonDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping common tables", (Throwable)e);
        }
    }

    public String dbSchemaUpdate() {
        try {
            this.getCommonDbSchemaManager().dbSchemaUpdate();
            if (CommandContextUtil.getCmmnEngineConfiguration().isExecuteServiceDbSchemaManagers()) {
                this.getIdentityLinkDbSchemaManager().dbSchemaUpdate();
                this.getTaskDbSchemaManager().dbSchemaUpdate();
                this.getVariableDbSchemaManager().dbSchemaUpdate();
                this.getJobDbSchemaManager().dbSchemaUpdate();
            }
            Liquibase liquibase = this.createLiquibaseInstance(CommandContextUtil.getCmmnEngineConfiguration());
            liquibase.update("cmmn");
        }
        catch (Exception e) {
            throw new FlowableException("Error updating CMMN engine tables", (Throwable)e);
        }
        return null;
    }

    protected DbSchemaManager getCommonDbSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getCommonDbSchemaManager();
    }

    protected DbSchemaManager getIdentityLinkDbSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getIdentityLinkDbSchemaManager();
    }

    protected DbSchemaManager getVariableDbSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getVariableDbSchemaManager();
    }

    protected DbSchemaManager getTaskDbSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getTaskDbSchemaManager();
    }

    protected DbSchemaManager getJobDbSchemaManager() {
        return CommandContextUtil.getCmmnEngineConfiguration().getJobDbSchemaManager();
    }
}

