/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.AbstractCmmnEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CaseInstanceDataManager;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.job.api.Job;
import org.flowable.job.service.impl.DeadLetterJobQueryImpl;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.SuspendedJobQueryImpl;
import org.flowable.job.service.impl.TimerJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobEntityManager;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityManager;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;

public class CaseInstanceEntityManagerImpl
extends AbstractCmmnEntityManager<CaseInstanceEntity>
implements CaseInstanceEntityManager {
    protected CaseInstanceDataManager caseInstanceDataManager;

    public CaseInstanceEntityManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration, CaseInstanceDataManager caseInstanceDataManager) {
        super(cmmnEngineConfiguration);
        this.caseInstanceDataManager = caseInstanceDataManager;
    }

    @Override
    protected DataManager<CaseInstanceEntity> getDataManager() {
        return this.caseInstanceDataManager;
    }

    @Override
    public CaseInstanceQuery createCaseInstanceQuery() {
        return new CaseInstanceQueryImpl(this.cmmnEngineConfiguration.getCommandExecutor());
    }

    @Override
    public List<CaseInstanceEntity> findCaseInstancesByCaseDefinitionId(String caseDefinitionId) {
        return this.caseInstanceDataManager.findCaseInstancesByCaseDefinitionId(caseDefinitionId);
    }

    @Override
    public List<CaseInstance> findByCriteria(CaseInstanceQuery query) {
        return this.caseInstanceDataManager.findByCriteria((CaseInstanceQueryImpl)query);
    }

    @Override
    public List<CaseInstance> findWithVariablesByCriteria(CaseInstanceQuery query) {
        return this.caseInstanceDataManager.findWithVariablesByCriteria((CaseInstanceQueryImpl)query);
    }

    @Override
    public long countByCriteria(CaseInstanceQuery query) {
        return this.caseInstanceDataManager.countByCriteria((CaseInstanceQueryImpl)query);
    }

    @Override
    public void delete(String caseInstanceId, boolean cascade, String deleteReason) {
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)this.caseInstanceDataManager.findById(caseInstanceId);
        this.getVariableInstanceEntityManager().deleteByScopeIdAndScopeType(caseInstanceId, "cmmn");
        this.getIdentityLinkEntityManager().deleteIdentityLinksByScopeIdAndScopeType(caseInstanceId, "cmmn");
        TaskEntityManager taskEntityManager = this.getTaskEntityManager();
        List taskEntities = taskEntityManager.findTasksByScopeIdAndScopeType(caseInstanceId, "cmmn");
        for (TaskEntity taskEntity : taskEntities) {
            TaskHelper.deleteTask(taskEntity, deleteReason, cascade, true);
        }
        this.getSentryPartInstanceEntityManager().deleteByCaseInstanceId(caseInstanceId);
        this.getMilestoneInstanceEntityManager().deleteByCaseInstanceId(caseInstanceId);
        PlanItemInstanceEntityManager planItemInstanceEntityManager = this.getPlanItemInstanceEntityManager();
        ArrayList<PlanItemInstanceEntity> stagePlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
        this.collectStagePlanItemInstances(caseInstanceEntity, stagePlanItemInstances);
        for (int i = stagePlanItemInstances.size() - 1; i >= 0; --i) {
            planItemInstanceEntityManager.deleteByStageInstanceId(stagePlanItemInstances.get(i).getId());
        }
        planItemInstanceEntityManager.deleteByCaseInstanceId(caseInstanceId);
        JobEntityManager jobEntityManager = this.cmmnEngineConfiguration.getJobServiceConfiguration().getJobEntityManager();
        List jobs = jobEntityManager.findJobsByQueryCriteria(new JobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job job : jobs) {
            jobEntityManager.delete(job.getId());
        }
        TimerJobEntityManager timerJobEntityManager = this.cmmnEngineConfiguration.getJobServiceConfiguration().getTimerJobEntityManager();
        List timerJobs = timerJobEntityManager.findJobsByQueryCriteria(new TimerJobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job timerJob : timerJobs) {
            timerJobEntityManager.delete(timerJob.getId());
        }
        SuspendedJobEntityManager suspendedJobEntityManager = this.cmmnEngineConfiguration.getJobServiceConfiguration().getSuspendedJobEntityManager();
        List suspendedJobs = suspendedJobEntityManager.findJobsByQueryCriteria(new SuspendedJobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job suspendedJob : suspendedJobs) {
            suspendedJobEntityManager.delete(suspendedJob.getId());
        }
        DeadLetterJobEntityManager deadLetterJobEntityManager = this.cmmnEngineConfiguration.getJobServiceConfiguration().getDeadLetterJobEntityManager();
        List deadLetterJobs = deadLetterJobEntityManager.findJobsByQueryCriteria(new DeadLetterJobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job deadLetterJob : deadLetterJobs) {
            deadLetterJobEntityManager.delete(deadLetterJob.getId());
        }
        this.delete(caseInstanceEntity);
    }

    protected void collectStagePlanItemInstances(PlanItemInstanceContainer planItemInstanceContainer, ArrayList<PlanItemInstanceEntity> stagePlanItemInstanceEntities) {
        for (PlanItemInstanceEntity planItemInstanceEntity : planItemInstanceContainer.getChildPlanItemInstances()) {
            if (!planItemInstanceEntity.isStage()) continue;
            stagePlanItemInstanceEntities.add(planItemInstanceEntity);
            this.collectStagePlanItemInstances(planItemInstanceEntity, stagePlanItemInstanceEntities);
        }
    }

    @Override
    public void updateLockTime(String caseInstanceId) {
        Date expirationTime = this.getCmmnEngineConfiguration().getClock().getCurrentTime();
        int lockMillis = this.getCmmnEngineConfiguration().getAsyncExecutor().getAsyncJobLockTimeInMillis();
        GregorianCalendar lockCal = new GregorianCalendar();
        lockCal.setTime(expirationTime);
        lockCal.add(14, lockMillis);
        Date lockDate = lockCal.getTime();
        this.caseInstanceDataManager.updateLockTime(caseInstanceId, lockDate, expirationTime);
    }

    @Override
    public void clearLockTime(String caseInstanceId) {
        this.caseInstanceDataManager.clearLockTime(caseInstanceId);
    }
}

