/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaData;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.CompilationContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HotSpotGraalServices {
    private static final Method metaDataImplicitExceptionBytes;
    private static final Method runtimeExitHotSpot;
    private static final Method scopeOpenLocalScope;
    private static final Method scopeEnterGlobalScope;
    private static final Constructor<HotSpotSpeculationLog> hotSpotSpeculationLogConstructor;

    public static byte[] getImplicitExceptionBytes(HotSpotMetaData metaData) {
        if (metaDataImplicitExceptionBytes == null) {
            return null;
        }
        try {
            return (byte[])metaDataImplicitExceptionBytes.invoke((Object)metaData, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static CompilationContext enterGlobalCompilationContext() {
        if (scopeEnterGlobalScope != null) {
            try {
                AutoCloseable impl = (AutoCloseable)scopeEnterGlobalScope.invoke(null, new Object[0]);
                return impl == null ? null : new CompilationContext(impl);
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
        return null;
    }

    public static CompilationContext openLocalCompilationContext(Object description) {
        if (scopeOpenLocalScope != null) {
            try {
                AutoCloseable impl = (AutoCloseable)scopeOpenLocalScope.invoke(null, Objects.requireNonNull(description));
                return impl == null ? null : new CompilationContext(impl);
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
        return null;
    }

    public static void exit(int status, HotSpotJVMCIRuntime runtime) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            try {
                runtimeExitHotSpot.invoke((Object)runtime, status);
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        } else {
            System.exit(status);
        }
    }

    public static SpeculationLog newHotSpotSpeculationLog(long cachedFailedSpeculationsAddress) {
        if (hotSpotSpeculationLogConstructor != null) {
            try {
                return (SpeculationLog)hotSpotSpeculationLogConstructor.newInstance(cachedFailedSpeculationsAddress);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new InternalError(e);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    static {
        Constructor constructor;
        Method openLocalScope;
        Method enterGlobalScope;
        Method exitHotSpot;
        Method implicitExceptionBytes;
        block2: {
            implicitExceptionBytes = null;
            exitHotSpot = null;
            enterGlobalScope = null;
            openLocalScope = null;
            constructor = null;
            boolean firstFound = false;
            try {
                Class<?> scopeClass = Class.forName("jdk.vm.ci.hotspot.HotSpotObjectConstantScope");
                enterGlobalScope = scopeClass.getDeclaredMethod("enterGlobalScope", new Class[0]);
                firstFound = true;
                openLocalScope = scopeClass.getDeclaredMethod("openLocalScope", Object.class);
                implicitExceptionBytes = HotSpotMetaData.class.getDeclaredMethod("implicitExceptionBytes", new Class[0]);
                exitHotSpot = HotSpotJVMCIRuntime.class.getDeclaredMethod("exitHotSpot", Integer.TYPE);
                constructor = HotSpotSpeculationLog.class.getDeclaredConstructor(Long.TYPE);
            }
            catch (Exception e) {
                if (!firstFound) break block2;
                throw new InternalError("some JVMCI features are unavailable", e);
            }
        }
        metaDataImplicitExceptionBytes = implicitExceptionBytes;
        runtimeExitHotSpot = exitHotSpot;
        scopeEnterGlobalScope = enterGlobalScope;
        scopeOpenLocalScope = openLocalScope;
        hotSpotSpeculationLogConstructor = constructor;
    }
}

