/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.reflect.Method;
import jdk.vm.ci.hotspot.HotSpotJVMCICompilerFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalCompilerFactory;
import org.graalvm.compiler.hotspot.IsGraalPredicateBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class IsGraalPredicate
extends IsGraalPredicateBase {
    private final Module jvmciModule = HotSpotJVMCICompilerFactory.class.getModule();
    private final Module graalModule = HotSpotGraalCompilerFactory.class.getModule();
    private Module compilerConfigurationModule;
    static final Method runtimeExcludeFromJVMCICompilation;

    IsGraalPredicate() {
    }

    @Override
    void onCompilerConfigurationFactorySelection(HotSpotJVMCIRuntime runtime, CompilerConfigurationFactory factory) {
        this.compilerConfigurationModule = factory.getClass().getModule();
        if (runtimeExcludeFromJVMCICompilation != null) {
            try {
                runtimeExcludeFromJVMCICompilation.invoke((Object)HotSpotJVMCIRuntime.runtime(), new Object[]{new Module[]{this.jvmciModule, this.graalModule, this.compilerConfigurationModule}});
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
    }

    @Override
    boolean apply(Class<?> declaringClass) {
        if (runtimeExcludeFromJVMCICompilation != null) {
            throw GraalError.shouldNotReachHere();
        }
        Module module = declaringClass.getModule();
        return this.jvmciModule == module || this.graalModule == module || this.compilerConfigurationModule == module;
    }

    @Override
    HotSpotJVMCICompilerFactory.CompilationLevelAdjustment getCompilationLevelAdjustment() {
        if (runtimeExcludeFromJVMCICompilation != null) {
            return HotSpotJVMCICompilerFactory.CompilationLevelAdjustment.None;
        }
        return super.getCompilationLevelAdjustment();
    }

    static {
        Method excludeFromJVMCICompilation = null;
        try {
            excludeFromJVMCICompilation = HotSpotJVMCIRuntime.class.getDeclaredMethod("excludeFromJVMCICompilation", Module[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        runtimeExcludeFromJVMCICompilation = excludeFromJVMCICompilation;
    }
}

