/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.jniutils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Platforms(value={Platform.HOSTED_ONLY.class})
final class JNIExceptionWrapperEntryPoints {
    JNIExceptionWrapperEntryPoints() {
    }

    static Throwable updateStackTrace(Throwable target, String[] rawElements) {
        StackTraceElement[] elements = new StackTraceElement[rawElements.length];
        for (int i = 0; i < rawElements.length; ++i) {
            String[] parts = rawElements[i].split("\\|");
            String className = parts[0];
            String methodName = parts[1];
            String fileName = parts[2];
            int lineNumber = Integer.parseInt(parts[3]);
            elements[i] = new StackTraceElement(className, methodName, fileName.isEmpty() ? null : fileName, lineNumber);
        }
        target.setStackTrace(elements);
        return target;
    }

    static Throwable createException(String message) {
        return new RuntimeException(message);
    }

    static byte[] getStackTrace(Throwable throwable) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(bout);){
            StackTraceElement[] stackTraceElements = throwable.getStackTrace();
            out.writeInt(stackTraceElements.length);
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                out.writeUTF(stackTraceElement.getClassName());
                out.writeUTF(stackTraceElement.getMethodName());
                String fileName = stackTraceElement.getFileName();
                out.writeUTF(fileName == null ? "" : fileName);
                out.writeInt(stackTraceElement.getLineNumber());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return bout.toByteArray();
    }

    static String getThrowableMessage(Throwable t) {
        return t.getMessage();
    }

    static String getClassName(Class<?> clz) {
        return clz.getName();
    }
}

