/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.jniutils.HotSpotCalls;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIExceptionWrapper;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.libgraal.jni.annotation.FromLibGraalId;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class FromLibGraalCalls<T extends Enum<T>> {
    private static final Map<String, JNIClass> classes = new ConcurrentHashMap<String, JNIClass>();
    private final EnumMap<T, JNIMethodImpl<T>> methods;
    private final HotSpotCalls hotSpotCalls;
    private volatile JNI.JClass peer;

    protected FromLibGraalCalls(Class<T> idType) {
        this.methods = new EnumMap(idType);
        this.hotSpotCalls = HotSpotCalls.getDefault();
    }

    protected abstract JNI.JClass resolvePeer(JNI.JNIEnv var1);

    public final void callVoid(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethodImpl<T> method = this.getJNIMethod(env, id, Void.TYPE);
        this.hotSpotCalls.callStaticVoid(env, this.peer(env), method, args);
    }

    public final boolean callBoolean(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethodImpl<T> method = this.getJNIMethod(env, id, Boolean.TYPE);
        return this.hotSpotCalls.callStaticBoolean(env, this.peer(env), method, args);
    }

    public final long callLong(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethodImpl<T> method = this.getJNIMethod(env, id, Long.TYPE);
        return this.hotSpotCalls.callStaticLong(env, this.peer(env), method, args);
    }

    public final int callInt(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethodImpl<T> method = this.getJNIMethod(env, id, Integer.TYPE);
        return this.hotSpotCalls.callStaticInt(env, this.peer(env), method, args);
    }

    public final <R extends JNI.JObject> R callJObject(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethodImpl<T> method = this.getJNIMethod(env, id, Object.class);
        return this.hotSpotCalls.callStaticJObject(env, this.peer(env), method, args);
    }

    public static JNI.JClass getJNIClass(JNI.JNIEnv env, Class<?> clazz) {
        if (clazz.isArray()) {
            throw new UnsupportedOperationException("Array classes are not supported");
        }
        return FromLibGraalCalls.getJNIClassImpl((JNI.JNIEnv)env, (String)clazz.getName()).jclass;
    }

    public static JNI.JClass getJNIClass(JNI.JNIEnv env, String className) {
        return FromLibGraalCalls.getJNIClassImpl((JNI.JNIEnv)env, (String)className).jclass;
    }

    private static JNIClass getJNIClassImpl(final JNI.JNIEnv env, String className) {
        try {
            return classes.computeIfAbsent(className, new Function<String, JNIClass>(){

                @Override
                public JNIClass apply(String name) {
                    JNI.JClass clazz;
                    JNI.JObject classLoader = JNIUtil.getJVMCIClassLoader(env);
                    JNI.JClass jClass = clazz = classLoader.isNull() ? JNIUtil.findClass(env, JNIUtil.getBinaryName(name)) : JNIUtil.findClass(env, classLoader, JNIUtil.getBinaryName(name));
                    if (clazz.isNull()) {
                        JNIUtil.ExceptionClear(env);
                        throw new InternalError("Cannot load class: " + name);
                    }
                    return new JNIClass(name, JNIUtil.NewGlobalRef(env, clazz, "Class<" + name + ">"));
                }
            });
        }
        catch (InternalError ie) {
            JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
            throw ie;
        }
    }

    private JNIMethodImpl<T> getJNIMethod(final JNI.JNIEnv env, T hcId, Class<?> expectedReturnType) {
        assert (((FromLibGraalId)hcId).getReturnType() == expectedReturnType || expectedReturnType.isAssignableFrom(((FromLibGraalId)hcId).getReturnType()));
        try {
            return (JNIMethodImpl)this.methods.computeIfAbsent(hcId, new Function<T, JNIMethodImpl<T>>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public JNIMethodImpl<T> apply(T id) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (InternalError ie) {
            JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
            throw ie;
        }
    }

    private JNI.JClass peer(JNI.JNIEnv env) {
        if (this.peer.isNull()) {
            this.peer = this.resolvePeer(env);
        }
        return this.peer;
    }

    static /* synthetic */ JNI.JClass access$000(FromLibGraalCalls x0, JNI.JNIEnv x1) {
        return x0.peer(x1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class JNIMethodImpl<T extends Enum<T>>
    implements HotSpotCalls.JNIMethod {
        final T hcId;
        final JNI.JMethodID jniId;

        JNIMethodImpl(T hcId, JNI.JMethodID jniId) {
            this.hcId = hcId;
            this.jniId = jniId;
        }

        @Override
        public JNI.JMethodID getJMethodID() {
            return this.jniId;
        }

        @Override
        public String getDisplayName() {
            return ((FromLibGraalId)this.hcId).getName();
        }

        public String toString() {
            return this.hcId + "[0x" + Long.toHexString(this.jniId.rawValue()) + ']';
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class JNIClass {
        final String className;
        final JNI.JClass jclass;

        JNIClass(String className, JNI.JClass clazz) {
            this.className = className;
            this.jclass = clazz;
        }
    }
}

