/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.asm.BranchTargetOutOfBoundsException;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDMacroAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;

public class AArch64MacroAssembler
extends AArch64Assembler {
    private final ScratchRegister[] scratchRegister = new ScratchRegister[]{new ScratchRegister(AArch64.rscratch1), new ScratchRegister(AArch64.rscratch2)};
    private int nextFreeScratchRegister = 0;
    private AArch64MemoryEncoding lastImmLoadStoreEncoding;
    private boolean isImmLoadStoreMerged = false;
    public final AArch64ASIMDMacroAssembler neon = new AArch64ASIMDMacroAssembler(this);

    public AArch64MacroAssembler(TargetDescription target) {
        super(target);
    }

    public ScratchRegister getScratchRegister() {
        return this.scratchRegister[this.nextFreeScratchRegister++];
    }

    @Override
    public void bind(Label l) {
        super.bind(l);
        this.lastImmLoadStoreEncoding = null;
    }

    public int getPCRelativeOffset(Label label) {
        assert (label.isBound());
        int offset = label.position() - this.position();
        assert ((offset & 3) == 0) : "unexpected alignment";
        return offset;
    }

    private AArch64Address tryMakeAddress(int bitMemoryTransferSize, Register base, long displacement, Register scratchReg) {
        AArch64Address.AddressingMode mode;
        assert (!base.equals((Object)scratchReg));
        assert (bitMemoryTransferSize == 8 || bitMemoryTransferSize == 16 || bitMemoryTransferSize == 32 || bitMemoryTransferSize == 64 || bitMemoryTransferSize == 128);
        if (displacement == 0L) {
            return AArch64Address.createBaseRegisterOnlyAddress(bitMemoryTransferSize, base);
        }
        boolean canScale = displacement >= 0L && AArch64Address.isOffsetAligned(bitMemoryTransferSize, displacement);
        AArch64Address.AddressingMode addressingMode = mode = canScale ? AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED : AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED;
        if (NumUtil.isInt(displacement) && AArch64Address.isValidImmediateAddress(bitMemoryTransferSize, mode, NumUtil.safeToInt(displacement))) {
            return AArch64Address.createImmediateAddress(bitMemoryTransferSize, mode, base, NumUtil.safeToInt(displacement));
        }
        if (scratchReg.equals((Object)AArch64.zr)) {
            return null;
        }
        this.mov(scratchReg, displacement);
        return AArch64Address.createRegisterOffsetAddress(bitMemoryTransferSize, base, scratchReg, false);
    }

    public AArch64Address tryMakeAddress(int bitMemoryTransferSize, Register base, long displacement) {
        return this.tryMakeAddress(bitMemoryTransferSize, base, displacement, AArch64.zr);
    }

    public AArch64Address makeAddress(int bitMemoryTransferSize, Register base, long displacement, Register scratchReg) {
        AArch64Address address = this.tryMakeAddress(bitMemoryTransferSize, base, displacement, scratchReg);
        GraalError.guarantee(address != null, "Address generation requires scratch register.");
        return address;
    }

    public AArch64Address makeAddress(int bitMemoryTransferSize, Register base, long displacement) {
        return this.makeAddress(bitMemoryTransferSize, base, displacement, AArch64.zr);
    }

    @Override
    public AArch64Address makeAddress(int bitMemoryTransferSize, Register base, int displacement) {
        return this.makeAddress(bitMemoryTransferSize, base, displacement, AArch64.zr);
    }

    public void loadAddress(Register dst, AArch64Address address) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.CPU));
        int size = address.getBitMemoryTransferSize();
        switch (address.getAddressingMode()) {
            case IMMEDIATE_UNSIGNED_SCALED: {
                assert (size != -1);
                int scaledImmediate = address.getImmediateRaw() << AArch64MacroAssembler.getLog2TransferSize(size);
                this.add(64, dst, address.getBase(), scaledImmediate);
                break;
            }
            case IMMEDIATE_SIGNED_UNSCALED: {
                int immediate = address.getImmediateRaw();
                this.add(64, dst, address.getBase(), immediate);
                break;
            }
            case REGISTER_OFFSET: {
                assert (!address.isRegisterOffsetScaled() || size != -1);
                this.add(64, dst, address.getBase(), address.getOffset(), AArch64Assembler.ShiftType.LSL, address.isRegisterOffsetScaled() ? AArch64MacroAssembler.getLog2TransferSize(size) : 0);
                break;
            }
            case EXTENDED_REGISTER_OFFSET: {
                assert (!address.isRegisterOffsetScaled() || size != -1);
                this.add(64, dst, address.getBase(), address.getOffset(), address.getExtendType(), address.isRegisterOffsetScaled() ? AArch64MacroAssembler.getLog2TransferSize(size) : 0);
                break;
            }
            case BASE_REGISTER_ONLY: {
                this.mov(64, dst, address.getBase());
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    public void loadAlignedAddress(int bitMemoryTransferSize, Register dst, Register base, long displacement) {
        GraalError.guarantee(AArch64Address.isOffsetAligned(bitMemoryTransferSize, displacement), "Displacement must be aligned.");
        this.add(64, dst, base, displacement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryMerge(int byteMemoryTransferSize, Register rt, AArch64Address address, boolean isStore, boolean isFP) {
        Register rt2;
        Register rt1;
        int preOffset;
        Register preBase;
        this.isImmLoadStoreMerged = false;
        if (this.lastImmLoadStoreEncoding == null) {
            return false;
        }
        AArch64Address.AddressingMode addressMode = address.getAddressingMode();
        if (addressMode != AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED && addressMode != AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED) {
            return false;
        }
        int lastPosition = this.position() - 4;
        if (lastPosition < 0 || lastPosition != this.lastImmLoadStoreEncoding.position) {
            return false;
        }
        if (isStore != this.lastImmLoadStoreEncoding.isStore || isFP != this.lastImmLoadStoreEncoding.isFP) {
            return false;
        }
        if (byteMemoryTransferSize != this.lastImmLoadStoreEncoding.byteMemoryTransferSize || byteMemoryTransferSize != 4 && byteMemoryTransferSize != 8 && (!isFP || byteMemoryTransferSize != 16)) {
            return false;
        }
        Register curBase = address.getBase();
        if (!curBase.equals((Object)(preBase = this.lastImmLoadStoreEncoding.getBase()))) {
            return false;
        }
        Register curRt = rt;
        Register preRt = this.lastImmLoadStoreEncoding.result;
        if (!isStore && (curRt.equals((Object)preRt) || preRt.equals((Object)curBase))) {
            return false;
        }
        int curOffset = address.getImmediateRaw();
        if (addressMode == AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED) {
            curOffset *= byteMemoryTransferSize;
        }
        if (Math.abs(curOffset - (preOffset = this.lastImmLoadStoreEncoding.getOffset())) != byteMemoryTransferSize) {
            return false;
        }
        int offset = Math.min(curOffset, preOffset);
        int minOffset = -64 * byteMemoryTransferSize;
        int maxOffset = 63 * byteMemoryTransferSize;
        if (offset < minOffset || offset > maxOffset) {
            return false;
        }
        if (this.isFlagSet(AArch64.Flag.AvoidUnalignedAccesses)) {
            if (!curBase.equals((Object)AArch64.sp)) return false;
            long pairMask = byteMemoryTransferSize * 2 - 1;
            if (((long)offset & pairMask) != 0L) {
                return false;
            }
        } else {
            long mask = byteMemoryTransferSize - 1;
            if (((long)curOffset & mask) != 0L || ((long)preOffset & mask) != 0L) {
                return false;
            }
        }
        if (preOffset < curOffset) {
            rt1 = preRt;
            rt2 = curRt;
        } else {
            rt1 = curRt;
            rt2 = preRt;
        }
        int bitMemoryTransferSize = byteMemoryTransferSize * 8;
        AArch64Address pairAddress = AArch64Address.createImmediateAddress(bitMemoryTransferSize, AArch64Address.AddressingMode.IMMEDIATE_PAIR_SIGNED_SCALED, curBase, offset);
        AArch64Assembler.Instruction instruction = isStore ? AArch64Assembler.Instruction.STP : AArch64Assembler.Instruction.LDP;
        this.insertLdpStp(lastPosition, bitMemoryTransferSize, instruction, isFP, rt1, rt2, pairAddress);
        this.lastImmLoadStoreEncoding = null;
        this.isImmLoadStoreMerged = true;
        return true;
    }

    private boolean tryMergeLoadStore(int srcSize, Register rt, AArch64Address address, boolean isStore, boolean isFP) {
        int byteMemoryTransferSize = srcSize / 8;
        if (this.tryMerge(byteMemoryTransferSize, rt, address, isStore, isFP)) {
            return true;
        }
        AArch64Address.AddressingMode addressMode = address.getAddressingMode();
        if (addressMode == AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED || addressMode == AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED) {
            if (addressMode == AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED) {
                long mask = byteMemoryTransferSize - 1;
                int offset = address.getImmediateRaw();
                if (((long)offset & mask) != 0L) {
                    return false;
                }
            }
            this.lastImmLoadStoreEncoding = new AArch64MemoryEncoding(byteMemoryTransferSize, rt, address, isStore, isFP, this.position());
        }
        return false;
    }

    public boolean isImmLoadStoreMerged() {
        return this.isImmLoadStoreMerged;
    }

    public void mov(int size, Register dst, Register src) {
        if (!dst.equals((Object)src)) {
            if (dst.equals((Object)AArch64.sp) || src.equals((Object)AArch64.sp)) {
                this.add(size, dst, src, 0);
            } else {
                this.orr(size, dst, AArch64.zr, src);
            }
        }
    }

    private void mov32(Register dst, int imm, boolean needsImmAnnotation) {
        MovSequenceAnnotation.MovAction[] includeSet = new MovSequenceAnnotation.MovAction[]{MovSequenceAnnotation.MovAction.SKIPPED, MovSequenceAnnotation.MovAction.SKIPPED};
        int pos = this.position();
        int low16 = imm & 0xFFFF;
        int high16 = imm >>> 16 & 0xFFFF;
        if (high16 == 0) {
            this.movz(32, dst, low16, 0);
            includeSet[0] = MovSequenceAnnotation.MovAction.USED;
        } else if (high16 == 65535) {
            this.movn(32, dst, low16 ^ 0xFFFF, 0);
            includeSet[0] = MovSequenceAnnotation.MovAction.NEGATED;
        } else if (low16 == 0) {
            this.movz(32, dst, high16, 16);
            includeSet[1] = MovSequenceAnnotation.MovAction.USED;
        } else if (low16 == 65535) {
            this.movn(32, dst, high16 ^ 0xFFFF, 16);
            includeSet[1] = MovSequenceAnnotation.MovAction.NEGATED;
        } else {
            this.movz(32, dst, low16, 0);
            this.movk(32, dst, high16, 16);
            includeSet[0] = MovSequenceAnnotation.MovAction.USED;
            includeSet[1] = MovSequenceAnnotation.MovAction.USED;
        }
        if (needsImmAnnotation) {
            this.annotateImmediateMovSequence(pos, includeSet);
        }
    }

    private void mov64(Register dst, long imm, boolean needsImmAnnotation) {
        int numMovks;
        int k;
        int i;
        MovSequenceAnnotation.MovAction[] includeSet = new MovSequenceAnnotation.MovAction[]{MovSequenceAnnotation.MovAction.SKIPPED, MovSequenceAnnotation.MovAction.SKIPPED, MovSequenceAnnotation.MovAction.SKIPPED, MovSequenceAnnotation.MovAction.SKIPPED};
        int pos = this.position();
        int[] chunks = new int[4];
        int zeroCount = 0;
        int negCount = 0;
        for (i = 0; i < 4; ++i) {
            int chunk = (int)(imm >>> i * 16 & 0xFFFFL);
            if (chunk == 0) {
                ++zeroCount;
            } else if (chunk == 65535) {
                ++negCount;
            }
            chunks[i] = chunk;
        }
        if (zeroCount == 4) {
            this.movz(64, dst, 0, 0);
            includeSet[0] = MovSequenceAnnotation.MovAction.USED;
        } else if (negCount == 4) {
            this.movn(64, dst, 0, 0);
            includeSet[0] = MovSequenceAnnotation.MovAction.NEGATED;
        } else if (zeroCount == 3) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 0) continue;
                this.movz(64, dst, chunks[i], i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.USED;
                break;
            }
        } else if (negCount == 3) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 65535) continue;
                this.movn(64, dst, chunks[i] ^ 0xFFFF, i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.NEGATED;
                break;
            }
        } else if (zeroCount == 2) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 0) continue;
                this.movz(64, dst, chunks[i], i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.USED;
                break;
            }
            for (k = i + 1; k < 4; ++k) {
                if (chunks[k] == 0) continue;
                this.movk(64, dst, chunks[k], k * 16);
                includeSet[k] = MovSequenceAnnotation.MovAction.USED;
                break;
            }
        } else if (negCount == 2) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 65535) continue;
                this.movn(64, dst, chunks[i] ^ 0xFFFF, i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.NEGATED;
                break;
            }
            for (k = i + 1; k < 4; ++k) {
                if (chunks[k] == 65535) continue;
                this.movk(64, dst, chunks[k], k * 16);
                includeSet[k] = MovSequenceAnnotation.MovAction.USED;
                break;
            }
        } else if (zeroCount == 1) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 0) continue;
                this.movz(64, dst, chunks[i], i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.USED;
                break;
            }
            numMovks = 0;
            for (int k2 = i + 1; k2 < 4; ++k2) {
                if (chunks[k2] == 0) continue;
                this.movk(64, dst, chunks[k2], k2 * 16);
                includeSet[k2] = MovSequenceAnnotation.MovAction.USED;
                ++numMovks;
            }
            assert (numMovks == 2);
        } else if (negCount == 1) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 65535) continue;
                this.movn(64, dst, chunks[i] ^ 0xFFFF, i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.NEGATED;
                break;
            }
            numMovks = 0;
            for (int k3 = i + 1; k3 < 4; ++k3) {
                if (chunks[k3] == 65535) continue;
                this.movk(64, dst, chunks[k3], k3 * 16);
                includeSet[k3] = MovSequenceAnnotation.MovAction.USED;
                ++numMovks;
            }
            assert (numMovks == 2);
        } else {
            this.movz(64, dst, chunks[0], 0);
            this.movk(64, dst, chunks[1], 16);
            this.movk(64, dst, chunks[2], 32);
            this.movk(64, dst, chunks[3], 48);
            includeSet[0] = MovSequenceAnnotation.MovAction.USED;
            includeSet[1] = MovSequenceAnnotation.MovAction.USED;
            includeSet[2] = MovSequenceAnnotation.MovAction.USED;
            includeSet[3] = MovSequenceAnnotation.MovAction.USED;
        }
        if (needsImmAnnotation) {
            this.annotateImmediateMovSequence(pos, includeSet);
        }
    }

    public void mov(Register dst, int imm) {
        this.mov(dst, imm, false);
    }

    public void mov(Register dst, long imm) {
        this.mov(dst, imm, false);
    }

    public void mov(Register dst, int imm, boolean needsImmAnnotation) {
        if (!needsImmAnnotation && imm == 0) {
            this.mov(32, dst, AArch64.zr);
        } else if (!needsImmAnnotation && AArch64MacroAssembler.isLogicalImmediate(32, imm)) {
            this.orr(32, dst, AArch64.zr, imm);
        } else {
            this.mov32(dst, imm, needsImmAnnotation);
        }
    }

    public void mov(Register dst, long imm, boolean needsImmAnnotation) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.CPU));
        if (!needsImmAnnotation && imm == 0L) {
            this.mov(64, dst, AArch64.zr);
        } else if (!needsImmAnnotation && AArch64MacroAssembler.isLogicalImmediate(64, imm)) {
            this.orr(64, dst, AArch64.zr, imm);
        } else {
            this.mov64(dst, imm, needsImmAnnotation);
        }
    }

    public void movNativeAddress(Register dst, long imm) {
        this.movNativeAddress(dst, imm, false);
    }

    public void movNativeAddress(Register dst, long imm, boolean needsImmAnnotation) {
        assert ((imm & 0xFFFF000000000000L) == 0L);
        boolean firstMove = true;
        int pos = this.position();
        for (int offset = 0; offset < 48; offset += 16) {
            int chunk = (int)(imm >> offset) & NumUtil.getNbitNumberInt(16);
            if (firstMove) {
                this.movz(64, dst, chunk, offset);
                firstMove = false;
                continue;
            }
            this.movk(64, dst, chunk, offset);
        }
        if (needsImmAnnotation) {
            MovSequenceAnnotation.MovAction[] includeSet = new MovSequenceAnnotation.MovAction[]{MovSequenceAnnotation.MovAction.USED, MovSequenceAnnotation.MovAction.USED, MovSequenceAnnotation.MovAction.USED};
            this.annotateImmediateMovSequence(pos, includeSet);
        }
        assert (!firstMove);
    }

    public void movNarrowAddress(Register dst, long imm) {
        assert ((imm & 0xFFFFFFFF00000000L) == 0L);
        this.movz(64, dst, (int)(imm >>> 16), 16);
        this.movk(64, dst, (int)(imm & 0xFFFFL), 0);
    }

    @Override
    public void ldrs(int targetSize, int srcSize, Register rt, AArch64Address address) {
        assert (targetSize == 32 || targetSize == 64);
        assert (srcSize <= targetSize);
        if (targetSize == srcSize) {
            this.ldr(srcSize, rt, address);
        } else {
            super.ldrs(targetSize, srcSize, rt, address);
        }
    }

    @Override
    public void ldr(int srcSize, Register rt, AArch64Address address) {
        this.ldr(srcSize, rt, address, true);
    }

    public void ldr(int srcSize, Register rt, AArch64Address address, boolean tryMerge) {
        if (!tryMerge) {
            this.isImmLoadStoreMerged = false;
            this.lastImmLoadStoreEncoding = null;
            super.ldr(srcSize, rt, address);
        } else if (!this.tryMergeLoadStore(srcSize, rt, address, false, false)) {
            super.ldr(srcSize, rt, address);
        }
    }

    @Override
    public void str(int destSize, Register rt, AArch64Address address) {
        this.str(destSize, rt, address, true);
    }

    public void str(int destSize, Register rt, AArch64Address address, boolean tryMerge) {
        if (!tryMerge) {
            this.isImmLoadStoreMerged = false;
            this.lastImmLoadStoreEncoding = null;
            super.str(destSize, rt, address);
        } else if (!this.tryMergeLoadStore(destSize, rt, address, true, false)) {
            super.str(destSize, rt, address);
        }
    }

    @Override
    public void fldr(int size, Register rt, AArch64Address address) {
        this.fldr(size, rt, address, true);
    }

    public void fldr(int size, Register rt, AArch64Address address, boolean tryMerge) {
        if (!tryMerge) {
            this.isImmLoadStoreMerged = false;
            this.lastImmLoadStoreEncoding = null;
            super.fldr(size, rt, address);
        } else if (!this.tryMergeLoadStore(size, rt, address, false, true)) {
            super.fldr(size, rt, address);
        }
    }

    @Override
    public void fstr(int size, Register rt, AArch64Address address) {
        this.fstr(size, rt, address, true);
    }

    public void fstr(int size, Register rt, AArch64Address address, boolean tryMerge) {
        if (!tryMerge) {
            this.isImmLoadStoreMerged = false;
            this.lastImmLoadStoreEncoding = null;
            super.fstr(size, rt, address);
        } else if (!this.tryMergeLoadStore(size, rt, address, true, true)) {
            super.fstr(size, rt, address);
        }
    }

    public void loadExclusive(int size, Register rt, Register rn, boolean acquire) {
        if (acquire) {
            this.ldaxr(size, rt, rn);
        } else {
            this.ldxr(size, rt, rn);
        }
    }

    public void storeExclusive(int size, Register rs, Register rt, Register rn, boolean release) {
        if (release) {
            this.stlxr(size, rs, rt, rn);
        } else {
            this.stxr(size, rs, rt, rn);
        }
    }

    public void cset(int size, Register dst, AArch64Assembler.ConditionFlag condition) {
        super.csinc(size, dst, AArch64.zr, AArch64.zr, condition.negate());
    }

    private static AArch64Assembler.ExtendType getLSLExtendType(int size) {
        assert (size == 32 || size == 64);
        return size == 32 ? AArch64Assembler.ExtendType.UXTW : AArch64Assembler.ExtendType.UXTX;
    }

    public void add(int size, Register dst, Register src1, Register src2) {
        assert (!(dst.equals((Object)AArch64.sp) && src1.equals((Object)AArch64.zr) || dst.equals((Object)AArch64.zr) && src1.equals((Object)AArch64.sp)));
        if (dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp)) {
            super.add(size, dst, src1, src2, AArch64MacroAssembler.getLSLExtendType(size), 0);
        } else {
            super.add(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
        }
    }

    public void adds(int size, Register dst, Register src1, Register src2) {
        if (src1.equals((Object)AArch64.sp)) {
            super.adds(size, dst, src1, src2, AArch64MacroAssembler.getLSLExtendType(size), 0);
        } else {
            super.adds(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
        }
    }

    public void sub(int size, Register dst, Register src1, Register src2) {
        assert (!(dst.equals((Object)AArch64.sp) && src1.equals((Object)AArch64.zr) || dst.equals((Object)AArch64.zr) && src1.equals((Object)AArch64.sp)));
        if (dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp)) {
            super.sub(size, dst, src1, src2, AArch64MacroAssembler.getLSLExtendType(size), 0);
        } else {
            super.sub(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
        }
    }

    public void subs(int size, Register dst, Register src1, Register src2) {
        if (src1.equals((Object)AArch64.sp)) {
            super.subs(size, dst, src1, src2, AArch64MacroAssembler.getLSLExtendType(size), 0);
        } else {
            super.subs(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
        }
    }

    @Override
    public void add(int size, Register dst, Register src1, Register src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        int clampedShift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        if (clampedShift == 0) {
            this.add(size, dst, src1, src2);
        } else {
            super.add(size, dst, src1, src2, shiftType, clampedShift);
        }
    }

    @Override
    public void sub(int size, Register dst, Register src1, Register src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        int clampedShift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        if (clampedShift == 0) {
            this.sub(size, dst, src1, src2);
        } else {
            super.sub(size, dst, src1, src2, shiftType, clampedShift);
        }
    }

    public void neg(int size, Register dst, Register src) {
        this.sub(size, dst, AArch64.zr, src);
    }

    public void neg(int size, Register dst, Register src, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        this.sub(size, dst, AArch64.zr, src, shiftType, shiftAmt);
    }

    public void add(int size, Register dst, Register src, int immediate, Register scratch) {
        assert (!dst.equals((Object)AArch64.zr) && !src.equals((Object)AArch64.zr));
        if (immediate < 0) {
            this.sub(size, dst, src, -immediate, scratch);
        } else if (NumUtil.isUnsignedNbit(24, immediate) || !dst.equals((Object)src)) {
            this.add(size, dst, src, immediate);
        } else {
            assert (scratch != null);
            assert (!scratch.equals((Object)AArch64.zr));
            this.mov(scratch, immediate);
            this.add(size, dst, src, scratch);
        }
    }

    @Override
    public void add(int size, Register dst, Register src, int immediate) {
        assert (!dst.equals((Object)AArch64.zr) && !src.equals((Object)AArch64.zr));
        if (immediate < 0) {
            this.sub(size, dst, src, -immediate);
        } else if (AArch64MacroAssembler.isAddSubtractImmediate(immediate, false)) {
            if (!dst.equals((Object)src) || immediate != 0) {
                super.add(size, dst, src, immediate);
            }
        } else if (NumUtil.isUnsignedNbit(24, immediate)) {
            super.add(size, dst, src, immediate & NumUtil.getNbitNumberInt(12) << 12);
            super.add(size, dst, dst, immediate & NumUtil.getNbitNumberInt(12));
        } else {
            assert (!dst.equals((Object)src));
            this.mov(dst, immediate);
            this.add(size, dst, src, dst);
        }
    }

    public void add(int size, Register dst, Register src, long immediate) {
        if (NumUtil.isInt(immediate)) {
            this.add(size, dst, src, (int)immediate);
        } else {
            assert (!dst.equals((Object)AArch64.zr) && !src.equals((Object)AArch64.zr));
            assert (!dst.equals((Object)src));
            assert (size == 64);
            this.mov(dst, immediate);
            this.add(size, dst, src, dst);
        }
    }

    @Override
    public void adds(int size, Register dst, Register src, int immediate) {
        assert (!dst.equals((Object)AArch64.sp) && !src.equals((Object)AArch64.zr));
        if (immediate < 0) {
            this.subs(size, dst, src, -immediate);
        } else {
            super.adds(size, dst, src, immediate);
        }
    }

    public void sub(int size, Register dst, Register src, int immediate, Register scratch) {
        assert (!dst.equals((Object)AArch64.zr) && !src.equals((Object)AArch64.zr));
        if (immediate < 0) {
            this.add(size, dst, src, -immediate, scratch);
        }
        if (NumUtil.isUnsignedNbit(24, immediate) || !dst.equals((Object)src)) {
            this.sub(size, dst, src, immediate);
        } else {
            assert (scratch != null);
            assert (!scratch.equals((Object)AArch64.zr));
            this.mov(scratch, immediate);
            this.sub(size, dst, src, scratch);
        }
    }

    @Override
    public void sub(int size, Register dst, Register src, int immediate) {
        assert (!dst.equals((Object)AArch64.zr) && !src.equals((Object)AArch64.zr));
        if (immediate < 0) {
            this.add(size, dst, src, -immediate);
        } else if (AArch64MacroAssembler.isAddSubtractImmediate(immediate, false)) {
            if (!dst.equals((Object)src) || immediate != 0) {
                super.sub(size, dst, src, immediate);
            }
        } else if (NumUtil.isUnsignedNbit(24, immediate)) {
            super.sub(size, dst, src, immediate & NumUtil.getNbitNumberInt(12) << 12);
            super.sub(size, dst, dst, immediate & NumUtil.getNbitNumberInt(12));
        } else {
            assert (!dst.equals((Object)src));
            this.mov(dst, immediate);
            this.sub(size, dst, src, dst);
        }
    }

    @Override
    public void subs(int size, Register dst, Register src, int immediate) {
        assert (!dst.equals((Object)AArch64.sp) && !src.equals((Object)AArch64.zr));
        if (immediate < 0) {
            this.adds(size, dst, src, -immediate);
        } else {
            super.subs(size, dst, src, immediate);
        }
    }

    public void mul(int size, Register dst, Register src1, Register src2) {
        super.madd(size, dst, src1, src2, AArch64.zr);
    }

    public void mneg(int size, Register dst, Register src1, Register src2) {
        super.msub(size, dst, src1, src2, AArch64.zr);
    }

    public void umulh(int size, Register dst, Register src1, Register src2) {
        assert (!(dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp) || src2.equals((Object)AArch64.sp)));
        assert (size == 32 || size == 64);
        if (size == 64) {
            super.umulh(dst, src1, src2);
        } else {
            super.umaddl(dst, src1, src2, AArch64.zr);
            this.lsr(64, dst, dst, 32L);
        }
    }

    public void smulh(int size, Register dst, Register src1, Register src2) {
        assert (!(dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp) || src2.equals((Object)AArch64.sp)));
        assert (size == 32 || size == 64);
        if (size == 64) {
            super.smulh(dst, src1, src2);
        } else {
            super.smaddl(dst, src1, src2, AArch64.zr);
            this.lsr(64, dst, dst, 32L);
        }
    }

    public void smull(Register dst, Register src1, Register src2) {
        this.smaddl(dst, src1, src2, AArch64.zr);
    }

    public void smnegl(Register dst, Register src1, Register src2) {
        this.smsubl(dst, src1, src2, AArch64.zr);
    }

    public static boolean isComparisonImmediate(long imm) {
        return AArch64MacroAssembler.isAddSubtractImmediate(imm, true);
    }

    public void lsl(int size, Register dst, Register src, long shiftAmt) {
        int clampedShift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        if (clampedShift != 0 || !dst.equals((Object)src)) {
            int remainingBits = size - clampedShift;
            super.ubfm(size, dst, src, remainingBits, remainingBits - 1);
        }
    }

    public void lsr(int size, Register dst, Register src, long shiftAmt) {
        int clampedShift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        if (clampedShift != 0 || !dst.equals((Object)src)) {
            super.ubfm(size, dst, src, clampedShift, size - 1);
        }
    }

    public void asr(int size, Register dst, Register src, long shiftAmt) {
        int clampedShift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        if (clampedShift != 0 || !dst.equals((Object)src)) {
            super.sbfm(size, dst, src, clampedShift, size - 1);
        }
    }

    public void ror(int size, Register dst, Register src1, Register src2) {
        super.rorv(size, dst, src1, src2);
    }

    public void ror(int size, Register dst, Register src, long shiftAmt) {
        int clampedShift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        if (clampedShift != 0 || !dst.equals((Object)src)) {
            super.extr(size, dst, src, src, clampedShift);
        }
    }

    public static int clampShiftAmt(int size, long shiftAmt) {
        assert (size == 32 || size == 64);
        return (int)(shiftAmt & (long)(size - 1));
    }

    public void and(int size, Register dst, Register src1, Register src2) {
        super.and(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void eor(int size, Register dst, Register src1, Register src2) {
        super.eor(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void orr(int size, Register dst, Register src1, Register src2) {
        super.orr(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void bic(int size, Register dst, Register src1, Register src2) {
        super.bic(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void bic(int size, Register dst, Register src, long imm) {
        super.and(size, dst, src, imm ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void eon(int size, Register dst, Register src1, Register src2) {
        super.eon(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void orn(int size, Register dst, Register src1, Register src2) {
        super.orn(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void not(int size, Register dst, Register src) {
        super.orn(size, dst, AArch64.zr, src, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void bics(int size, Register dst, Register src1, Register src2) {
        super.bics(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void sxt(int destSize, int srcSize, Register dst, Register src) {
        assert (srcSize < destSize && srcSize > 0);
        super.sbfm(destSize, dst, src, 0, srcSize - 1);
    }

    public static boolean isLogicalImmediate(int size, long imm) {
        assert (size == 32 || size == 64);
        boolean is64bit = size == 64;
        long maskedImm = size == 64 ? imm : imm & NumUtil.getNbitNumberLong(32);
        return AArch64Assembler.LogicalBitmaskImmediateEncoding.canEncode(is64bit, maskedImm);
    }

    @Override
    public void fmov(int size, Register dst, Register src) {
        assert (size == 32 || size == 64);
        assert (!dst.getRegisterCategory().equals((Object)AArch64.CPU) || !src.getRegisterCategory().equals((Object)AArch64.CPU)) : "src and dst cannot both be integer registers.";
        if (dst.getRegisterCategory().equals((Object)AArch64.CPU)) {
            this.fmovFpu2Cpu(size, dst, src);
        } else if (src.getRegisterCategory().equals((Object)AArch64.CPU)) {
            this.fmovCpu2Fpu(size, dst, src);
        } else {
            super.fmov(size, dst, src);
        }
    }

    @Override
    public void fmov(int size, Register dst, double imm) {
        assert (size == 32 || size == 64);
        if (imm == 0.0) {
            assert (Double.doubleToRawLongBits(imm) == 0L) : "-0.0 is no valid immediate.";
            this.fmovCpu2Fpu(size, dst, AArch64.zr);
        } else {
            super.fmov(size, dst, imm);
        }
    }

    public static boolean isDoubleImmediate(double imm) {
        return Double.doubleToRawLongBits(imm) == 0L || AArch64Assembler.isDoubleImmediate(imm);
    }

    public static boolean isFloatImmediate(float imm) {
        return Float.floatToRawIntBits(imm) == 0 || AArch64Assembler.isFloatImmediate(imm);
    }

    public void cmp(int size, Register x, Register y) {
        assert (size == 32 || size == 64);
        this.subs(size, AArch64.zr, x, y);
    }

    public void compare(int size, Register x, int y) {
        assert (size == 32 || size == 64);
        assert (AArch64MacroAssembler.isComparisonImmediate(y));
        if (y >= 0) {
            this.subs(size, AArch64.zr, x, y);
        } else {
            this.adds(size, AArch64.zr, x, -y);
        }
    }

    public void cmp(int size, Register x, Register y, AArch64Assembler.ExtendType extendType, int shiftAmt) {
        assert (size == 32 || size == 64);
        this.subs(size, AArch64.zr, x, y, extendType, shiftAmt);
    }

    public void ands(int size, Register dst, Register x, Register y) {
        super.ands(size, dst, x, y, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void tst(int size, Register x, long bimm) {
        this.ands(size, AArch64.zr, x, bimm);
    }

    public void tst(int size, Register x, Register y) {
        this.ands(size, AArch64.zr, x, y);
    }

    public void adr(Register dst, Label label) {
        if (label.isBound()) {
            super.adr(dst, this.getPCRelativeOffset(label));
        } else {
            label.addPatchAt(this.position(), this);
            int extraInformation = dst.encoding;
            this.emitInt(PatchLabelKind.encode(PatchLabelKind.ADR, extraInformation));
        }
    }

    public void cbnz(int size, Register cmp, Label label) {
        assert (size == 32 || size == 64);
        if (label.isBound()) {
            super.cbnz(size, cmp, this.getPCRelativeOffset(label));
        } else {
            label.addPatchAt(this.position(), this);
            int regEncoding = cmp.encoding << 1;
            int sizeEncoding = size == 64 ? 1 : 0;
            int extraInformation = regEncoding | sizeEncoding;
            this.emitInt(PatchLabelKind.encode(PatchLabelKind.COMPARE_REG_BRANCH_NONZERO, extraInformation));
        }
    }

    public void cbz(int size, Register cmp, Label label) {
        assert (size == 32 || size == 64);
        if (label.isBound()) {
            super.cbz(size, cmp, this.getPCRelativeOffset(label));
        } else {
            label.addPatchAt(this.position(), this);
            int regEncoding = cmp.encoding << 1;
            int sizeEncoding = size == 64 ? 1 : 0;
            int extraInformation = regEncoding | sizeEncoding;
            this.emitInt(PatchLabelKind.encode(PatchLabelKind.COMPARE_REG_BRANCH_ZERO, extraInformation));
        }
    }

    public void tbnz(Register cmp, int uimm6, Label label) {
        assert (NumUtil.isUnsignedNbit(6, uimm6));
        if (label.isBound()) {
            super.tbnz(cmp, uimm6, this.getPCRelativeOffset(label));
        } else {
            label.addPatchAt(this.position(), this);
            int regEncoding = cmp.encoding << 6;
            int extraInformation = regEncoding | uimm6;
            this.emitInt(PatchLabelKind.encode(PatchLabelKind.TEST_BIT_BRANCH_NONZERO, extraInformation));
        }
    }

    public void tbz(Register cmp, int uimm6, Label label) {
        assert (NumUtil.isUnsignedNbit(6, uimm6));
        if (label.isBound()) {
            super.tbz(cmp, uimm6, this.getPCRelativeOffset(label));
        } else {
            label.addPatchAt(this.position(), this);
            int regEncoding = cmp.encoding << 6;
            int extraInformation = regEncoding | uimm6;
            this.emitInt(PatchLabelKind.encode(PatchLabelKind.TEST_BIT_BRANCH_ZERO, extraInformation));
        }
    }

    public void branchConditionally(AArch64Assembler.ConditionFlag condition, Label label) {
        if (label.isBound()) {
            super.b(condition, this.getPCRelativeOffset(label));
        } else {
            label.addPatchAt(this.position(), this);
            int extraInformation = condition.encoding;
            this.emitInt(PatchLabelKind.encode(PatchLabelKind.BRANCH_CONDITIONALLY, extraInformation));
        }
    }

    public void branchConditionally(AArch64Assembler.ConditionFlag condition) {
        super.b(condition, 0);
    }

    @Override
    public void jmp(Label label) {
        if (label.isBound()) {
            super.b(this.getPCRelativeOffset(label));
        } else {
            label.addPatchAt(this.position(), this);
            this.emitInt(PatchLabelKind.encode(PatchLabelKind.BRANCH_UNCONDITIONALLY, 0));
        }
    }

    public void jmp(Register dest) {
        super.br(dest);
    }

    public void jmp() {
        super.b();
    }

    public static boolean isBranchImmediateOffset(long imm) {
        return NumUtil.isSignedNbit(28, imm);
    }

    public void hlt(AArch64ExceptionCode exceptionCode) {
        super.hlt(exceptionCode.encoding);
    }

    public void brk(AArch64ExceptionCode exceptionCode) {
        super.brk(exceptionCode.encoding);
    }

    public void pause() {
        super.hint(AArch64Assembler.SystemHint.YIELD);
    }

    public void nop() {
        super.hint(AArch64Assembler.SystemHint.NOP);
    }

    public void csdb() {
        super.hint(AArch64Assembler.SystemHint.CSDB);
    }

    public void fullSystemBarrier() {
        super.dsb(AArch64Assembler.BarrierKind.SYSTEM);
        super.isb();
    }

    @Override
    public void ensureUniquePC() {
        this.nop();
    }

    public void illegal() {
        this.emitInt(-1);
    }

    @Override
    public void align(int modulus) {
        assert (modulus > 0 && (modulus & 3) == 0) : "Modulus has to be a positive multiple of 4.";
        if (this.position() % modulus == 0) {
            return;
        }
        int offset = modulus - this.position() % modulus;
        for (int i = 0; i < offset; i += 4) {
            this.nop();
        }
    }

    @Override
    protected void patchJumpTarget(int patchPos, int jumpTarget) {
        int instruction = this.getInt(patchPos);
        int pcRelativeOffset = jumpTarget - patchPos;
        PatchLabelKind type = PatchLabelKind.fromEncoding(instruction);
        int extraInformation = PatchLabelKind.decodeExtraInformation(instruction);
        switch (type) {
            case BRANCH_CONDITIONALLY: {
                AArch64Assembler.ConditionFlag condition = AArch64Assembler.ConditionFlag.fromEncoding(extraInformation);
                super.b(condition, pcRelativeOffset, patchPos);
                break;
            }
            case BRANCH_UNCONDITIONALLY: {
                super.b(pcRelativeOffset, patchPos);
                break;
            }
            case COMPARE_REG_BRANCH_NONZERO: 
            case COMPARE_REG_BRANCH_ZERO: {
                int size;
                if (!NumUtil.isSignedNbit(21, pcRelativeOffset)) {
                    throw new BranchTargetOutOfBoundsException(true, "Branch target %d out of bounds", pcRelativeOffset);
                }
                int regEncoding = extraInformation >>> 1;
                int sizeEncoding = extraInformation & 1;
                Register reg = AArch64.cpuRegisters.get(regEncoding);
                int n = size = sizeEncoding == 1 ? 64 : 32;
                if (type == PatchLabelKind.COMPARE_REG_BRANCH_NONZERO) {
                    super.cbnz(size, reg, pcRelativeOffset, patchPos);
                    break;
                }
                super.cbz(size, reg, pcRelativeOffset, patchPos);
                break;
            }
            case TEST_BIT_BRANCH_NONZERO: 
            case TEST_BIT_BRANCH_ZERO: {
                if (!NumUtil.isSignedNbit(16, pcRelativeOffset)) {
                    throw new BranchTargetOutOfBoundsException(true, "Branch target %d out of bounds", pcRelativeOffset);
                }
                int uimm6 = extraInformation & NumUtil.getNbitNumberInt(6);
                int regEncoding = extraInformation >>> 6;
                Register reg = AArch64.cpuRegisters.get(regEncoding);
                if (type == PatchLabelKind.TEST_BIT_BRANCH_NONZERO) {
                    super.tbnz(reg, uimm6, pcRelativeOffset, patchPos);
                    break;
                }
                super.tbz(reg, uimm6, pcRelativeOffset, patchPos);
                break;
            }
            case ADR: {
                Register reg = AArch64.cpuRegisters.get(extraInformation);
                super.adr(reg, pcRelativeOffset, patchPos);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    @Override
    public AArch64Address getPlaceholder(int instructionStartPosition) {
        return AArch64Address.PLACEHOLDER;
    }

    public void adrpAdd(Register dst) {
        if (this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AdrpAddMacroInstruction(this.position()));
        }
        super.adrp(dst);
        super.add(64, dst, dst, 0);
    }

    public void popcnt(int size, Register dst, Register src, Register vreg) {
        assert (32 == size || 64 == size) : "Invalid data size";
        assert (dst.getRegisterCategory().equals((Object)AArch64.CPU));
        assert (src.getRegisterCategory().equals((Object)AArch64.CPU));
        assert (vreg.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.fmov(size, vreg, src);
        this.neon.cntVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, vreg, vreg);
        this.neon.addvSV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Byte, vreg, vreg);
        this.neon.umovGX(AArch64ASIMDAssembler.ElementSize.DoubleWord, dst, vreg, 0);
    }

    public void cacheWriteback(AArch64Address line) {
        assert (line.getAddressingMode() == AArch64Address.AddressingMode.BASE_REGISTER_ONLY) : line;
        this.dc(AArch64Assembler.DataCacheOperationType.CVAP, line.getBase());
    }

    public void adrpLdr(int srcSize, Register result, Register addressReg) {
        if (this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AdrpLdrMacroInstruction(this.position(), srcSize));
        }
        super.adrp(addressReg);
        AArch64Address address = AArch64Address.createImmediateAddress(srcSize, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, addressReg, 0);
        this.ldr(srcSize, result, address, false);
    }

    private void annotateImmediateMovSequence(int pos, MovSequenceAnnotation.MovAction[] includeSet) {
        if (this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new MovSequenceAnnotation(pos, includeSet));
        }
    }

    public static class MovSequenceAnnotation
    extends AArch64Assembler.PatchableCodeAnnotation {
        public final MovAction[] includeSet;

        MovSequenceAnnotation(int instructionPosition, MovAction[] includeSet) {
            super(instructionPosition);
            this.includeSet = includeSet;
        }

        public String toString() {
            return "MOV_SEQ";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void patch(long startAddress, int relative, byte[] code) {
            long curValue = startAddress + (long)relative;
            int siteOffset = 0;
            boolean containsNegatedMov = false;
            for (MovAction include : this.includeSet) {
                if (include != MovAction.NEGATED) continue;
                containsNegatedMov = true;
                break;
            }
            int i = 0;
            while (true) {
                block9: {
                    if (i >= this.includeSet.length) {
                        return;
                    }
                    int value = (int)curValue & 0xFFFF;
                    curValue >>= 16;
                    switch (this.includeSet[i]) {
                        case USED: {
                            break;
                        }
                        case SKIPPED: {
                            assert (value == (containsNegatedMov ? 65535 : 0)) : "Unable to patch this value.";
                            break block9;
                        }
                        case NEGATED: {
                            value ^= 0xFFFF;
                        }
                    }
                    int instOffset = this.instructionPosition + siteOffset;
                    int originalInst = AArch64Assembler.PatcherUtil.readInstruction(code, instOffset);
                    int newInst = AArch64Assembler.PatcherUtil.patchMov(originalInst, value);
                    AArch64Assembler.PatcherUtil.writeInstruction(code, instOffset, newInst);
                    siteOffset += 4;
                }
                ++i;
            }
        }

        public static enum MovAction {
            USED,
            SKIPPED,
            NEGATED;

        }
    }

    public static class AdrpAddMacroInstruction
    extends AArch64Assembler.PatchableCodeAnnotation {
        public AdrpAddMacroInstruction(int position) {
            super(position);
        }

        public String toString() {
            return "ADRP_ADD";
        }

        @Override
        public void patch(long startAddress, int relative, byte[] code) {
            long targetAddress = startAddress + (long)relative;
            int relativePageDifference = AArch64Assembler.PatcherUtil.computeRelativePageDifference(targetAddress, startAddress, 4096);
            int originalInst = AArch64Assembler.PatcherUtil.readInstruction(code, this.instructionPosition);
            int newInst = AArch64Assembler.PatcherUtil.patchAdrpHi21(originalInst, relativePageDifference & 0x1FFFFF);
            AArch64Assembler.PatcherUtil.writeInstruction(code, this.instructionPosition, newInst);
            originalInst = AArch64Assembler.PatcherUtil.readInstruction(code, this.instructionPosition + 4);
            newInst = AArch64Assembler.PatcherUtil.patchAddLo12(originalInst, (int)targetAddress & 0xFFF);
            AArch64Assembler.PatcherUtil.writeInstruction(code, this.instructionPosition + 4, newInst);
        }
    }

    public static class AdrpLdrMacroInstruction
    extends AArch64Assembler.PatchableCodeAnnotation {
        public final int srcSize;

        public AdrpLdrMacroInstruction(int position, int srcSize) {
            super(position);
            this.srcSize = srcSize;
        }

        public String toString() {
            return "ADRP_LDR";
        }

        @Override
        public void patch(long startAddress, int relative, byte[] code) {
            long targetAddress = startAddress + (long)relative;
            int relativePageDifference = AArch64Assembler.PatcherUtil.computeRelativePageDifference(targetAddress, startAddress, 4096);
            int originalInst = AArch64Assembler.PatcherUtil.readInstruction(code, this.instructionPosition);
            int newInst = AArch64Assembler.PatcherUtil.patchAdrpHi21(originalInst, relativePageDifference & 0x1FFFFF);
            AArch64Assembler.PatcherUtil.writeInstruction(code, this.instructionPosition, newInst);
            originalInst = AArch64Assembler.PatcherUtil.readInstruction(code, this.instructionPosition + 4);
            newInst = AArch64Assembler.PatcherUtil.patchLdrLo12(originalInst, (int)targetAddress & 0xFFF, this.srcSize);
            AArch64Assembler.PatcherUtil.writeInstruction(code, this.instructionPosition + 4, newInst);
        }
    }

    public static enum AArch64ExceptionCode {
        NO_SWITCH_TARGET(0),
        BREAKPOINT(1);

        public final int encoding;

        private AArch64ExceptionCode(int encoding) {
            this.encoding = encoding;
        }
    }

    private static final class PatchLabelKind
    extends Enum<PatchLabelKind> {
        public static final /* enum */ PatchLabelKind BRANCH_CONDITIONALLY = new PatchLabelKind(0);
        public static final /* enum */ PatchLabelKind BRANCH_UNCONDITIONALLY = new PatchLabelKind(1);
        public static final /* enum */ PatchLabelKind COMPARE_REG_BRANCH_NONZERO = new PatchLabelKind(2);
        public static final /* enum */ PatchLabelKind COMPARE_REG_BRANCH_ZERO = new PatchLabelKind(3);
        public static final /* enum */ PatchLabelKind TEST_BIT_BRANCH_NONZERO = new PatchLabelKind(4);
        public static final /* enum */ PatchLabelKind TEST_BIT_BRANCH_ZERO = new PatchLabelKind(5);
        public static final /* enum */ PatchLabelKind ADR = new PatchLabelKind(6);
        static final int INFORMATION_OFFSET = 5;
        final int encoding;
        private static final /* synthetic */ PatchLabelKind[] $VALUES;

        public static PatchLabelKind[] values() {
            return (PatchLabelKind[])$VALUES.clone();
        }

        public static PatchLabelKind valueOf(String name) {
            return Enum.valueOf(PatchLabelKind.class, name);
        }

        private PatchLabelKind(int encoding) {
            this.encoding = encoding;
        }

        static PatchLabelKind fromEncoding(int encoding) {
            return PatchLabelKind.values()[encoding & NumUtil.getNbitNumberInt(5)];
        }

        static int encode(PatchLabelKind patchKind, int extraInformation) {
            assert (NumUtil.isUnsignedNbit(27, extraInformation));
            return patchKind.encoding | extraInformation << 5;
        }

        static int decodeExtraInformation(int encoding) {
            return encoding >>> 5;
        }

        static {
            $VALUES = new PatchLabelKind[]{BRANCH_CONDITIONALLY, BRANCH_UNCONDITIONALLY, COMPARE_REG_BRANCH_NONZERO, COMPARE_REG_BRANCH_ZERO, TEST_BIT_BRANCH_NONZERO, TEST_BIT_BRANCH_ZERO, ADR};
        }
    }

    private static class AArch64MemoryEncoding {
        private AArch64Address address;
        private Register result;
        private int byteMemoryTransferSize;
        private boolean isStore;
        private boolean isFP;
        private int position;

        AArch64MemoryEncoding(int byteMemoryTransferSize, Register result, AArch64Address address, boolean isStore, boolean isFP, int position) {
            this.byteMemoryTransferSize = byteMemoryTransferSize;
            this.result = result;
            this.address = address;
            this.isStore = isStore;
            this.isFP = isFP;
            this.position = position;
            AArch64Address.AddressingMode addressingMode = address.getAddressingMode();
            assert (addressingMode == AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED || addressingMode == AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED) : "Invalid address modeto merge: " + (Object)((Object)addressingMode);
        }

        Register getBase() {
            return this.address.getBase();
        }

        int getOffset() {
            if (this.address.getAddressingMode() == AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED) {
                return this.address.getImmediateRaw();
            }
            return this.address.getImmediate() * this.byteMemoryTransferSize;
        }
    }

    public class ScratchRegister
    implements AutoCloseable {
        private final Register register;

        public ScratchRegister(Register register) {
            this.register = register;
        }

        public Register getRegister() {
            return this.register;
        }

        @Override
        public void close() {
            assert (AArch64MacroAssembler.this.nextFreeScratchRegister > 0) : "Close called too often";
            AArch64MacroAssembler.this.nextFreeScratchRegister--;
        }
    }
}

