/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.code;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DisassemblerProvider;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.util.CollectionsUtil;

@ServiceProvider(value=DisassemblerProvider.class)
public class ObjdumpDisassemblerProvider
implements DisassemblerProvider {
    private Map<String, Boolean> objdumpCache = new HashMap<String, Boolean>();
    private static final Pattern SAFE_SHELL_ARG = Pattern.compile("[A-Za-z0-9@%_\\-\\+=:,\\./]+");

    private static Process createProcess(String[] cmd) {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        try {
            return pb.start();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean isAvailable(OptionValues options) {
        return this.getObjdump(options) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String disassembleCompiledCode(OptionValues options, CodeCacheProvider codeCache, CompilationResult compResult) {
        Throwable throwable;
        String objdump = this.getObjdump(options);
        if (objdump == null) {
            return null;
        }
        File tmp = null;
        try {
            String[] cmdline;
            tmp = File.createTempFile("compiledBinary", ".bin");
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(tmp);){
                fos.write(compResult.getTargetCode());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            String arch = (String)Services.getSavedProperties().get("os.arch");
            if (arch.equals("amd64") || arch.equals("x86_64")) {
                cmdline = new String[]{objdump, "-D", "-b", "binary", "-M", "x86-64", "-m", "i386", tmp.getAbsolutePath()};
            } else if (arch.equals("aarch64")) {
                cmdline = new String[]{objdump, "-D", "-b", "binary", "-m", "aarch64", tmp.getAbsolutePath()};
            } else {
                String string = null;
                return string;
            }
            Pattern p = Pattern.compile(" *(([0-9a-fA-F]+):\t.*)");
            TargetDescription target = codeCache.getTarget();
            RegisterConfig regConfig = codeCache.getRegisterConfig();
            Register fp = regConfig.getFrameRegister();
            CodeUtil.DefaultRefMapFormatter slotFormatter = new CodeUtil.DefaultRefMapFormatter(target.wordSize, fp, 0);
            HashMap<Integer, String> annotations = new HashMap<Integer, String>();
            for (DataPatch site : compResult.getDataPatches()) {
                ObjdumpDisassemblerProvider.putAnnotation(annotations, site.pcOffset, "{" + site.reference.toString() + "}");
            }
            for (CompilationResult.CodeMark mark : compResult.getMarks()) {
                ObjdumpDisassemblerProvider.putAnnotation(annotations, mark.pcOffset, mark.id.getName());
            }
            for (CompilationResult.CodeAnnotation a : compResult.getCodeAnnotations()) {
                ObjdumpDisassemblerProvider.putAnnotation(annotations, a.getPosition(), a.toString());
            }
            for (Infopoint infopoint : compResult.getInfopoints()) {
                if (infopoint instanceof Call) {
                    Call call = (Call)infopoint;
                    if (call.debugInfo != null) {
                        ObjdumpDisassemblerProvider.putAnnotation(annotations, call.pcOffset + call.size, CodeUtil.append((StringBuilder)new StringBuilder(100), (DebugInfo)call.debugInfo, (CodeUtil.RefMapFormatter)slotFormatter).toString());
                    }
                    ObjdumpDisassemblerProvider.putAnnotation(annotations, call.pcOffset, "{" + codeCache.getTargetName(call) + "}");
                    continue;
                }
                if (infopoint.debugInfo != null) {
                    ObjdumpDisassemblerProvider.putAnnotation(annotations, infopoint.pcOffset, CodeUtil.append((StringBuilder)new StringBuilder(100), (DebugInfo)infopoint.debugInfo, (CodeUtil.RefMapFormatter)slotFormatter).toString());
                }
                ObjdumpDisassemblerProvider.putAnnotation(annotations, infopoint.pcOffset, "{infopoint: " + infopoint.reason + "}");
            }
            Process proc = ObjdumpDisassemblerProvider.createProcess(cmdline);
            if (proc == null) {
                Infopoint infopoint;
                infopoint = null;
                return infopoint;
            }
            InputStream is = proc.getInputStream();
            StringBuilder sb = new StringBuilder();
            InputStreamReader isr = new InputStreamReader(is);
            try (BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    Matcher m = p.matcher(line);
                    if (m.find()) {
                        int address = Integer.parseInt(m.group(2), 16);
                        String annotation = (String)annotations.get(address);
                        if (annotation != null) {
                            annotation = annotation.replace("\n", "\n; ");
                            sb.append("; ").append(annotation).append('\n');
                        }
                        line = m.replaceAll("0x$1");
                    }
                    sb.append(line).append("\n");
                }
            }
            var19_25 = null;
            try (BufferedReader ebr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
                String errLine = ebr.readLine();
                if (errLine != null) {
                    System.err.println("Error output from executing: " + CollectionsUtil.mapAndJoin(cmdline, e -> ObjdumpDisassemblerProvider.quoteShellArg(String.valueOf(e)), " "));
                    System.err.println(errLine);
                    while ((errLine = ebr.readLine()) != null) {
                        System.err.println(errLine);
                    }
                }
            }
            catch (Throwable throwable3) {
                var19_25 = throwable3;
                throw throwable3;
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throwable = null;
            return throwable;
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    public static String quoteShellArg(String arg) {
        if (arg.isEmpty()) {
            return "\"\"";
        }
        Matcher m = SAFE_SHELL_ARG.matcher(arg);
        if (m.matches()) {
            return arg;
        }
        return "'" + arg.replace("'", "'\"'\"'") + "'";
    }

    private String getObjdump(OptionValues options) {
        String candidates = Options.ObjdumpExecutables.getValue(options);
        if (candidates != null && !candidates.isEmpty()) {
            for (String candidate : candidates.split(",")) {
                Boolean cachedQuery = this.objdumpCache.get(candidate);
                if (cachedQuery != null) {
                    if (!cachedQuery.booleanValue()) continue;
                    return candidate;
                }
                try {
                    String[] cmd = new String[]{candidate, "--version"};
                    Process proc = ObjdumpDisassemblerProvider.createProcess(cmd);
                    if (proc == null) {
                        this.objdumpCache.put(candidate, Boolean.FALSE);
                        return null;
                    }
                    InputStream is = proc.getInputStream();
                    int exitValue = proc.waitFor();
                    if (exitValue == 0) {
                        int read;
                        byte[] buf = new byte[is.available()];
                        for (int pos = 0; pos < buf.length; pos += read) {
                            read = is.read(buf, pos, buf.length - pos);
                        }
                        String output = new String(buf);
                        if (output.contains("GNU objdump")) {
                            this.objdumpCache.put(candidate, Boolean.TRUE);
                            return candidate;
                        }
                    }
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
                this.objdumpCache.put(candidate, Boolean.FALSE);
            }
        }
        return null;
    }

    private static void putAnnotation(Map<Integer, String> annotations, int idx, String txt) {
        String newAnnotation = annotations.getOrDefault(idx, "") + "\n" + txt;
        annotations.put(idx, newAnnotation);
    }

    @Override
    public String disassembleInstalledCode(CodeCacheProvider codeCache, CompilationResult compResult, InstalledCode code) {
        return "<unavailable>";
    }

    @Override
    public String getName() {
        return "objdump";
    }

    static class Options {
        @Option(help={"Comma separated list of candidate GNU objdump executables. If not specified, disassembling via GNU objdump is disabled. Otherwise, the first existing executable in the list is used."}, type=OptionType.Debug)
        static final OptionKey<String> ObjdumpExecutables = new OptionKey<Object>(null);

        Options() {
        }
    }
}

