/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import java.util.function.Function;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.core.aarch64.AArch64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.aarch64.AArch64AddressValue;
import org.graalvm.compiler.lir.aarch64.AArch64ArithmeticOp;
import org.graalvm.compiler.lir.aarch64.AArch64ArrayCompareToOp;
import org.graalvm.compiler.lir.aarch64.AArch64ArrayEqualsOp;
import org.graalvm.compiler.lir.aarch64.AArch64ArrayIndexOfOp;
import org.graalvm.compiler.lir.aarch64.AArch64AtomicMove;
import org.graalvm.compiler.lir.aarch64.AArch64ByteSwap;
import org.graalvm.compiler.lir.aarch64.AArch64CacheWritebackOp;
import org.graalvm.compiler.lir.aarch64.AArch64CacheWritebackPostSyncOp;
import org.graalvm.compiler.lir.aarch64.AArch64Compare;
import org.graalvm.compiler.lir.aarch64.AArch64ControlFlow;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.aarch64.AArch64PauseOp;
import org.graalvm.compiler.lir.aarch64.AArch64SpeculativeBarrier;
import org.graalvm.compiler.lir.aarch64.AArch64ZapRegistersOp;
import org.graalvm.compiler.lir.aarch64.AArch64ZapStackOp;
import org.graalvm.compiler.lir.aarch64.AArch64ZeroMemoryOp;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.lir.gen.MoveFactory;
import org.graalvm.compiler.phases.util.Providers;

public abstract class AArch64LIRGenerator
extends LIRGenerator {
    public AArch64LIRGenerator(LIRKindTool lirKindTool, AArch64ArithmeticLIRGenerator arithmeticLIRGen, MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes) {
        super(lirKindTool, arithmeticLIRGen, moveFactory, providers, lirGenRes);
    }

    public AllocatableValue moveSp(AllocatableValue val) {
        if (val instanceof RegisterValue && ((RegisterValue)val).getRegister().equals((Object)AArch64.sp)) {
            assert (val.getPlatformKind() == AArch64Kind.QWORD) : "Stackpointer must be long";
            return this.emitMove((Value)val);
        }
        return val;
    }

    @Override
    public <K extends ValueKind<K>> K toRegisterKind(K kind) {
        switch ((AArch64Kind)kind.getPlatformKind()) {
            case BYTE: 
            case WORD: {
                return (K)kind.changeType((PlatformKind)AArch64Kind.DWORD);
            }
        }
        return kind;
    }

    @Override
    public void emitNullCheck(Value address, LIRFrameState state) {
        this.append(new AArch64Move.NullCheckOp(this.asAddressValue(address, -1), state));
    }

    @Override
    public Variable emitAddress(AllocatableValue stackslot) {
        Variable result = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
        this.append(new AArch64Move.StackLoadAddressOp(result, stackslot));
        return result;
    }

    public AArch64AddressValue asAddressValue(Value address, int bitTransferSize) {
        assert (address.getPlatformKind() == AArch64Kind.QWORD);
        if (address instanceof AArch64AddressValue) {
            return (AArch64AddressValue)address;
        }
        return AArch64AddressValue.makeAddress(address.getValueKind(), bitTransferSize, this.asAllocatable(address));
    }

    @Override
    public Variable emitLogicCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, Value trueValue, Value falseValue, MemoryOrderMode memoryOrder) {
        this.emitCompareAndSwap(true, accessKind, address, expectedValue, newValue, memoryOrder);
        assert (trueValue.getValueKind().equals(falseValue.getValueKind()));
        assert (LIRValueUtil.isIntConstant(trueValue, 1L) && LIRValueUtil.isIntConstant(falseValue, 0L));
        Variable result = this.newVariable(LIRKind.combine(trueValue, falseValue));
        this.append(new AArch64ControlFlow.CondSetOp(result, AArch64Assembler.ConditionFlag.EQ));
        return result;
    }

    public Variable emitValueCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, MemoryOrderMode memoryOrder) {
        return this.emitCompareAndSwap(false, accessKind, address, expectedValue, newValue, memoryOrder);
    }

    private Variable emitCompareAndSwap(boolean isLogicVariant, LIRKind accessKind, Value address, Value expectedValue, Value newValue, MemoryOrderMode memoryOrder) {
        LIRKind integerAccessKind = accessKind;
        Value reinterpretedExpectedValue = expectedValue;
        Value reinterpretedNewValue = newValue;
        boolean isFPKind = ((AArch64Kind)integerAccessKind.getPlatformKind()).isSIMD();
        if (isFPKind) {
            if (accessKind.getPlatformKind().equals(AArch64Kind.SINGLE)) {
                integerAccessKind = LIRKind.value((PlatformKind)AArch64Kind.DWORD);
            } else {
                assert (accessKind.getPlatformKind().equals(AArch64Kind.DOUBLE));
                integerAccessKind = LIRKind.value((PlatformKind)AArch64Kind.QWORD);
            }
            reinterpretedExpectedValue = this.arithmeticLIRGen.emitReinterpret(integerAccessKind, expectedValue);
            reinterpretedNewValue = this.arithmeticLIRGen.emitReinterpret(integerAccessKind, newValue);
        }
        AArch64Kind memKind = (AArch64Kind)integerAccessKind.getPlatformKind();
        Variable result = this.newVariable(integerAccessKind);
        AllocatableValue allocatableExpectedValue = this.asAllocatable(reinterpretedExpectedValue);
        AllocatableValue allocatableNewValue = this.asAllocatable(reinterpretedNewValue);
        this.append(new AArch64AtomicMove.CompareAndSwapOp(memKind, memoryOrder, isLogicVariant, result, (Value)allocatableExpectedValue, allocatableNewValue, this.asAllocatable(address)));
        if (isLogicVariant) {
            return null;
        }
        return isFPKind ? LIRValueUtil.asVariable(this.arithmeticLIRGen.emitReinterpret(accessKind, (Value)result)) : result;
    }

    @Override
    public Value emitAtomicReadAndWrite(Value address, ValueKind<?> kind, Value newValue) {
        Variable result = this.newVariable(kind);
        this.append(new AArch64AtomicMove.AtomicReadAndWriteOp((AArch64Kind)kind.getPlatformKind(), result, this.asAllocatable(address), this.asAllocatable(newValue)));
        return result;
    }

    @Override
    public Value emitAtomicReadAndAdd(Value address, ValueKind<?> kind, Value delta) {
        Variable result = this.newVariable(kind);
        this.append(AArch64AtomicMove.createAtomicReadAndAdd(this, (AArch64Kind)kind.getPlatformKind(), result, this.asAllocatable(address), delta));
        return result;
    }

    @Override
    public void emitMembar(int barriers) {
        int necessaryBarriers = this.target().arch.requiredBarriers(barriers);
        if (this.target().isMP && necessaryBarriers != 0) {
            this.append(new AArch64Move.MembarOp(necessaryBarriers));
        }
    }

    @Override
    public void emitJump(LabelRef label) {
        assert (label != null);
        this.append(new StandardOp.JumpOp(label));
    }

    @Override
    public void emitOverflowCheckBranch(LabelRef overflow, LabelRef noOverflow, LIRKind cmpKind, double overflowProbability) {
        this.append(new AArch64ControlFlow.BranchOp(AArch64Assembler.ConditionFlag.VS, overflow, noOverflow, overflowProbability));
    }

    @Override
    public void emitIntegerTestBranch(Value left, Value right, LabelRef trueDestination, LabelRef falseDestination, double trueSuccessorProbability) {
        assert (((AArch64Kind)left.getPlatformKind()).isInteger() && left.getPlatformKind() == right.getPlatformKind());
        ((AArch64ArithmeticLIRGenerator)this.getArithmetic()).emitBinary((AllocatableValue)AArch64.zr.asValue((ValueKind)LIRKind.combine(left, right)), AArch64ArithmeticOp.TST, true, left, right);
        this.append(new AArch64ControlFlow.BranchOp(AArch64Assembler.ConditionFlag.EQ, trueDestination, falseDestination, trueSuccessorProbability));
    }

    @Override
    public Variable emitConditionalMove(PlatformKind cmpKind, Value left, Value right, Condition cond, boolean unorderedIsTrue, Value trueValue, Value falseValue) {
        boolean mirrored;
        AArch64ArithmeticLIRGenerator arithLir = (AArch64ArithmeticLIRGenerator)this.arithmeticLIRGen;
        Value actualRight = right;
        if (LIRValueUtil.isJavaConstant(actualRight) && arithLir.mustReplaceNullWithNullRegister(LIRValueUtil.asJavaConstant(actualRight))) {
            actualRight = arithLir.getNullRegisterValue();
        }
        Condition finalCondition = (mirrored = this.emitCompare(cmpKind, left, actualRight, cond, unorderedIsTrue)) ? cond.mirror() : cond;
        AArch64Assembler.ConditionFlag cmpCondition = AArch64LIRGenerator.toConditionFlag(((AArch64Kind)cmpKind).isInteger(), finalCondition, unorderedIsTrue);
        Variable result = this.newVariable(LIRKind.mergeReferenceInformation(trueValue, falseValue));
        if (LIRValueUtil.isIntConstant(trueValue, 1L) && LIRValueUtil.isIntConstant(falseValue, 0L)) {
            this.append(new AArch64ControlFlow.CondSetOp(result, cmpCondition));
        } else if (LIRValueUtil.isIntConstant(trueValue, 0L) && LIRValueUtil.isIntConstant(falseValue, 1L)) {
            this.append(new AArch64ControlFlow.CondSetOp(result, cmpCondition.negate()));
        } else {
            this.append(new AArch64ControlFlow.CondMoveOp(result, cmpCondition, this.loadReg(trueValue), this.loadReg(falseValue)));
        }
        return result;
    }

    @Override
    public void emitCompareBranch(PlatformKind cmpKind, Value left, Value right, Condition cond, boolean unorderedIsTrue, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
        boolean mirrored;
        Value actualRight = right;
        if (cond == Condition.EQ) {
            AArch64Kind kind;
            assert (!LIRValueUtil.isNullConstant(left)) : "emitNullCheckBranch()'s null input should be in right.";
            AArch64ArithmeticLIRGenerator arithLir = (AArch64ArithmeticLIRGenerator)this.arithmeticLIRGen;
            if (LIRValueUtil.isNullConstant(actualRight)) {
                JavaConstant rightConstant = LIRValueUtil.asJavaConstant(actualRight);
                if (arithLir.mustReplaceNullWithNullRegister(rightConstant)) {
                    actualRight = arithLir.getNullRegisterValue();
                } else {
                    this.append(new AArch64ControlFlow.CompareBranchZeroOp(this.asAllocatable(left), trueDestination, falseDestination, trueDestinationProbability));
                    return;
                }
            }
            if ((kind = (AArch64Kind)cmpKind).isInteger()) {
                if (LIRValueUtil.isIntConstant(left, 0L)) {
                    this.append(new AArch64ControlFlow.CompareBranchZeroOp(this.asAllocatable(actualRight), trueDestination, falseDestination, trueDestinationProbability));
                    return;
                }
                if (LIRValueUtil.isIntConstant(actualRight, 0L)) {
                    this.append(new AArch64ControlFlow.CompareBranchZeroOp(this.asAllocatable(left), trueDestination, falseDestination, trueDestinationProbability));
                    return;
                }
            }
        }
        Condition finalCondition = (mirrored = this.emitCompare(cmpKind, left, actualRight, cond, unorderedIsTrue)) ? cond.mirror() : cond;
        AArch64Assembler.ConditionFlag cmpCondition = AArch64LIRGenerator.toConditionFlag(((AArch64Kind)cmpKind).isInteger(), finalCondition, unorderedIsTrue);
        this.append(new AArch64ControlFlow.BranchOp(cmpCondition, trueDestination, falseDestination, trueDestinationProbability));
    }

    private static AArch64Assembler.ConditionFlag toConditionFlag(boolean isInt, Condition cond, boolean unorderedIsTrue) {
        return isInt ? AArch64LIRGenerator.toIntConditionFlag(cond) : AArch64LIRGenerator.toFloatConditionFlag(cond, unorderedIsTrue);
    }

    private static AArch64Assembler.ConditionFlag toFloatConditionFlag(Condition cond, boolean unorderedIsTrue) {
        switch (cond) {
            case LT: {
                return unorderedIsTrue ? AArch64Assembler.ConditionFlag.LT : AArch64Assembler.ConditionFlag.LO;
            }
            case LE: {
                return unorderedIsTrue ? AArch64Assembler.ConditionFlag.LE : AArch64Assembler.ConditionFlag.LS;
            }
            case GE: {
                return unorderedIsTrue ? AArch64Assembler.ConditionFlag.PL : AArch64Assembler.ConditionFlag.GE;
            }
            case GT: {
                return unorderedIsTrue ? AArch64Assembler.ConditionFlag.HI : AArch64Assembler.ConditionFlag.GT;
            }
            case EQ: {
                return AArch64Assembler.ConditionFlag.EQ;
            }
            case NE: {
                return AArch64Assembler.ConditionFlag.NE;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private static AArch64Assembler.ConditionFlag toIntConditionFlag(Condition cond) {
        switch (cond) {
            case EQ: {
                return AArch64Assembler.ConditionFlag.EQ;
            }
            case NE: {
                return AArch64Assembler.ConditionFlag.NE;
            }
            case LT: {
                return AArch64Assembler.ConditionFlag.LT;
            }
            case LE: {
                return AArch64Assembler.ConditionFlag.LE;
            }
            case GT: {
                return AArch64Assembler.ConditionFlag.GT;
            }
            case GE: {
                return AArch64Assembler.ConditionFlag.GE;
            }
            case AE: {
                return AArch64Assembler.ConditionFlag.HS;
            }
            case BE: {
                return AArch64Assembler.ConditionFlag.LS;
            }
            case AT: {
                return AArch64Assembler.ConditionFlag.HI;
            }
            case BT: {
                return AArch64Assembler.ConditionFlag.LO;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    protected boolean emitCompare(PlatformKind cmpKind, Value a, Value b, Condition condition, boolean unorderedIsTrue) {
        boolean mirrored;
        Object left;
        Object right;
        boolean bIsConstant;
        boolean aIsConstant;
        boolean bIsStackPointer;
        boolean aIsStackPointer;
        AArch64Kind kind = (AArch64Kind)cmpKind;
        assert (a.getPlatformKind() == b.getPlatformKind());
        int cmpBitSize = cmpKind.getSizeInBytes() * 8;
        GraalError.guarantee(cmpBitSize >= 32 && cmpKind == a.getPlatformKind(), "Unexpected comparison parameters.");
        if (kind.isInteger()) {
            aIsStackPointer = ValueUtil.isRegister((Value)a) && ValueUtil.asRegister((Value)a).equals((Object)AArch64.sp);
            bIsStackPointer = ValueUtil.isRegister((Value)b) && ValueUtil.asRegister((Value)b).equals((Object)AArch64.sp);
            aIsConstant = AArch64Compare.CompareOp.isCompareConstant(a);
            bIsConstant = AArch64Compare.CompareOp.isCompareConstant(b);
        } else {
            assert (kind.isSIMD());
            aIsStackPointer = false;
            bIsStackPointer = false;
            aIsConstant = AArch64Compare.FloatCompareOp.isCompareConstant(a, condition, unorderedIsTrue);
            bIsConstant = AArch64Compare.FloatCompareOp.isCompareConstant(b, condition, unorderedIsTrue);
        }
        if (aIsStackPointer && bIsStackPointer) {
            left = right = this.emitMove(a);
            mirrored = false;
        } else if (bIsStackPointer || aIsConstant && !bIsConstant) {
            left = b;
            right = a;
            mirrored = true;
        } else {
            left = a;
            right = bIsConstant ? b : this.loadReg(b);
            mirrored = false;
        }
        left = this.loadReg((Value)left);
        this.append(kind.isInteger() ? new AArch64Compare.CompareOp((Value)left, (Value)right) : new AArch64Compare.FloatCompareOp((Value)left, (Value)right, condition, unorderedIsTrue));
        return mirrored;
    }

    @Override
    public Variable emitIntegerTestMove(Value left, Value right, Value trueValue, Value falseValue) {
        assert (left.getPlatformKind() == right.getPlatformKind() && ((AArch64Kind)left.getPlatformKind()).isInteger());
        assert (trueValue.getPlatformKind() == falseValue.getPlatformKind());
        ((AArch64ArithmeticLIRGenerator)this.getArithmetic()).emitBinary((AllocatableValue)AArch64.zr.asValue((ValueKind)LIRKind.combine(left, right)), AArch64ArithmeticOp.TST, true, left, right);
        Variable result = this.newVariable(LIRKind.mergeReferenceInformation(trueValue, falseValue));
        if (LIRValueUtil.isIntConstant(trueValue, 1L) && LIRValueUtil.isIntConstant(falseValue, 0L)) {
            this.append(new AArch64ControlFlow.CondSetOp(result, AArch64Assembler.ConditionFlag.EQ));
        } else if (LIRValueUtil.isIntConstant(trueValue, 0L) && LIRValueUtil.isIntConstant(falseValue, 1L)) {
            this.append(new AArch64ControlFlow.CondSetOp(result, AArch64Assembler.ConditionFlag.NE));
        } else {
            this.append(new AArch64ControlFlow.CondMoveOp(result, AArch64Assembler.ConditionFlag.EQ, this.load(trueValue), this.load(falseValue)));
        }
        return result;
    }

    @Override
    public void emitStrategySwitch(SwitchStrategy strategy, Variable key, LabelRef[] keyTargets, LabelRef defaultTarget) {
        this.append(this.createStrategySwitchOp(strategy, keyTargets, defaultTarget, key, AArch64LIRGenerator::toIntConditionFlag));
    }

    protected AArch64ControlFlow.StrategySwitchOp createStrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, Variable key, Function<Condition, AArch64Assembler.ConditionFlag> converter) {
        return new AArch64ControlFlow.StrategySwitchOp(strategy, keyTargets, defaultTarget, key, converter);
    }

    @Override
    protected void emitTableSwitch(int lowKey, LabelRef defaultTarget, LabelRef[] targets, Value key) {
        this.append(new AArch64ControlFlow.TableSwitchOp(lowKey, defaultTarget, targets, this.asAllocatable(key)));
    }

    @Override
    public Variable emitByteSwap(Value input) {
        Variable result = this.newVariable(LIRKind.combine(input));
        this.append(new AArch64ByteSwap.ByteSwapOp(result, this.asAllocatable(input)));
        return result;
    }

    @Override
    public Variable emitArrayCompareTo(JavaKind kind1, JavaKind kind2, int array1BaseOffset, int array2BaseOffset, Value array1, Value array2, Value length1, Value length2) {
        LIRKind resultKind = LIRKind.value((PlatformKind)AArch64Kind.DWORD);
        RegisterValue res = AArch64.r0.asValue((ValueKind)resultKind);
        RegisterValue cnt1 = AArch64.r1.asValue(length1.getValueKind());
        RegisterValue cnt2 = AArch64.r2.asValue(length2.getValueKind());
        this.emitMove((AllocatableValue)cnt1, length1);
        this.emitMove((AllocatableValue)cnt2, length2);
        this.append(new AArch64ArrayCompareToOp(this, kind1, kind2, array1BaseOffset, array2BaseOffset, (Value)res, array1, array2, (Value)cnt1, (Value)cnt2));
        Variable result = this.newVariable(resultKind);
        this.emitMove(result, (Value)res);
        return result;
    }

    @Override
    public Variable emitArrayEquals(JavaKind kind, int array1BaseOffset, int array2BaseOffset, Value array1, Value array2, Value length, boolean directPointers) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AArch64Kind.DWORD));
        this.append(new AArch64ArrayEqualsOp(this, kind, array1BaseOffset, array2BaseOffset, (Value)result, array1, array2, (Value)this.asAllocatable(length), directPointers));
        return result;
    }

    @Override
    public Variable emitArrayIndexOf(int arrayBaseOffset, JavaKind valueKind, boolean findTwoConsecutive, Value arrayPointer, Value arrayLength, Value fromIndex, Value ... searchValues) {
        assert (searchValues.length == 1);
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AArch64Kind.DWORD));
        this.append(new AArch64ArrayIndexOfOp(arrayBaseOffset, valueKind, findTwoConsecutive, this, result, this.asAllocatable(arrayPointer), this.asAllocatable(arrayLength), this.asAllocatable(fromIndex), this.asAllocatable(searchValues[0])));
        return result;
    }

    @Override
    protected JavaConstant zapValueForKind(PlatformKind kind) {
        long dead = -2401018187971961171L;
        AArch64Kind aarch64Kind = (AArch64Kind)kind;
        switch (aarch64Kind) {
            case BYTE: {
                return JavaConstant.forByte((byte)((byte)dead));
            }
            case WORD: {
                return JavaConstant.forShort((short)((short)dead));
            }
            case DWORD: {
                return JavaConstant.forInt((int)((int)dead));
            }
            case QWORD: {
                return JavaConstant.forLong((long)dead);
            }
        }
        assert (aarch64Kind.isSIMD());
        if (aarch64Kind.getSizeInBytes() <= AArch64Kind.SINGLE.getSizeInBytes()) {
            return JavaConstant.forFloat((float)Float.intBitsToFloat((int)dead));
        }
        return JavaConstant.forDouble((double)Double.longBitsToDouble(dead));
    }

    protected AllocatableValue loadReg(Value val) {
        if (!LIRValueUtil.isVariable(val) && !(val instanceof RegisterValue)) {
            return this.emitMove(val);
        }
        return (AllocatableValue)val;
    }

    @Override
    public void emitPause() {
        this.append(new AArch64PauseOp());
    }

    @Override
    public void emitCacheWriteback(Value address) {
        this.append(new AArch64CacheWritebackOp(this.asAddressValue(address, -1)));
    }

    @Override
    public void emitCacheWritebackSync(boolean isPreSync) {
        if (!isPreSync) {
            this.append(new AArch64CacheWritebackPostSyncOp());
        }
    }

    @Override
    public LIRInstruction createZapRegisters(Register[] zappedRegisters, JavaConstant[] zapValues) {
        return new AArch64ZapRegistersOp(zappedRegisters, zapValues);
    }

    @Override
    public LIRInstruction createZapArgumentSpace(StackSlot[] zappedStack, JavaConstant[] zapValues) {
        return new AArch64ZapStackOp(zappedStack, zapValues);
    }

    public abstract void emitCCall(long var1, CallingConvention var3, Value[] var4);

    @Override
    public void emitSpeculationFence() {
        this.append(new AArch64SpeculativeBarrier());
    }

    @Override
    public void emitZeroMemory(Value address, Value length, boolean isAligned) {
        this.emitZeroMemory(address, length, isAligned, false, -1);
    }

    protected final void emitZeroMemory(Value address, Value length, boolean isAligned, boolean useDcZva, int zvaLength) {
        RegisterValue regAddress = AArch64.r0.asValue(address.getValueKind());
        RegisterValue regLength = AArch64.r1.asValue(length.getValueKind());
        this.emitMove((AllocatableValue)regAddress, address);
        this.emitMove((AllocatableValue)regLength, length);
        this.append(new AArch64ZeroMemoryOp((Value)regAddress, (Value)regLength, isAligned, useDcZva, zvaLength));
    }
}

