/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import org.graalvm.compiler.core.aarch64.AArch64ReadNode;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.VolatileReadNode;
import org.graalvm.compiler.phases.Phase;

public class AArch64ReadReplacementPhase
extends Phase {
    @Override
    protected void run(StructuredGraph graph) {
        for (Node node : graph.getNodes()) {
            ReadNode readNode;
            if (node instanceof AArch64ReadNode || !(node instanceof ReadNode) || node instanceof VolatileReadNode || !(readNode = (ReadNode)node).hasExactlyOneUsage()) continue;
            Stamp stamp = readNode.getAccessStamp(NodeView.DEFAULT);
            Node usage = readNode.usages().first();
            if (!(usage instanceof ZeroExtendNode) && !(usage instanceof SignExtendNode) || !(stamp instanceof IntegerStamp)) continue;
            AArch64ReadNode.replace(readNode);
        }
    }
}

