/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;

@NodeInfo
public class AMD64AddressNode
extends AddressNode
implements Simplifiable,
LIRLowerable {
    public static final NodeClass<AMD64AddressNode> TYPE = NodeClass.create(AMD64AddressNode.class);
    @Node.OptionalInput
    private ValueNode base;
    @Node.OptionalInput
    private ValueNode index;
    private AMD64Address.Scale scale;
    private int displacement;

    public AMD64AddressNode(ValueNode base) {
        this(base, null);
    }

    public AMD64AddressNode(ValueNode base, ValueNode index) {
        super((NodeClass<? extends AddressNode>)TYPE);
        this.base = base;
        this.index = index;
        this.scale = AMD64Address.Scale.Times1;
    }

    public void canonicalizeIndex(SimplifierTool tool) {
        ValueNode valY;
        LoopBeginNode loopNode;
        PhiNode phi;
        AddNode add;
        ValueNode valX;
        if (this.index instanceof AddNode && ((IntegerStamp)this.index.stamp(NodeView.DEFAULT)).getBits() == 64 && (valX = (add = (AddNode)this.index).getX()) instanceof PhiNode && (phi = (PhiNode)valX).merge() instanceof LoopBeginNode && !(loopNode = (LoopBeginNode)phi.merge()).isSimpleLoop() && (valY = add.getY()) instanceof ConstantNode) {
            int addBy = valY.asJavaConstant().asInt();
            this.displacement += this.scale.value * addBy;
            this.replaceFirstInput(this.index, phi);
            tool.addToWorkList(this.index);
        }
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        AllocatableValue baseValue = this.base == null ? Value.ILLEGAL : tool.asAllocatable(gen.operand(this.base));
        AllocatableValue indexValue = this.index == null ? Value.ILLEGAL : tool.asAllocatable(gen.operand(this.index));
        AllocatableValue baseReference = LIRKind.derivedBaseFromValue(baseValue);
        Object indexReference = this.index == null ? null : (this.scale.equals((Object)AMD64Address.Scale.Times1) ? LIRKind.derivedBaseFromValue(indexValue) : (LIRKind.isValue((Value)indexValue) ? null : Value.ILLEGAL));
        LIRKind kind = LIRKind.combineDerived(tool.getLIRKind(this.stamp(NodeView.DEFAULT)), baseReference, indexReference);
        gen.setResult(this, new AMD64AddressValue(kind, baseValue, indexValue, this.scale, this.displacement));
    }

    @Override
    public ValueNode getBase() {
        return this.base;
    }

    public void setBase(ValueNode base) {
        if (this.isAlive()) {
            this.updateUsages(this.base, base);
        }
        this.base = base;
    }

    @Override
    public ValueNode getIndex() {
        return this.index;
    }

    public void setIndex(ValueNode index) {
        if (this.isAlive()) {
            this.updateUsages(this.index, index);
        }
        this.index = index;
    }

    public AMD64Address.Scale getScale() {
        return this.scale;
    }

    public void setScale(AMD64Address.Scale scale) {
        this.scale = scale;
    }

    public int getDisplacement() {
        return this.displacement;
    }

    public void setDisplacement(int displacement) {
        this.displacement = displacement;
    }

    @Override
    public long getMaxConstantDisplacement() {
        return this.displacement;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        this.canonicalizeIndex(tool);
    }
}

