/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.type;

import java.nio.ByteBuffer;
import java.util.function.DoubleBinaryOperator;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SerializableConstant;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.calc.ReinterpretUtils;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;

public class FloatStamp
extends PrimitiveStamp {
    private final double lowerBound;
    private final double upperBound;
    private final boolean nonNaN;
    public static final ArithmeticOpTable OPS = new ArithmeticOpTable(new ArithmeticOpTable.UnaryOp.Neg(){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            switch (value.getJavaKind()) {
                case Float: {
                    return JavaConstant.forFloat((float)(-value.asFloat()));
                }
                case Double: {
                    return JavaConstant.forDouble((double)(-value.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s) {
            if (s.isEmpty()) {
                return s;
            }
            FloatStamp stamp = (FloatStamp)s;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp);
            if (folded != null) {
                return folded;
            }
            return new FloatStamp(stamp.getBits(), -stamp.upperBound(), -stamp.lowerBound(), stamp.isNonNaN());
        }
    }, new ArithmeticOpTable.BinaryOp.Add(false, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            switch (a.getJavaKind()) {
                case Float: {
                    return JavaConstant.forFloat((float)(a.asFloat() + b.asFloat()));
                }
                case Double: {
                    return JavaConstant.forDouble((double)(a.asDouble() + b.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            switch (n.getJavaKind()) {
                case Float: {
                    return Float.compare(n.asFloat(), -0.0f) == 0;
                }
                case Double: {
                    return Double.compare(n.asDouble(), -0.0) == 0;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }, new ArithmeticOpTable.BinaryOp.Sub(false, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            switch (a.getJavaKind()) {
                case Float: {
                    return JavaConstant.forFloat((float)(a.asFloat() - b.asFloat()));
                }
                case Double: {
                    return JavaConstant.forDouble((double)(a.asDouble() - b.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            switch (n.getJavaKind()) {
                case Float: {
                    return Float.compare(n.asFloat(), 0.0f) == 0;
                }
                case Double: {
                    return Double.compare(n.asDouble(), 0.0) == 0;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }, new ArithmeticOpTable.BinaryOp.Mul(false, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            switch (a.getJavaKind()) {
                case Float: {
                    return JavaConstant.forFloat((float)(a.asFloat() * b.asFloat()));
                }
                case Double: {
                    return JavaConstant.forDouble((double)(a.asDouble() * b.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            switch (n.getJavaKind()) {
                case Float: {
                    return Float.compare(n.asFloat(), 1.0f) == 0;
                }
                case Double: {
                    return Double.compare(n.asDouble(), 1.0) == 0;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }, null, null, new ArithmeticOpTable.BinaryOp.Div(false, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            switch (a.getJavaKind()) {
                case Float: {
                    float floatDivisor = b.asFloat();
                    return floatDivisor == 0.0f ? null : JavaConstant.forFloat((float)(a.asFloat() / floatDivisor));
                }
                case Double: {
                    double doubleDivisor = b.asDouble();
                    return doubleDivisor == 0.0 ? null : JavaConstant.forDouble((double)(a.asDouble() / doubleDivisor));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant value) {
            PrimitiveConstant n = (PrimitiveConstant)value;
            switch (n.getJavaKind()) {
                case Float: {
                    return Float.compare(n.asFloat(), 1.0f) == 0;
                }
                case Double: {
                    return Double.compare(n.asDouble(), 1.0) == 0;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }, new ArithmeticOpTable.BinaryOp.Rem(false, false){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            switch (a.getJavaKind()) {
                case Float: {
                    return JavaConstant.forFloat((float)(a.asFloat() % b.asFloat()));
                }
                case Double: {
                    return JavaConstant.forDouble((double)(a.asDouble() % b.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }
    }, new ArithmeticOpTable.UnaryOp.Not(){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            switch (value.getJavaKind()) {
                case Float: {
                    int f = Float.floatToRawIntBits(value.asFloat());
                    return JavaConstant.forFloat((float)Float.intBitsToFloat(~f));
                }
                case Double: {
                    long d = Double.doubleToRawLongBits(value.asDouble());
                    return JavaConstant.forDouble((double)Double.longBitsToDouble(d ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s) {
            FloatStamp result;
            Constant folded;
            if (s.isEmpty()) {
                return s;
            }
            FloatStamp stamp = (FloatStamp)s;
            JavaConstant constant = stamp.asConstant();
            if (constant != null && (folded = this.foldConstant((Constant)constant)) != null && (result = FloatStamp.stampForConstant(folded)) != null && result.isConstant()) {
                return result;
            }
            return s.unrestricted();
        }
    }, new ArithmeticOpTable.BinaryOp.And(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            switch (a.getJavaKind()) {
                case Float: {
                    int fa = Float.floatToRawIntBits(a.asFloat());
                    int fb = Float.floatToRawIntBits(b.asFloat());
                    return JavaConstant.forFloat((float)Float.intBitsToFloat(fa & fb));
                }
                case Double: {
                    long da = Double.doubleToRawLongBits(a.asDouble());
                    long db = Double.doubleToRawLongBits(b.asDouble());
                    return JavaConstant.forDouble((double)Double.longBitsToDouble(da & db));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant n) {
            PrimitiveConstant value = (PrimitiveConstant)n;
            switch (value.getJavaKind()) {
                case Float: {
                    return Float.floatToRawIntBits(value.asFloat()) == -1;
                }
                case Double: {
                    return Double.doubleToRawLongBits(value.asDouble()) == -1L;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }, new ArithmeticOpTable.BinaryOp.Or(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            switch (a.getJavaKind()) {
                case Float: {
                    int fa = Float.floatToRawIntBits(a.asFloat());
                    int fb = Float.floatToRawIntBits(b.asFloat());
                    float floatOr = Float.intBitsToFloat(fa | fb);
                    assert ((fa | fb) == Float.floatToRawIntBits(floatOr));
                    return JavaConstant.forFloat((float)floatOr);
                }
                case Double: {
                    long da = Double.doubleToRawLongBits(a.asDouble());
                    long db = Double.doubleToRawLongBits(b.asDouble());
                    return JavaConstant.forDouble((double)Double.longBitsToDouble(da | db));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant n) {
            PrimitiveConstant value = (PrimitiveConstant)n;
            switch (value.getJavaKind()) {
                case Float: {
                    return Float.floatToRawIntBits(value.asFloat()) == 0;
                }
                case Double: {
                    return Double.doubleToRawLongBits(value.asDouble()) == 0L;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }, new ArithmeticOpTable.BinaryOp.Xor(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            switch (a.getJavaKind()) {
                case Float: {
                    int fa = Float.floatToRawIntBits(a.asFloat());
                    int fb = Float.floatToRawIntBits(b.asFloat());
                    return JavaConstant.forFloat((float)Float.intBitsToFloat(fa ^ fb));
                }
                case Double: {
                    long da = Double.doubleToRawLongBits(a.asDouble());
                    long db = Double.doubleToRawLongBits(b.asDouble());
                    return JavaConstant.forDouble((double)Double.longBitsToDouble(da ^ db));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return stamp1.unrestricted();
        }

        @Override
        public boolean isNeutral(Constant n) {
            PrimitiveConstant value = (PrimitiveConstant)n;
            switch (value.getJavaKind()) {
                case Float: {
                    return Float.floatToRawIntBits(value.asFloat()) == 0;
                }
                case Double: {
                    return Double.doubleToRawLongBits(value.asDouble()) == 0L;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }, null, null, null, new ArithmeticOpTable.UnaryOp.Abs(){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            switch (value.getJavaKind()) {
                case Float: {
                    return JavaConstant.forFloat((float)Math.abs(value.asFloat()));
                }
                case Double: {
                    return JavaConstant.forDouble((double)Math.abs(value.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s) {
            if (s.isEmpty()) {
                return s;
            }
            FloatStamp stamp = (FloatStamp)s;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp);
            if (folded != null) {
                return folded;
            }
            if (stamp.isNaN()) {
                return stamp;
            }
            return new FloatStamp(stamp.getBits(), 0.0, Math.max(-stamp.lowerBound(), stamp.upperBound()), stamp.isNonNaN());
        }
    }, new ArithmeticOpTable.UnaryOp.Sqrt(){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            switch (value.getJavaKind()) {
                case Float: {
                    return JavaConstant.forFloat((float)((float)Math.sqrt(value.asFloat())));
                }
                case Double: {
                    return JavaConstant.forDouble((double)Math.sqrt(value.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s) {
            if (s.isEmpty()) {
                return s;
            }
            FloatStamp stamp = (FloatStamp)s;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp);
            if (folded != null) {
                return folded;
            }
            return s.unrestricted();
        }
    }, null, null, null, new ArithmeticOpTable.BinaryOp.Max(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            switch (a.getJavaKind()) {
                case Float: {
                    return JavaConstant.forFloat((float)Math.max(a.asFloat(), b.asFloat()));
                }
                case Double: {
                    return JavaConstant.forDouble((double)Math.max(a.asDouble(), b.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return new FloatStamp(stamp1.getBits(), Math.max(stamp1.lowerBound, stamp2.lowerBound), Math.max(stamp1.upperBound, stamp2.upperBound), false);
        }

        @Override
        public boolean isNeutral(Constant n) {
            PrimitiveConstant value = (PrimitiveConstant)n;
            switch (value.getJavaKind()) {
                case Float: {
                    return Float.compare(value.asFloat(), Float.NEGATIVE_INFINITY) == 0;
                }
                case Double: {
                    return Double.compare(value.asDouble(), Double.NEGATIVE_INFINITY) == 0;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }, new ArithmeticOpTable.BinaryOp.Min(true, true){

        @Override
        public Constant foldConstant(Constant const1, Constant const2) {
            PrimitiveConstant a = (PrimitiveConstant)const1;
            PrimitiveConstant b = (PrimitiveConstant)const2;
            assert (a.getJavaKind() == b.getJavaKind());
            switch (a.getJavaKind()) {
                case Float: {
                    return JavaConstant.forFloat((float)Math.min(a.asFloat(), b.asFloat()));
                }
                case Double: {
                    return JavaConstant.forDouble((double)Math.min(a.asDouble(), b.asDouble()));
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public Stamp foldStamp(Stamp s1, Stamp s2) {
            if (s1.isEmpty()) {
                return s1;
            }
            if (s2.isEmpty()) {
                return s2;
            }
            FloatStamp stamp1 = (FloatStamp)s1;
            FloatStamp stamp2 = (FloatStamp)s2;
            Stamp folded = FloatStamp.maybeFoldConstant(this, stamp1, stamp2);
            if (folded != null) {
                return folded;
            }
            return new FloatStamp(stamp1.getBits(), Math.min(stamp1.lowerBound, stamp2.lowerBound), Math.min(stamp1.upperBound, stamp2.upperBound), false);
        }

        @Override
        public boolean isNeutral(Constant n) {
            PrimitiveConstant value = (PrimitiveConstant)n;
            switch (value.getJavaKind()) {
                case Float: {
                    return Float.compare(value.asFloat(), Float.POSITIVE_INFINITY) == 0;
                }
                case Double: {
                    return Double.compare(value.asDouble(), Double.POSITIVE_INFINITY) == 0;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }, new ArithmeticOpTable.ReinterpretOp(){

        @Override
        public Constant foldConstant(Stamp resultStamp, Constant constant) {
            return ReinterpretUtils.foldConstant(resultStamp, constant);
        }

        @Override
        public Stamp foldStamp(Stamp resultStamp, Stamp input) {
            if (input.isEmpty()) {
                return resultStamp.empty();
            }
            if (resultStamp instanceof IntegerStamp && input instanceof FloatStamp) {
                return ReinterpretUtils.floatToInt((FloatStamp)input);
            }
            return resultStamp;
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.F2I){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forInt((int)((int)value.asFloat()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Int);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 32);
            boolean mustHaveZero = !floatStamp.isNonNaN();
            int lowerBound = (int)floatStamp.lowerBound();
            int upperBound = (int)floatStamp.upperBound();
            if (mustHaveZero) {
                if (lowerBound > 0) {
                    lowerBound = 0;
                } else if (upperBound < 0) {
                    upperBound = 0;
                }
            }
            return StampFactory.forInteger(JavaKind.Int, (long)lowerBound, (long)upperBound);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.F2L){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forLong((long)((long)value.asFloat()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Long);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 32);
            boolean mustHaveZero = !floatStamp.isNonNaN();
            long lowerBound = (long)floatStamp.lowerBound();
            long upperBound = (long)floatStamp.upperBound();
            if (mustHaveZero) {
                if (lowerBound > 0L) {
                    lowerBound = 0L;
                } else if (upperBound < 0L) {
                    upperBound = 0L;
                }
            }
            return StampFactory.forInteger(JavaKind.Long, lowerBound, upperBound);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.D2I){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forInt((int)((int)value.asDouble()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Int);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 64);
            boolean mustHaveZero = !floatStamp.isNonNaN();
            int lowerBound = (int)floatStamp.lowerBound();
            int upperBound = (int)floatStamp.upperBound();
            if (mustHaveZero) {
                if (lowerBound > 0) {
                    lowerBound = 0;
                } else if (upperBound < 0) {
                    upperBound = 0;
                }
            }
            return StampFactory.forInteger(JavaKind.Int, (long)lowerBound, (long)upperBound);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.D2L){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forLong((long)((long)value.asDouble()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Long);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 64);
            boolean mustHaveZero = !floatStamp.isNonNaN();
            long lowerBound = (long)floatStamp.lowerBound();
            long upperBound = (long)floatStamp.upperBound();
            if (mustHaveZero) {
                if (lowerBound > 0L) {
                    lowerBound = 0L;
                } else if (upperBound < 0L) {
                    upperBound = 0L;
                }
            }
            return StampFactory.forInteger(JavaKind.Long, lowerBound, upperBound);
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.F2D){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forDouble((double)value.asFloat());
        }

        @Override
        public Stamp foldStamp(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Double);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 32);
            return StampFactory.forFloat(JavaKind.Double, floatStamp.lowerBound(), floatStamp.upperBound(), floatStamp.isNonNaN());
        }
    }, new ArithmeticOpTable.FloatConvertOp(FloatConvert.D2F){

        @Override
        public Constant foldConstant(Constant c) {
            PrimitiveConstant value = (PrimitiveConstant)c;
            return JavaConstant.forFloat((float)((float)value.asDouble()));
        }

        @Override
        public Stamp foldStamp(Stamp stamp) {
            if (stamp.isEmpty()) {
                return StampFactory.empty(JavaKind.Float);
            }
            FloatStamp floatStamp = (FloatStamp)stamp;
            assert (floatStamp.getBits() == 64);
            return StampFactory.forFloat(JavaKind.Float, (float)floatStamp.lowerBound(), (float)floatStamp.upperBound(), floatStamp.isNonNaN());
        }
    });

    protected FloatStamp(int bits) {
        this(bits, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false);
    }

    public FloatStamp(int bits, double lowerBound, double upperBound, boolean nonNaN) {
        super(bits, OPS);
        assert (bits == 64 || bits == 32 && (Double.isNaN(lowerBound) || (double)((float)lowerBound) == lowerBound) && (Double.isNaN(upperBound) || (double)((float)upperBound) == upperBound));
        assert (Double.isNaN(lowerBound) == Double.isNaN(upperBound));
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.nonNaN = nonNaN;
    }

    @Override
    public Stamp unrestricted() {
        return new FloatStamp(this.getBits());
    }

    @Override
    public Stamp empty() {
        return new FloatStamp(this.getBits(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, true);
    }

    @Override
    public Stamp constant(Constant c, MetaAccessProvider meta) {
        JavaConstant jc = (JavaConstant)c;
        assert (jc.getJavaKind().isNumericFloat() && jc.getJavaKind().getBitCount() == this.getBits());
        return StampFactory.forConstant(jc);
    }

    @Override
    public SerializableConstant deserialize(ByteBuffer buffer) {
        switch (this.getBits()) {
            case 32: {
                return JavaConstant.forFloat((float)buffer.getFloat());
            }
            case 64: {
                return JavaConstant.forDouble((double)buffer.getDouble());
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public boolean hasValues() {
        return this.lowerBound <= this.upperBound || !this.nonNaN;
    }

    @Override
    public JavaKind getStackKind() {
        if (this.getBits() > 32) {
            return JavaKind.Double;
        }
        return JavaKind.Float;
    }

    @Override
    public LIRKind getLIRKind(LIRKindTool tool) {
        return tool.getFloatingKind(this.getBits());
    }

    @Override
    public ResolvedJavaType javaType(MetaAccessProvider metaAccess) {
        switch (this.getBits()) {
            case 32: {
                return metaAccess.lookupJavaType(Float.TYPE);
            }
            case 64: {
                return metaAccess.lookupJavaType(Double.TYPE);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public double lowerBound() {
        return this.lowerBound;
    }

    public double upperBound() {
        return this.upperBound;
    }

    public boolean isNonNaN() {
        return this.nonNaN;
    }

    public boolean canBeNaN() {
        return !this.nonNaN;
    }

    public boolean isNaN() {
        return Double.isNaN(this.lowerBound);
    }

    @Override
    public boolean isUnrestricted() {
        return this.lowerBound == Double.NEGATIVE_INFINITY && this.upperBound == Double.POSITIVE_INFINITY && !this.nonNaN;
    }

    public boolean contains(double value) {
        if (Double.isNaN(value)) {
            return !this.nonNaN;
        }
        return value >= this.lowerBound && value <= this.upperBound;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('f');
        str.append(this.getBits());
        if (this.hasValues()) {
            str.append(this.nonNaN ? "!" : "");
            if (this.lowerBound == this.upperBound) {
                str.append(" [").append(this.lowerBound).append(']');
            } else if (this.lowerBound != Double.NEGATIVE_INFINITY || this.upperBound != Double.POSITIVE_INFINITY) {
                str.append(" [").append(this.lowerBound).append(" - ").append(this.upperBound).append(']');
            }
        } else {
            str.append("<empty>");
        }
        return str.toString();
    }

    private static double meetBounds(double a, double b, DoubleBinaryOperator op) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return op.applyAsDouble(a, b);
    }

    @Override
    public Stamp meet(Stamp otherStamp) {
        boolean meetNonNaN;
        if (otherStamp == this) {
            return this;
        }
        if (this.isEmpty()) {
            return otherStamp;
        }
        if (otherStamp.isEmpty()) {
            return this;
        }
        FloatStamp other = (FloatStamp)otherStamp;
        assert (this.getBits() == other.getBits());
        double meetUpperBound = FloatStamp.meetBounds(this.upperBound, other.upperBound, Math::max);
        double meetLowerBound = FloatStamp.meetBounds(this.lowerBound, other.lowerBound, Math::min);
        boolean bl = meetNonNaN = this.nonNaN && other.nonNaN;
        if (Double.compare(meetLowerBound, this.lowerBound) == 0 && Double.compare(meetUpperBound, this.upperBound) == 0 && meetNonNaN == this.nonNaN) {
            return this;
        }
        if (Double.compare(meetLowerBound, other.lowerBound) == 0 && Double.compare(meetUpperBound, other.upperBound) == 0 && meetNonNaN == other.nonNaN) {
            return other;
        }
        return new FloatStamp(this.getBits(), meetLowerBound, meetUpperBound, meetNonNaN);
    }

    @Override
    public Stamp join(Stamp otherStamp) {
        boolean joinNonNaN;
        if (otherStamp == this) {
            return this;
        }
        FloatStamp other = (FloatStamp)otherStamp;
        assert (this.getBits() == other.getBits());
        double joinUpperBound = Math.min(this.upperBound, other.upperBound);
        double joinLowerBound = Math.max(this.lowerBound, other.lowerBound);
        boolean bl = joinNonNaN = this.nonNaN || other.nonNaN;
        if (Double.compare(joinLowerBound, this.lowerBound) == 0 && Double.compare(joinUpperBound, this.upperBound) == 0 && joinNonNaN == this.nonNaN) {
            return this;
        }
        if (Double.compare(joinLowerBound, other.lowerBound) == 0 && Double.compare(joinUpperBound, other.upperBound) == 0 && joinNonNaN == other.nonNaN) {
            return other;
        }
        return new FloatStamp(this.getBits(), joinLowerBound, joinUpperBound, joinNonNaN);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        long temp = Double.doubleToLongBits(this.lowerBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.nonNaN ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.upperBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean isCompatible(Stamp stamp) {
        if (this == stamp) {
            return true;
        }
        if (stamp instanceof FloatStamp) {
            FloatStamp other = (FloatStamp)stamp;
            return this.getBits() == other.getBits();
        }
        return false;
    }

    @Override
    public boolean isCompatible(Constant constant) {
        if (constant instanceof PrimitiveConstant) {
            PrimitiveConstant prim = (PrimitiveConstant)constant;
            JavaKind kind = prim.getJavaKind();
            return kind.isNumericFloat() && kind.getBitCount() == this.getBits();
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass() || !super.equals(obj)) {
            return false;
        }
        FloatStamp other = (FloatStamp)obj;
        if (Double.doubleToLongBits(this.lowerBound) != Double.doubleToLongBits(other.lowerBound)) {
            return false;
        }
        if (Double.doubleToLongBits(this.upperBound) != Double.doubleToLongBits(other.upperBound)) {
            return false;
        }
        if (this.nonNaN != other.nonNaN) {
            return false;
        }
        return super.equals(other);
    }

    public JavaConstant asConstant() {
        if (this.isConstant()) {
            switch (this.getBits()) {
                case 32: {
                    return JavaConstant.forFloat((float)((float)this.lowerBound));
                }
                case 64: {
                    return JavaConstant.forDouble((double)this.lowerBound);
                }
            }
        }
        return null;
    }

    private boolean isConstant() {
        return Double.compare(this.lowerBound, this.upperBound) == 0 && this.nonNaN && this.lowerBound != 0.0;
    }

    private static FloatStamp stampForConstant(Constant constant) {
        FloatStamp result;
        PrimitiveConstant value = (PrimitiveConstant)constant;
        switch (value.getJavaKind()) {
            case Float: {
                if (Float.isNaN(value.asFloat())) {
                    result = new FloatStamp(32, Double.NaN, Double.NaN, false);
                    break;
                }
                result = new FloatStamp(32, value.asFloat(), value.asFloat(), true);
                break;
            }
            case Double: {
                if (Double.isNaN(value.asDouble())) {
                    result = new FloatStamp(64, Double.NaN, Double.NaN, false);
                    break;
                }
                result = new FloatStamp(64, value.asDouble(), value.asDouble(), true);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        if (result.isConstant()) {
            return result;
        }
        return null;
    }

    private static Stamp maybeFoldConstant(ArithmeticOpTable.UnaryOp<?> op, FloatStamp stamp) {
        JavaConstant constant;
        Constant folded;
        if (stamp.isConstant() && (folded = op.foldConstant((Constant)(constant = stamp.asConstant()))) != null) {
            return FloatStamp.stampForConstant(folded);
        }
        return null;
    }

    private static Stamp maybeFoldConstant(ArithmeticOpTable.BinaryOp<?> op, FloatStamp stamp1, FloatStamp stamp2) {
        FloatStamp stamp;
        JavaConstant constant2;
        JavaConstant constant1;
        Constant folded;
        if (stamp1.isConstant() && stamp2.isConstant() && (folded = op.foldConstant((Constant)(constant1 = stamp1.asConstant()), (Constant)(constant2 = stamp2.asConstant()))) != null && (stamp = FloatStamp.stampForConstant(folded)) != null && stamp.isConstant()) {
            assert (stamp.asConstant().equals(folded));
            return stamp;
        }
        return null;
    }
}

