/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

final class UnalignedUnsafeArrayTypeWriter
extends UnsafeArrayTypeWriter {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();

    UnalignedUnsafeArrayTypeWriter() {
    }

    @Override
    protected void putS2(long value, UnsafeArrayTypeWriter.Chunk chunk, long offset) {
        UNSAFE.putShort(chunk.data, offset, TypeConversion.asS2(value));
    }

    @Override
    protected void putS4(long value, UnsafeArrayTypeWriter.Chunk chunk, long offset) {
        UNSAFE.putInt(chunk.data, offset, TypeConversion.asS4(value));
    }

    @Override
    protected void putS8(long value, UnsafeArrayTypeWriter.Chunk chunk, long offset) {
        UNSAFE.putLong(chunk.data, offset, value);
    }
}

