/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.graalvm.compiler.debug.PathUtilitiesProvider;

public class StandardPathUtilitiesProvider
implements PathUtilitiesProvider {
    public static final String DIAGNOSTIC_OUTPUT_DIRECTORY_MESSAGE_FORMAT = "Graal diagnostic output saved in '%s'";
    public static final String DIAGNOSTIC_OUTPUT_DIRECTORY_MESSAGE_REGEXP = "Graal diagnostic output saved in '(?<filename>[^']+)'";

    @Override
    public String createDirectories(String path) throws IOException {
        Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        return path;
    }

    @Override
    public String getPath(String first, String ... more) {
        Path res = Paths.get(first, new String[0]);
        for (String e : more) {
            res = res.resolve(e);
        }
        return res.toString();
    }

    @Override
    public String getAbsolutePath(String path) {
        return new File(path).getAbsolutePath();
    }

    @Override
    public OutputStream openOutputStream(String path, boolean append) throws IOException {
        return new FileOutputStream(path, append);
    }

    @Override
    public InputStream openInputStream(String path) throws IOException {
        return new FileInputStream(path);
    }

    @Override
    public boolean exists(String path) {
        return new File(path).exists();
    }

    @Override
    public String sanitizeFileName(String name) {
        try {
            Path path = Paths.get(name, new String[0]);
            if (path.getNameCount() == 0) {
                return name;
            }
        }
        catch (InvalidPathException path) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != File.separatorChar && c != ' ' && !Character.isISOControl(c)) {
                try {
                    Paths.get(String.valueOf(c), new String[0]);
                    buf.append(c);
                    continue;
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
            buf.append('_');
        }
        return buf.toString();
    }

    @Override
    public String createFile(String path) throws IOException {
        Files.createFile(Paths.get(path, new String[0]), new FileAttribute[0]);
        return path;
    }

    @Override
    public boolean isDirectory(String path, boolean followLinks) {
        if (followLinks) {
            return Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0]);
        }
        return Files.isDirectory(Paths.get(path, new String[0]), LinkOption.NOFOLLOW_LINKS);
    }

    @Override
    public void deleteFile(String path) throws IOException {
        Files.delete(Paths.get(path, new String[0]));
    }

    @Override
    public String getParent(String path) {
        return new File(path).getParent();
    }

    @Override
    public WritableByteChannel openFileChannel(String path, OpenOption ... options) throws IOException {
        return FileChannel.open(Paths.get(path, new String[0]), options);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String archiveAndDelete(String directory, String zip) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

