/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.graalvm.compiler.debug.LogStream;
import org.graalvm.compiler.debug.TTYStreamProvider;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class TTY {
    public static final PrintStream out;
    private static final ThreadLocal<LogStream> log;

    public static boolean isSuppressed() {
        return log.get() == LogStream.SINK;
    }

    public static LogStream out() {
        return log.get();
    }

    public static void print(String s) {
        TTY.out().print(s);
    }

    public static void print(int i) {
        TTY.out().print(i);
    }

    public static void print(long i) {
        TTY.out().print(i);
    }

    public static void print(char c) {
        TTY.out().print(c);
    }

    public static void print(boolean b) {
        TTY.out().print(b);
    }

    public static void print(double d) {
        TTY.out().print(d);
    }

    public static void print(float f) {
        TTY.out().print(f);
    }

    public static void println(String s) {
        TTY.out().println(s);
    }

    public static void println() {
        TTY.out().println();
    }

    public static void println(int i) {
        TTY.out().println(i);
    }

    public static void println(long l) {
        TTY.out().println(l);
    }

    public static void println(char c) {
        TTY.out().println(c);
    }

    public static void println(boolean b) {
        TTY.out().println(b);
    }

    public static void println(double d) {
        TTY.out().println(d);
    }

    public static void println(float f) {
        TTY.out().println(f);
    }

    public static void printf(String format, Object ... args) {
        TTY.out().printf(format, args);
    }

    public static void println(String format, Object ... args) {
        TTY.out().printf(format + "%n", args);
    }

    public static void fillTo(int i) {
        TTY.out().fillTo(i, ' ');
    }

    public static void printFields(Class<?> javaClass) {
        String className = javaClass.getSimpleName();
        TTY.println(className + " {");
        for (Field field : javaClass.getFields()) {
            TTY.printField(field, false);
        }
        TTY.println("}");
    }

    public static void printField(Field field, boolean tabbed) {
        String fieldName = String.format("%35s", field.getName());
        try {
            String postfix;
            String prefix = tabbed ? "" : "    " + fieldName + " = ";
            String string = postfix = tabbed ? "\t" : "\n";
            if (field.getType() == Integer.TYPE) {
                TTY.print(prefix + field.getInt(null) + postfix);
            } else if (field.getType() == Boolean.TYPE) {
                TTY.print(prefix + field.getBoolean(null) + postfix);
            } else if (field.getType() == Float.TYPE) {
                TTY.print(prefix + field.getFloat(null) + postfix);
            } else if (field.getType() == String.class) {
                TTY.print(prefix + field.get(null) + postfix);
            } else if (field.getType() == Map.class) {
                Map m = (Map)field.get(null);
                TTY.print(prefix + TTY.printMap(m) + postfix);
            } else {
                TTY.print(prefix + field.get(null) + postfix);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static String printMap(Map<?, ?> m) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>();
        for (Object obj : m.keySet()) {
            keys.add((String)obj);
        }
        Collections.sort(keys);
        for (String string : keys) {
            sb.append(string);
            sb.append("\t");
            sb.append(m.get(string));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void flush() {
        TTY.out().flush();
    }

    static {
        TTYStreamProvider p = GraalServices.loadSingle(TTYStreamProvider.class, false);
        out = p == null ? System.out : p.getStream();
        log = new ThreadLocal<LogStream>(){

            @Override
            protected LogStream initialValue() {
                return new LogStream(out);
            }
        };
    }

    public static class Filter
    implements AutoCloseable {
        private LogStream previous;
        private final Thread thread = Thread.currentThread();

        public Filter(String filter, Object object) {
            boolean suppressed = false;
            if (filter != null) {
                String input = object.toString();
                if (filter.startsWith("~")) {
                    suppressed = !Pattern.matches(filter.substring(1), input);
                } else {
                    boolean bl = suppressed = !input.contains(filter);
                }
                if (suppressed) {
                    this.previous = TTY.out();
                    log.set(LogStream.SINK);
                }
            }
        }

        public Filter() {
            this.previous = TTY.out();
            log.set(LogStream.SINK);
        }

        public Filter(LogStream newStream) {
            this.previous = TTY.out();
            log.set(newStream);
        }

        public void remove() {
            assert (this.thread == Thread.currentThread());
            if (this.previous != null) {
                log.set(this.previous);
            }
        }

        @Override
        public void close() {
            this.remove();
        }
    }
}

