/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.util.Iterator;
import java.util.Objects;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.bytecode.BytecodeDisassembler;
import org.graalvm.compiler.graph.SourceLanguagePosition;

public class NodeSourcePosition
extends BytecodePosition
implements Iterable<NodeSourcePosition> {
    private static final boolean STRICT_SOURCE_POSITION = Boolean.parseBoolean((String)Services.getSavedProperties().get("debug.graal.SourcePositionStrictChecks"));
    private static final boolean SOURCE_POSITION_BYTECODES = Boolean.parseBoolean((String)Services.getSavedProperties().get("debug.graal.SourcePositionDisassemble"));
    private final int hashCode;
    private final Marker marker;
    private final SourceLanguagePosition sourceLanguagePosition;

    public Marker getMarker() {
        return this.marker;
    }

    public NodeSourcePosition trim() {
        NodeSourcePosition lastMarker = null;
        for (NodeSourcePosition current = this; current != null; current = current.getCaller()) {
            if (current.marker == Marker.None) continue;
            lastMarker = current;
        }
        if (lastMarker == null) {
            return this;
        }
        return lastMarker.getCaller();
    }

    public ResolvedJavaMethod getRootMethod() {
        NodeSourcePosition cur = this;
        while (cur.getCaller() != null) {
            cur = cur.getCaller();
        }
        return cur.getMethod();
    }

    public boolean verifyRootMethod(ResolvedJavaMethod root) {
        ResolvedJavaMethod currentRoot = this.getRootMethod();
        assert (root.equals(currentRoot) || root.getName().equals(currentRoot.getName()) && root.getSignature().toMethodDescriptor().equals(currentRoot.getSignature().toMethodDescriptor()) && root.getDeclaringClass().getName().equals(currentRoot.getDeclaringClass().getName())) : root + " " + currentRoot;
        return true;
    }

    @Override
    public Iterator<NodeSourcePosition> iterator() {
        return new Iterator<NodeSourcePosition>(){
            private NodeSourcePosition currentPosition;
            {
                this.currentPosition = NodeSourcePosition.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPosition != null;
            }

            @Override
            public NodeSourcePosition next() {
                NodeSourcePosition current = this.currentPosition;
                this.currentPosition = this.currentPosition.getCaller();
                return current;
            }
        };
    }

    public NodeSourcePosition(NodeSourcePosition caller, ResolvedJavaMethod method, int bci) {
        this(caller, method, bci, Marker.None);
    }

    public NodeSourcePosition(NodeSourcePosition caller, ResolvedJavaMethod method, int bci, Marker marker) {
        this(null, caller, method, bci, marker);
    }

    public NodeSourcePosition(SourceLanguagePosition sourceLanguagePosition, NodeSourcePosition caller, ResolvedJavaMethod method, int bci) {
        this(sourceLanguagePosition, caller, method, bci, Marker.None);
    }

    public NodeSourcePosition(SourceLanguagePosition sourceLanguagePosition, NodeSourcePosition caller, ResolvedJavaMethod method, int bci, Marker marker) {
        super((BytecodePosition)caller, method, bci);
        this.hashCode = caller == null ? 31 * bci + method.hashCode() : caller.hashCode * 7 + 31 * bci + method.hashCode();
        this.marker = marker;
        this.sourceLanguagePosition = sourceLanguagePosition;
    }

    public static NodeSourcePosition placeholder(ResolvedJavaMethod method) {
        return new NodeSourcePosition(null, method, -6, Marker.Placeholder);
    }

    public static NodeSourcePosition placeholder(ResolvedJavaMethod method, int bci) {
        return new NodeSourcePosition(null, method, bci, Marker.Placeholder);
    }

    public boolean isPlaceholder() {
        return this.marker == Marker.Placeholder;
    }

    public static NodeSourcePosition substitution(ResolvedJavaMethod method) {
        return NodeSourcePosition.substitution(null, method, -6);
    }

    public static NodeSourcePosition substitution(ResolvedJavaMethod method, int bci) {
        return NodeSourcePosition.substitution(null, method, bci);
    }

    public static NodeSourcePosition substitution(NodeSourcePosition caller, ResolvedJavaMethod method) {
        return NodeSourcePosition.substitution(caller, method, -6);
    }

    public static NodeSourcePosition substitution(NodeSourcePosition caller, ResolvedJavaMethod method, int bci) {
        return new NodeSourcePosition(caller, method, bci, Marker.Substitution);
    }

    public boolean isSubstitution() {
        return this.marker == Marker.Substitution;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            NodeSourcePosition that = (NodeSourcePosition)obj;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            if (this.getBCI() == that.getBCI() && Objects.equals(this.getMethod(), that.getMethod()) && Objects.equals(this.getCaller(), that.getCaller()) && Objects.equals(this.sourceLanguagePosition, that.sourceLanguagePosition)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int depth() {
        int d = 0;
        for (NodeSourcePosition pos = this; pos != null; pos = pos.getCaller()) {
            ++d;
        }
        return d;
    }

    public SourceLanguagePosition getSourceLanguage() {
        return this.sourceLanguagePosition;
    }

    public NodeSourcePosition getCaller() {
        return (NodeSourcePosition)super.getCaller();
    }

    public NodeSourcePosition addCaller(SourceLanguagePosition newSourceLanguagePosition, NodeSourcePosition link) {
        return this.addCaller(newSourceLanguagePosition, link, false);
    }

    public NodeSourcePosition addCaller(NodeSourcePosition link) {
        return this.addCaller(null, link, false);
    }

    public NodeSourcePosition addCaller(NodeSourcePosition link, boolean isSubstitution) {
        return this.addCaller(null, link, isSubstitution);
    }

    public NodeSourcePosition addCaller(SourceLanguagePosition newSourceLanguagePosition, NodeSourcePosition link, boolean isSubstitution) {
        if (this.getCaller() == null) {
            if (this.isPlaceholder()) {
                return new NodeSourcePosition(newSourceLanguagePosition, link, this.getMethod(), 0);
            }
            assert (link == null || isSubstitution || NodeSourcePosition.verifyCaller(this, link)) : link;
            assert (!isSubstitution || this.marker == Marker.None);
            return new NodeSourcePosition(newSourceLanguagePosition, link, this.getMethod(), this.getBCI(), isSubstitution ? Marker.Substitution : Marker.None);
        }
        return new NodeSourcePosition(newSourceLanguagePosition, this.getCaller().addCaller(this.getSourceLanguage(), link, isSubstitution), this.getMethod(), this.getBCI(), this.marker);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        NodeSourcePosition pos = this;
        while (pos != null) {
            NodeSourcePosition.format(sb, pos);
            if (pos.sourceLanguagePosition != null) {
                sb.append(" source=" + pos.sourceLanguagePosition.toShortString());
            }
            if ((pos = pos.getCaller()) == null) continue;
            sb.append(CodeUtil.NEW_LINE);
        }
        return sb.toString();
    }

    private static void format(StringBuilder sb, NodeSourcePosition pos) {
        String disassembly;
        MetaUtil.appendLocation((StringBuilder)sb.append("at "), (ResolvedJavaMethod)pos.getMethod(), (int)pos.getBCI());
        if (pos.marker != Marker.None) {
            sb.append(" " + (Object)((Object)pos.marker));
        }
        if (SOURCE_POSITION_BYTECODES && (disassembly = BytecodeDisassembler.disassembleOne(pos.getMethod(), pos.getBCI())) != null && disassembly.length() > 0) {
            sb.append(" // ");
            sb.append(disassembly);
        }
    }

    String shallowToString() {
        StringBuilder sb = new StringBuilder(100);
        NodeSourcePosition.format(sb, this);
        return sb.toString();
    }

    public boolean verify() {
        NodeSourcePosition current = this;
        for (NodeSourcePosition caller = this.getCaller(); caller != null; caller = caller.getCaller()) {
            assert (NodeSourcePosition.verifyCaller(current, caller)) : current;
            current = caller;
        }
        return true;
    }

    private static boolean verifyCaller(NodeSourcePosition current, NodeSourcePosition caller) {
        if (!STRICT_SOURCE_POSITION) {
            return true;
        }
        if (BytecodeFrame.isPlaceholderBci((int)caller.getBCI())) {
            return true;
        }
        int opcode = BytecodeDisassembler.getBytecodeAt(caller.getMethod(), caller.getBCI());
        JavaMethod method = BytecodeDisassembler.getInvokedMethodAt(caller.getMethod(), caller.getBCI());
        assert (method == null || method.getName().equals(current.getMethod().getName()) && method.getSignature().equals(current.getMethod().getSignature()) || caller.getMethod().getName().equals("linkToTargetMethod") || opcode == 186 || caller.getMethod().getDeclaringClass().getName().startsWith("Ljava/lang/invoke/LambdaForm$") || current.getMethod().getName().equals("callInlined")) : "expected " + method + " but found " + current.getMethod();
        return true;
    }

    static enum Marker {
        None,
        Placeholder,
        Substitution;

    }
}

