/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.code.site.Mark;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.code.site.Site;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotCompiledCode;
import jdk.vm.ci.hotspot.HotSpotCompiledNmethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.code.SourceMapping;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.util.CollectionsUtil;

public class HotSpotCompiledCodeBuilder {
    public static HotSpotCompiledCode createCompiledCode(CodeCacheProvider codeCache, ResolvedJavaMethod method, HotSpotCompilationRequest compRequest, CompilationResult compResult, OptionValues options) {
        String name = compResult.getName();
        byte[] targetCode = compResult.getTargetCode();
        int targetCodeSize = compResult.getTargetCodeSize();
        Site[] sites = HotSpotCompiledCodeBuilder.getSortedSites(compResult, options, codeCache.shouldDebugNonSafepoints() && method != null);
        assert (HotSpotCompiledCodeBuilder.verifySiteMethods(sites));
        Assumptions.Assumption[] assumptions = compResult.getAssumptions();
        ResolvedJavaMethod[] methods = HotSpotCompiledCodeBuilder.filterMethods(compResult.getMethods());
        List<CompilationResult.CodeAnnotation> annotations = compResult.getCodeAnnotations();
        HotSpotCompiledCode.Comment[] comments = new HotSpotCompiledCode.Comment[annotations.size()];
        if (!annotations.isEmpty()) {
            for (int i = 0; i < comments.length; ++i) {
                String text;
                CompilationResult.CodeAnnotation annotation = annotations.get(i);
                if (annotation instanceof CompilationResult.CodeComment) {
                    CompilationResult.CodeComment codeComment = (CompilationResult.CodeComment)annotation;
                    text = codeComment.value;
                } else if (annotation instanceof CompilationResult.JumpTable) {
                    CompilationResult.JumpTable jumpTable = (CompilationResult.JumpTable)annotation;
                    text = "JumpTable [" + jumpTable.low + " .. " + jumpTable.high + "]";
                } else {
                    text = annotation.toString();
                }
                comments[i] = new HotSpotCompiledCode.Comment(annotation.getPosition(), text);
            }
        }
        DataSection data = compResult.getDataSection();
        byte[] dataSection = new byte[data.getSectionSize()];
        ByteBuffer buffer = ByteBuffer.wrap(dataSection).order(ByteOrder.nativeOrder());
        ArrayList patches = new ArrayList();
        data.buildDataSection(buffer, (position, vmConstant) -> patches.add(new DataPatch(position, (Reference)new ConstantReference(vmConstant))));
        int dataSectionAlignment = data.getSectionAlignment();
        DataPatch[] dataSectionPatches = patches.toArray(new DataPatch[patches.size()]);
        int totalFrameSize = compResult.getTotalFrameSize();
        StackSlot customStackArea = compResult.getCustomStackArea();
        boolean isImmutablePIC = false;
        if (method instanceof HotSpotResolvedJavaMethod) {
            long jvmciCompileState;
            int id;
            HotSpotResolvedJavaMethod hsMethod = (HotSpotResolvedJavaMethod)method;
            int entryBCI = compResult.getEntryBCI();
            boolean hasUnsafeAccess = compResult.hasUnsafeAccess();
            if (compRequest != null) {
                id = compRequest.getId();
                jvmciCompileState = compRequest.getJvmciEnv();
            } else {
                id = hsMethod.allocateCompileId(entryBCI);
                jvmciCompileState = 0L;
            }
            return new HotSpotCompiledNmethod(name, targetCode, targetCodeSize, sites, assumptions, methods, comments, dataSection, dataSectionAlignment, dataSectionPatches, isImmutablePIC, totalFrameSize, customStackArea, hsMethod, entryBCI, id, jvmciCompileState, hasUnsafeAccess);
        }
        return new HotSpotCompiledCode(name, targetCode, targetCodeSize, sites, assumptions, methods, comments, dataSection, dataSectionAlignment, dataSectionPatches, isImmutablePIC, totalFrameSize, customStackArea);
    }

    private static boolean verifySiteMethods(Site[] sites) {
        for (Site site : sites) {
            if (!(site instanceof Infopoint)) continue;
            Infopoint infopoint = (Infopoint)site;
            if (infopoint.debugInfo == null) continue;
            for (BytecodeFrame frame = infopoint.debugInfo.frame(); frame != null; frame = frame.caller()) {
                assert (frame.getMethod() instanceof HotSpotResolvedJavaMethod);
            }
        }
        return true;
    }

    private static ResolvedJavaMethod[] filterMethods(ResolvedJavaMethod[] methods) {
        if (methods != null) {
            ArrayList<ResolvedJavaMethod> hsMethods = null;
            int i = 0;
            while (i < methods.length) {
                ResolvedJavaMethod method = methods[i];
                if (hsMethods != null) {
                    if (method instanceof HotSpotResolvedJavaMethod) {
                        hsMethods.add(method);
                    }
                } else if (!(method instanceof HotSpotResolvedJavaMethod)) {
                    hsMethods = new ArrayList<ResolvedJavaMethod>();
                    i = 0;
                    continue;
                }
                ++i;
            }
            if (hsMethods != null) {
                return hsMethods.toArray(new ResolvedJavaMethod[hsMethods.size()]);
            }
        }
        return methods;
    }

    private static List<Mark> getTranslatedMarks(List<CompilationResult.CodeMark> codeMarks) {
        if (codeMarks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Mark> translated = new ArrayList<Mark>(codeMarks.size());
        for (CompilationResult.CodeMark m : codeMarks) {
            translated.add(new Mark(m.pcOffset, m.id.getId()));
        }
        return Collections.unmodifiableList(translated);
    }

    /*
     * WARNING - void declaration
     */
    private static Site[] getSortedSites(CompilationResult target, OptionValues options, boolean includeSourceInfo) {
        ArrayList<Object> sites = new ArrayList<Object>(target.getExceptionHandlers().size() + target.getInfopoints().size() + target.getDataPatches().size() + target.getMarks().size() + target.getSourceMappings().size());
        sites.addAll(target.getExceptionHandlers());
        sites.addAll(target.getInfopoints());
        sites.addAll(target.getDataPatches());
        sites.addAll(HotSpotCompiledCodeBuilder.getTranslatedMarks(target.getMarks()));
        if (includeSourceInfo) {
            ArrayList<SourceMapping> sourceMappings = new ArrayList<SourceMapping>();
            ListIterator<SourceMapping> sourceMappingListIterator = target.getSourceMappings().listIterator();
            if (sourceMappingListIterator.hasNext()) {
                SourceMapping currentSource = sourceMappingListIterator.next();
                NodeSourcePosition sourcePosition = currentSource.getSourcePosition();
                if (!sourcePosition.isPlaceholder() && !sourcePosition.isSubstitution()) {
                    sourceMappings.add(currentSource);
                }
                while (sourceMappingListIterator.hasNext()) {
                    SourceMapping sourceMapping = sourceMappingListIterator.next();
                    assert (currentSource.getStartOffset() <= sourceMapping.getStartOffset()) : "Must be presorted";
                    currentSource = sourceMapping;
                    sourcePosition = currentSource.getSourcePosition();
                    if (sourcePosition.isPlaceholder() || sourcePosition.isSubstitution()) continue;
                    sourceMappings.add(currentSource);
                }
            }
            sites.sort(new SiteComparator());
            ListIterator siteListIterator = sites.listIterator();
            sourceMappingListIterator = sourceMappings.listIterator();
            ArrayList<Infopoint> sourcePositionSites = new ArrayList<Infopoint>();
            Object var8_9 = null;
            while (sourceMappingListIterator.hasNext()) {
                void var8_10;
                SourceMapping source = sourceMappingListIterator.next();
                if (var8_10 == null || var8_10.pcOffset < source.getStartOffset()) {
                    while (siteListIterator.hasNext()) {
                        Site site = (Site)siteListIterator.next();
                        if (site.pcOffset < source.getStartOffset()) continue;
                    }
                }
                assert (!siteListIterator.hasNext() || var8_10 != null && var8_10.pcOffset >= source.getStartOffset());
                if (var8_10 != null && source.getStartOffset() <= var8_10.pcOffset && var8_10.pcOffset <= source.getEndOffset()) continue;
                assert (!siteListIterator.hasNext() || var8_10 != null && var8_10.pcOffset > source.getEndOffset());
                NodeSourcePosition sourcePosition = source.getSourcePosition();
                assert (sourcePosition.verify());
                if (!Options.ShowSubstitutionSourceInfo.getValue(options).booleanValue()) {
                    sourcePosition = sourcePosition.trim();
                    assert (HotSpotCompiledCodeBuilder.verifyTrim(sourcePosition));
                }
                while (sourcePosition != null && !(sourcePosition.getMethod() instanceof HotSpotResolvedJavaMethod)) {
                    sourcePosition = sourcePosition.getCaller();
                }
                if (sourcePosition == null) continue;
                assert (!CollectionsUtil.anyMatch(sites, s -> source.getStartOffset() <= s.pcOffset && s.pcOffset <= source.getEndOffset()));
                sourcePositionSites.add(new Infopoint(source.getEndOffset(), new DebugInfo((BytecodePosition)sourcePosition), InfopointReason.BYTECODE_POSITION));
            }
            sites.addAll(sourcePositionSites);
        }
        SiteComparator c = new SiteComparator();
        Collections.sort(sites, c);
        if (c.sawCollidingInfopoints) {
            Infopoint lastInfopoint = null;
            ArrayList<Object> copy = new ArrayList<Object>(sites.size());
            for (Site site : sites) {
                if (site instanceof Infopoint) {
                    Infopoint info = (Infopoint)site;
                    if (lastInfopoint == null || lastInfopoint.pcOffset != info.pcOffset) {
                        lastInfopoint = info;
                        copy.add(info);
                        continue;
                    }
                    assert (lastInfopoint.reason.compareTo((Enum)info.reason) <= 0);
                    continue;
                }
                copy.add(site);
            }
            sites = copy;
        }
        return sites.toArray(new Site[sites.size()]);
    }

    private static boolean verifyTrim(NodeSourcePosition sourcePosition) {
        for (NodeSourcePosition sp = sourcePosition; sp != null; sp = sp.getCaller()) {
            assert (!sp.isSubstitution());
        }
        return true;
    }

    static class SiteComparator
    implements Comparator<Site> {
        static final Map<InfopointReason, Integer> HOTSPOT_INFOPOINT_SORT_ORDER = new EnumMap<InfopointReason, Integer>(InfopointReason.class);
        boolean sawCollidingInfopoints;

        SiteComparator() {
        }

        static int ord(Infopoint info) {
            return HOTSPOT_INFOPOINT_SORT_ORDER.get(info.reason);
        }

        static int checkCollision(Infopoint i1, Infopoint i2) {
            int o1 = SiteComparator.ord(i1);
            int o2 = SiteComparator.ord(i2);
            if (o1 < 0 && o2 < 0) {
                throw new GraalError("Non optional infopoints cannot collide: %s and %s", i1, i2);
            }
            return o1 - o2;
        }

        @Override
        public int compare(Site s1, Site s2) {
            if (s1.pcOffset == s2.pcOffset) {
                boolean s1IsMark = s1 instanceof Mark;
                boolean s2IsMark = s2 instanceof Mark;
                if (s1IsMark != s2IsMark) {
                    return s1IsMark ? -1 : 1;
                }
                boolean s1IsInfopoint = s1 instanceof Infopoint;
                boolean s2IsInfopoint = s2 instanceof Infopoint;
                if (s1IsInfopoint != s2IsInfopoint) {
                    return s1IsInfopoint ? 1 : -1;
                }
                if (s1IsInfopoint) {
                    this.sawCollidingInfopoints = true;
                    return SiteComparator.checkCollision((Infopoint)s1, (Infopoint)s2);
                }
            }
            return s1.pcOffset - s2.pcOffset;
        }

        static {
            HOTSPOT_INFOPOINT_SORT_ORDER.put(InfopointReason.SAFEPOINT, -4);
            HOTSPOT_INFOPOINT_SORT_ORDER.put(InfopointReason.CALL, -3);
            HOTSPOT_INFOPOINT_SORT_ORDER.put(InfopointReason.IMPLICIT_EXCEPTION, -2);
            HOTSPOT_INFOPOINT_SORT_ORDER.put(InfopointReason.METHOD_START, 2);
            HOTSPOT_INFOPOINT_SORT_ORDER.put(InfopointReason.METHOD_END, 3);
            HOTSPOT_INFOPOINT_SORT_ORDER.put(InfopointReason.BYTECODE_POSITION, 4);
        }
    }

    public static class Options {
        @Option(help={"Controls whether the source position information of snippets and method substitutions are exposed to HotSpot.  Can be useful when profiling to get more precise position information."})
        public static final OptionKey<Boolean> ShowSubstitutionSourceInfo = new OptionKey<Boolean>(false);
    }
}

