/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotCounterOp;
import org.graalvm.compiler.hotspot.debug.BenchmarkCounters;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="BenchMarkCounter")
public class AArch64HotSpotCounterOp
extends HotSpotCounterOp {
    public static final LIRInstructionClass<AArch64HotSpotCounterOp> TYPE = LIRInstructionClass.create(AArch64HotSpotCounterOp.class);

    public AArch64HotSpotCounterOp(String name, String group, Value increment, HotSpotRegistersProvider registers, GraalHotSpotVMConfig config) {
        super(TYPE, name, group, increment, registers, config);
    }

    public AArch64HotSpotCounterOp(String[] names, String[] groups, Value[] increments, HotSpotRegistersProvider registers, GraalHotSpotVMConfig config) {
        super(TYPE, names, groups, increments, registers, config);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb) {
        AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
        TargetDescription target = crb.target;
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
            Register scratch1 = sc1.getRegister();
            Register scratch2 = sc2.getRegister();
            AArch64Address countersArrayAddr = masm.makeAddress(64, this.thread, this.config.jvmciCountersThreadOffset, scratch2);
            masm.ldr(64, scratch1, countersArrayAddr);
            HotSpotCounterOp.CounterProcedure emitProcedure = (counterIndex, increment, displacement) -> AArch64HotSpotCounterOp.emitIncrement(crb, masm, scratch1, increment, displacement, scratch2);
            this.forEachCounter(emitProcedure, target);
        }
    }

    private static void emitIncrement(CompilationResultBuilder crb, AArch64MacroAssembler masm, Register countersArrayReg, Value incrementValue, int displacement, Register scratch) {
        boolean restoreCounterAddr = false;
        AArch64Address counterAddr = masm.tryMakeAddress(64, countersArrayReg, displacement);
        if (counterAddr == null) {
            restoreCounterAddr = true;
            masm.add(64, countersArrayReg, countersArrayReg, displacement);
            counterAddr = masm.makeAddress(64, countersArrayReg, 0);
        }
        masm.ldr(64, scratch, counterAddr);
        if (LIRValueUtil.isJavaConstant(incrementValue)) {
            masm.adds(64, scratch, scratch, AArch64HotSpotCounterOp.asInt(LIRValueUtil.asJavaConstant(incrementValue)));
        } else {
            masm.adds(64, scratch, scratch, ValueUtil.asRegister((Value)incrementValue));
        }
        if (BenchmarkCounters.Options.AbortOnBenchmarkCounterOverflow.getValue(crb.getOptions()).booleanValue()) {
            Label noOverflow = new Label();
            masm.branchConditionally(AArch64Assembler.ConditionFlag.VC, noOverflow);
            crb.blockComment("[BENCHMARK COUNTER OVERFLOW]");
            masm.illegal();
            masm.bind(noOverflow);
        }
        masm.str(64, scratch, counterAddr);
        if (restoreCounterAddr) {
            masm.sub(64, countersArrayReg, countersArrayReg, displacement);
        }
    }
}

